/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.programlist;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.midi.programlist.GMLevel1;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDDrumSet;
import jp.synthtarou.midimixer.libs.text.MXLineReader;

public class GMLevel1Drum
extends PDDrumSet {
    public GMLevel1Drum() {
        try {
            InputStream stream = GMLevel1.class.getResourceAsStream("GMLevel1Drum.csv");
            this.readCSV(stream, "Shift_JIS");
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readCSV(InputStream stream, String charset) {
        MXLineReader reader = new MXLineReader(stream, charset);
        String folder = "";
        ArrayList<String> cells = new ArrayList<String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) {
                    folder = line.substring(1);
                    continue;
                }
                MXUtil.split(line, cells, ',');
                if (cells.size() < 4) continue;
                try {
                    String noteNumber = cells.get(0);
                    String noteKey1 = cells.get(1);
                    String nameEnglish = cells.get(2);
                    String noteKey2 = cells.get(3);
                    this.addNote(MXUtil.parseTextForNumber(noteNumber), nameEnglish);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

