/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.programlist;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.common.log.MXDebugPrint;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDBank;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDMap;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDModule;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDProgram;
import jp.synthtarou.midimixer.libs.text.MXLineReader;

public class GMLevel1
extends PDModule {
    private static final MXDebugPrint _debug = new MXDebugPrint(GMLevel1.class);

    public GMLevel1() {
        super("System Default");
        try {
            InputStream stream = GMLevel1.class.getResourceAsStream("GMLevel1.csv");
            this.readCSV(stream, "Shift_JIS");
            stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void readCSV(InputStream stream, String charset) {
        MXLineReader reader = new MXLineReader(stream, charset);
        String folder = "";
        int folderId = 0;
        ArrayList<String> cells = new ArrayList<String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) {
                    folder = line.substring(1);
                    ++folderId;
                    continue;
                }
                MXUtil.split(line, cells, ',');
                if (cells.size() < 4) continue;
                try {
                    String dispCode = cells.get(0);
                    String numberHex = cells.get(1);
                    String nameEnglish = cells.get(2);
                    String nameLocalized = cells.get(3);
                    int programNumber = MXUtil.parseTextForNumber(dispCode) - 1;
                    GMLevel1 pdmodule = this;
                    PDMap pdmap = pdmodule.smartReserve(this.getName());
                    PDProgram pdprogram = pdmap.smartReserve(programNumber, nameEnglish);
                    PDBank pDBank = pdprogram.smartReserve(-1, -1, nameEnglish);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

