/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.programlist;

import jp.synthtarou.midimixer.libs.common.MXWrap;
import jp.synthtarou.midimixer.libs.domino.DTextFolder;
import jp.synthtarou.midimixer.libs.domino.DTextMessage;
import jp.synthtarou.midimixer.libs.domino.DTextMessageList;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXUtilMidi;
import jp.synthtarou.midimixer.libs.midi.programlist.GMLevel1;
import jp.synthtarou.midimixer.libs.midi.programlist.GMLevel1Drum;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDBank;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDDrumSet;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDFile;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDModule;

public class GMFile
implements PDFile {
    PDModule module = new GMLevel1();
    PDDrumSet drumSet = new GMLevel1Drum();
    PDModule drumModule = null;
    DTextMessageList ccList;

    @Override
    public String getName() {
        return "system Default";
    }

    @Override
    public PDModule getModule() {
        return this.module;
    }

    @Override
    public PDModule getDrumSet() {
        if (this.drumModule == null) {
            this.drumModule = new PDModule();
            PDBank bank = this.drumModule.smartReserve(this.getName()).smartReserve(0, "Standard Kit").smartReserve(-1, -1, "Standard Kit");
            bank.smartReserve(this.drumSet);
        }
        return this.drumModule;
    }

    @Override
    public DTextMessageList getCCList() {
        if (this.ccList == null) {
            this.ccList = new DTextMessageList();
            DTextFolder commandFolder = this.ccList.addFolder("Command", "Command");
            DTextFolder ccFolder = this.ccList.addFolder("Control Change", "Control Change");
            for (MXWrap mXWrap : MXUtilMidi.createCommand()) {
                int command = (Integer)mXWrap.value;
                if (command == 176) continue;
                String name = MXUtilMidi.nameOfChannelMessage(command);
                MXMessage message = MXMessageFactory.fromShortMessage(0, command, 0, 0);
                DTextMessage text = new DTextMessage(name, message.toDText(), message.getGate());
                commandFolder.addMessage(text);
            }
            for (int i = 0; i < 128; ++i) {
                try {
                    MXMessage mXMessage = MXMessageFactory.fromShortMessage(0, 176, i, 0);
                    DTextMessage text = new DTextMessage(MXUtilMidi.nameOfControlChange(i), mXMessage.toDText(), mXMessage.getGate());
                    ccFolder.addMessage(text);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return this.ccList;
    }
}

