/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.port;

import java.io.File;
import java.util.ArrayList;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.common.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.driver.MXDriver_Empty;
import jp.synthtarou.midimixer.libs.midi.driver.MXDriver_Java;
import jp.synthtarou.midimixer.libs.midi.driver.MXDriver_UWP;
import jp.synthtarou.midimixer.libs.midi.driver.MXDriver_VSTi;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIOut;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;
import org.xml.sax.SAXException;

public class MXMIDIOutManager
implements MXSettingTarget {
    private static final MXMIDIOutManager _instance = new MXMIDIOutManager();
    private MXSetting _setting;
    protected MXWrapList<MXMIDIOut> _listAllOutput;
    protected MXWrapList<MXMIDIOut> _selectedOutput = null;

    public static MXMIDIOutManager getManager() {
        return _instance;
    }

    public void reloadDeviceList() {
    }

    public void initWithSetting() {
        if (this._setting == null) {
            this._setting = new MXSetting("MIDIOutput");
            this._setting.setTarget(this);
            MXWrapList<MXMIDIOut> listOut = this.listAllOutput();
            this._setting.readSettingFile();
            MXWrapList<MXMIDIOut> list = this.listAllOutput();
            boolean assigned = false;
            for (int i = 0; i < list.getSize(); ++i) {
                MXMIDIOut out = list.valueOfIndex(i);
                if (out.getPortAssignCount() <= 0) continue;
                assigned = true;
            }
        }
    }

    protected MXMIDIOutManager() {
    }

    public synchronized MXWrapList<MXMIDIOut> listAllOutput() {
        if (this._listAllOutput != null) {
            return this._listAllOutput;
        }
        MXWrapList<MXMIDIOut> temp = new MXWrapList<MXMIDIOut>();
        MXDriver_Java java = MXDriver_Java._instance;
        for (int i = 0; i < java.OutputDevicesRoomSize(); ++i) {
            MXMIDIOut device = new MXMIDIOut(java, i);
            String name = device.getName();
            if (MXDriver_UWP._instance.isUsable() && (name.equals("Real Time Sequencer") || name.equals("Unknown name") || name.startsWith("Microsoft GS Wave"))) continue;
            temp.addNameAndValue(device.getName(), device);
        }
        if (MXDriver_UWP._instance.isUsable()) {
            MXDriver_UWP uwp = MXDriver_UWP._instance;
            for (int i = 0; i < uwp.OutputDevicesRoomSize(); ++i) {
                MXMIDIOut device = new MXMIDIOut(uwp, i);
                temp.addNameAndValue(device.getName(), device);
            }
        }
        if (MXDriver_VSTi._instance.isUsable()) {
            MXDriver_VSTi vst = MXDriver_VSTi._instance;
            for (int i = 0; i < vst.OutputDevicesRoomSize(); ++i) {
                MXMIDIOut out = new MXMIDIOut(MXDriver_VSTi._instance, i);
                temp.addNameAndValue(out.getName(), out);
            }
        }
        this._listAllOutput = temp;
        return this._listAllOutput;
    }

    public MXMIDIOut findMIDIOutput(String deviceName) {
        MXWrapList<MXMIDIOut> model = this.listAllOutput();
        return model.valueOfName(deviceName);
    }

    synchronized void onClose(MXMIDIOut output) {
        this.clearMIDIOutCache();
    }

    protected synchronized void clearMIDIOutCache() {
        this._selectedOutput = null;
    }

    public synchronized MXWrapList<MXMIDIOut> listSelectedOutput() {
        if (this._selectedOutput != null) {
            return this._selectedOutput;
        }
        this._selectedOutput = new MXWrapList();
        for (MXMIDIOut midi : this.listAllOutput().valueList()) {
            if (midi.getPortAssignCount() == 0) continue;
            this._selectedOutput.addNameAndValue(midi.getName(), midi);
        }
        return this._selectedOutput;
    }

    public synchronized void closeAll() {
        for (MXMIDIOut output : this.listAllOutput().valueList()) {
            if (!output.isOpen()) continue;
            System.out.println("closing output " + output);
            output.close();
        }
    }

    @Override
    public void prepareSettingFields(MXSetting setting) {
        setting.register("device[].name");
        setting.register("device[].open");
        setting.register("device[].port");
        setting.register("device[].fromDXML");
    }

    @Override
    public void afterReadSettingFile(MXSetting setting) {
        MXDriver_Empty dummy = MXDriver_Empty.getInstance();
        for (int seek = 0; seek < 1000; ++seek) {
            File f;
            MXWrapList<MXMIDIOut> detected;
            MXMIDIOut out;
            String deviceName = setting.getSetting("device[" + seek + "].name");
            String deviceOpen = setting.getSetting("device[" + seek + "].open");
            String devicePort = setting.getSetting("device[" + seek + "].port");
            String deviceFile = setting.getSetting("device[" + seek + "].fromDXML");
            if (deviceName == null || deviceName.length() == 0) break;
            if (deviceOpen == null) {
                deviceOpen = "0";
            }
            if (deviceOpen.equals("1") && devicePort == null) {
                devicePort = String.valueOf(seek);
            }
            if ((out = (detected = this.listAllOutput()).valueOfName(deviceName)) != null) {
                if (deviceOpen.equals("1")) {
                    out.openOutput(5L);
                }
            } else {
                out = new MXMIDIOut(dummy, dummy.OuputAddDevice(deviceName));
                detected.addNameAndValue(deviceName, out);
            }
            ArrayList<String> split = new ArrayList<String>();
            MXUtil.split(devicePort, split, ',');
            for (String t1 : split) {
                try {
                    int x = Integer.parseInt(t1);
                    out.setPortAssigned(x, true);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (deviceFile == null || !(f = new File(deviceFile)).isFile()) continue;
            try {
                out.setDXMLFile(f);
                continue;
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
        this.clearMIDIOutCache();
    }

    @Override
    public void beforeWriteSettingFile(MXSetting setting) {
        MXWrapList<MXMIDIOut> all = this.listAllOutput();
        int x = 0;
        for (MXMIDIOut e : all.valueList()) {
            StringBuffer assigned = new StringBuffer();
            for (int p = 0; p < 16; ++p) {
                if (!e.isPortAssigned(p)) continue;
                if (assigned.length() > 0) {
                    assigned.append(",");
                }
                assigned.append(Integer.toString(p));
            }
            if (assigned.length() <= 0) continue;
            setting.setSetting("device[" + x + "].name", e.getName());
            setting.setSetting("device[" + x + "].open", e.isOpen() ? "1" : "0");
            setting.setSetting("device[" + x + "].port", assigned.toString());
            setting.setSetting("device[" + x + "].fromDXML", e.getDXMLFile() == null ? "" : e.getDXMLFile().getPath());
            ++x;
        }
    }
}

