/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.port;

import java.io.File;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.MXQueue1;
import jp.synthtarou.midimixer.libs.common.log.MXDebugPrint;
import jp.synthtarou.midimixer.libs.console.ConsoleElement;
import jp.synthtarou.midimixer.libs.domino.DTextXML;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXNoteOffWatcher;
import jp.synthtarou.midimixer.libs.midi.MXTiming;
import jp.synthtarou.midimixer.libs.midi.driver.MXDriver;
import jp.synthtarou.midimixer.libs.midi.driver.MXDriver_Java;
import jp.synthtarou.midimixer.libs.midi.driver.MXDriver_UWP;
import jp.synthtarou.midimixer.libs.midi.driver.MXDriver_VSTi;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIInManager;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIOutManager;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant16;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDFileManager;
import org.xml.sax.SAXException;

public class MXMIDIOut {
    private static final MXDebugPrint _debug = new MXDebugPrint(MXMIDIOut.class);
    public static final MXMIDIOut OUTPUT_NONE = new MXMIDIOut(null, 0);
    private MXDriver _driver;
    private int _driverOrder;
    private String _name;
    boolean[] _assigned;
    int _assignCount;
    private File _DXMLFile;
    private MXVisitant16 _visitant16 = new MXVisitant16();
    MXQueue1<MXMessage> _queue;
    Thread _thread;
    private MXNoteOffWatcher _myNoteOff = new MXNoteOffWatcher();
    long startTime = System.currentTimeMillis();

    public MXDriver getDriver() {
        return this._driver;
    }

    public int getDriverOrder() {
        return this._driverOrder;
    }

    public boolean isPortAssigned(int port) {
        if (port < 0 || port >= 16) {
            return false;
        }
        return this._assigned[port];
    }

    public int getPortAssignCount() {
        return this._assignCount;
    }

    public String getPortAssignedAsText() {
        StringBuffer assigned = new StringBuffer();
        for (int p = 0; p < 16; ++p) {
            if (!this.isPortAssigned(p)) continue;
            if (assigned.length() > 0) {
                assigned.append(",");
            }
            assigned.append((char)(65 + p));
        }
        return assigned.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortAssigned(int port, boolean flag) {
        MXMIDIInManager mXMIDIInManager = MXMIDIInManager.getManager();
        synchronized (mXMIDIInManager) {
            if (this._assigned[port] != flag) {
                if (!flag) {
                    this._myNoteOff.allNoteFromPort(new MXTiming(), port);
                }
                this._assigned[port] = flag;
                int x = 0;
                for (int i = 0; i < this._assigned.length; ++i) {
                    if (!this._assigned[i]) continue;
                    ++x;
                }
                this._assignCount = x;
                MXMIDIOutManager.getManager().clearMIDIOutCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetPortAssigned() {
        MXMIDIInManager mXMIDIInManager = MXMIDIInManager.getManager();
        synchronized (mXMIDIInManager) {
            for (int i = 0; i < 16; ++i) {
                this.setPortAssigned(i, false);
            }
        }
    }

    public boolean isOpen() {
        return this._driver.OutputDeviceIsOpen(this._driverOrder);
    }

    protected MXMIDIOut(MXDriver driver, int driverOrder) {
        this._assigned = new boolean[16];
        this._driver = driver;
        this._driverOrder = driverOrder;
        this._name = driver == null ? "(NULL)" : driver.OutputDeviceName(driverOrder);
    }

    public String getName() {
        return this._name;
    }

    public File getDXMLFile() {
        return this._DXMLFile;
    }

    public void setDXMLFile(File file) throws SAXException {
        try {
            PDFileManager manager = PDFileManager.getManager();
            if (this._DXMLFile != null) {
                manager.unregist(this._DXMLFile.getName());
            }
            DTextXML parser = DTextXML.fromFile(file);
            this._DXMLFile = file;
            manager.register(parser);
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        MXMIDIOut out = (MXMIDIOut)o;
        return out._name == this._name;
    }

    public String toString() {
        return this._name;
    }

    public long getTimestamp() {
        try {
            return System.currentTimeMillis() - this.startTime;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public void processMidiOut(MXMessage message) {
        try {
            this.processMidiOutInternal(message);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public synchronized void outputLongMessage(byte[] data) {
        this._driver.OutputLongMessage(this._driverOrder, data);
    }

    private synchronized void processMidiOutInternal(MXMessage message) {
        if (!this._driver.OutputDeviceIsOpen(this._driverOrder)) {
            return;
        }
        MXMain.addInsideOutput(message);
        try {
            int col;
            if (MXVisitant.isMesssageHaveVisitant(message)) {
                this._visitant16.get(message.getChannel()).updateVisitantChannel(message);
            }
            long timeStamp = this.getTimestamp();
            long recTime = 0L;
            if (message.isMessageTypeChannel()) {
                MXMessage newMessage;
                MXVisitant msgVisitant = message.getVisitant();
                MXVisitant visitant = this._visitant16.get(message.getChannel());
                int command = message.getCommand();
                int channel = message.getChannel();
                int gate = message.getGate();
                if (command != 192 && msgVisitant != null && msgVisitant.isHavingProgram() && (!visitant.isHavingProgram() || visitant.getProgram() != message.getVisitant().getProgram())) {
                    visitant.mergeNew(message.getVisitant());
                    newMessage = MXMessageFactory.fromShortMessage(message.getPort(), 192 + channel, visitant.getProgram(), 0);
                    newMessage._timing = message._timing;
                    newMessage.setVisitant(visitant.getSnapShot());
                    this.processMidiOutInternal(newMessage);
                }
                if ((command != 176 || gate != 0 && gate != 32) && msgVisitant != null && msgVisitant.isHavingBank() && (!visitant.isHavingBank() || visitant.getBankMSB() != msgVisitant.getBankMSB() || visitant.getBankLSB() != msgVisitant.getBankLSB())) {
                    visitant.mergeNew(message.getVisitant());
                    MXMessage newMessage1 = MXMessageFactory.fromShortMessage(message.getPort(), 176 + channel, 0, visitant._bankMSB);
                    MXMessage newMessage2 = MXMessageFactory.fromShortMessage(message.getPort(), 176 + channel, 32, visitant._bankLSB);
                    newMessage1._timing = message._timing;
                    newMessage2._timing = message._timing;
                    this.processMidiOutInternal(newMessage1);
                    this.processMidiOutInternal(newMessage2);
                }
                if (!(command == 176 && gate == 7 || msgVisitant == null || !msgVisitant.isHavingVolume() || visitant.isHavingVolume() && visitant.getInfoVolume() == msgVisitant.getInfoVolume())) {
                    visitant.mergeNew(message.getVisitant());
                    newMessage = MXMessageFactory.fromShortMessage(message.getPort(), 176 + channel, 7, visitant.getInfoVolume());
                    newMessage._timing = message._timing;
                    this.processMidiOutInternal(newMessage);
                }
                if (!(command == 176 && gate == 11 || msgVisitant == null || !msgVisitant.isHavingExpression() || visitant.isHavingExpression() && visitant.getInfoExpression() == msgVisitant.getInfoExpression())) {
                    visitant.mergeNew(message.getVisitant());
                    newMessage = MXMessageFactory.fromShortMessage(message.getPort(), 176 + channel, 11, visitant.getInfoExpression());
                    newMessage._timing = message._timing;
                    this.processMidiOutInternal(newMessage);
                }
                if (!(command == 176 && gate == 10 || msgVisitant == null || !msgVisitant.isHavingExpression() || visitant.isHavingPan() && visitant.getInfoPan() == msgVisitant.getInfoPan())) {
                    visitant.mergeNew(message.getVisitant());
                    newMessage = MXMessageFactory.fromShortMessage(message.getPort(), 176 + channel, 10, visitant.getInfoPan());
                    newMessage._timing = message._timing;
                    this.processMidiOutInternal(newMessage);
                }
            }
            if (message.getCommand() == 144) {
                this._myNoteOff.setHandler(message, message, new MXNoteOffWatcher.Handler(){

                    @Override
                    public void onNoteOffEvent(MXMessage target) {
                        int dword = target.getAsDword(0);
                        MXMIDIOut.this._driver.OutputShortMessage(MXMIDIOut.this._driverOrder, dword);
                        MXMain.addOutsideOutput(new ConsoleElement(target._timing, target.getPort(), dword));
                    }
                });
                int dword = message.getAsDword(0);
                this._driver.OutputShortMessage(this._driverOrder, dword);
                MXMain.addOutsideOutput(new ConsoleElement(message._timing, message.getPort(), dword));
                return;
            }
            if (message.getCommand() == 128) {
                if (this._myNoteOff.raiseHandler(message)) {
                    return;
                }
            } else if (message.getCommand() == 176 && message.getData1() == 123) {
                this.allNoteOff();
            }
            if ((col = message.getDwordCount()) == 0) {
                byte[] data = message.getDataBytes();
                this._driver.OutputLongMessage(this._driverOrder, data);
            } else if (col > 0) {
                for (int i = 0; i < col; ++i) {
                    int dword = message.getAsDword(i);
                    this._driver.OutputShortMessage(this._driverOrder, dword);
                    MXMain.addOutsideOutput(new ConsoleElement(message._timing, message.getPort(), dword));
                }
            } else {
                if (message.isDataentry()) {
                    if (message.getVisitant() == null) {
                        System.out.println("DATAENTRY no set VISITANT");
                        return;
                    }
                    if (!message.getVisitant().isHaveDataentryRPN() && !message.getVisitant().isHaveDataentryNRPN()) {
                        System.out.println("DATAENTRY no set RPN / NRPN");
                        return;
                    }
                }
                System.out.println("nothing to send : " + message);
            }
        }
        catch (Throwable e) {
            _debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allNoteOff() {
        Object object = MXTiming.mutex;
        synchronized (object) {
            this._myNoteOff.allNoteOff(new MXTiming());
        }
    }

    public void allNoteOffFromPort(MXTiming timing, int port) {
        this._myNoteOff.allNoteFromPort(timing, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openOutput(long timeout) {
        MXMIDIOutManager manager;
        MXMIDIOutManager mXMIDIOutManager = manager = MXMIDIOutManager.getManager();
        synchronized (mXMIDIOutManager) {
            manager.clearMIDIOutCache();
            this._visitant16 = new MXVisitant16();
            if (!this._driver.OutputDeviceIsOpen(this._driverOrder)) {
                this._driver.OutputDeviceOpen(this._driverOrder, timeout);
            }
            return this._driver.OutputDeviceIsOpen(this._driverOrder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MXMIDIOutManager manager;
        MXMIDIOutManager mXMIDIOutManager = manager = MXMIDIOutManager.getManager();
        synchronized (mXMIDIOutManager) {
            if (this.isOpen()) {
                this.allNoteOff();
                if (!this._name.equals("Gervill")) {
                    manager.onClose(this);
                    this._driver.OutputDeviceClose(this._driverOrder);
                }
            }
        }
    }

    public boolean isDriverTypeVSTi() {
        return this._driver instanceof MXDriver_VSTi;
    }

    public int getVStiDriverNumber() {
        if (this._driver instanceof MXDriver_VSTi) {
            return this._driverOrder;
        }
        return -1;
    }

    public boolean isDriverTypeJava() {
        return this._driver instanceof MXDriver_Java;
    }

    public boolean isDriverTypeUWP() {
        return this._driver instanceof MXDriver_UWP;
    }
}

