/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.port;

import java.util.ArrayList;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.common.MXWrapList;
import jp.synthtarou.midimixer.libs.common.log.MXDebugPrint;
import jp.synthtarou.midimixer.libs.midi.driver.MXDriver_Empty;
import jp.synthtarou.midimixer.libs.midi.driver.MXDriver_Java;
import jp.synthtarou.midimixer.libs.midi.driver.MXDriver_UWP;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIIn;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIInForPlayer;
import jp.synthtarou.midimixer.libs.settings.MXSetting;
import jp.synthtarou.midimixer.libs.settings.MXSettingTarget;

public class MXMIDIInManager
implements MXSettingTarget {
    private static final MXDebugPrint _debug = new MXDebugPrint(MXMIDIInManager.class);
    private static final MXMIDIInManager _instance = new MXMIDIInManager();
    private MXSetting _setting;
    protected MXWrapList<MXMIDIIn> _listAllInput;
    protected MXWrapList<MXMIDIIn> _listUsingInput;

    public static MXMIDIInManager getManager() {
        return _instance;
    }

    public void reloadDeviceList() {
    }

    protected MXMIDIInManager() {
    }

    public int getFreeAssignPort() {
        int found = -1;
        for (int i = 0; i < 16; ++i) {
            boolean entered = false;
            for (MXMIDIIn in : this.listAllInput().valueList()) {
                if (!in.isPortAssigned(i)) continue;
                entered = true;
                break;
            }
            if (entered) continue;
            found = i;
            break;
        }
        return found;
    }

    public void initWithSetting() {
        if (this._setting == null) {
            this._setting = new MXSetting("MIDIInput");
            this._setting.setTarget(this);
            MXWrapList<MXMIDIIn> list = this.listAllInput();
            this._setting.readSettingFile();
            boolean assigned = false;
            for (int i = 0; i < list.getSize(); ++i) {
                MXMIDIIn in = list.valueOfIndex(i);
                if (in.getPortAssignCount() <= 0) continue;
                assigned = true;
            }
            if (!assigned) {
                MXMIDIIn.INTERNAL_PLAYER.setPortAssigned(0, true);
            }
        }
    }

    public synchronized MXWrapList<MXMIDIIn> listAllInput() {
        if (this._listAllInput != null) {
            return this._listAllInput;
        }
        MXWrapList<MXMIDIIn> temp = new MXWrapList<MXMIDIIn>();
        MXMIDIInForPlayer sequencer = MXMIDIIn.INTERNAL_PLAYER;
        temp.addNameAndValue(sequencer.getName(), sequencer);
        MXDriver_Java java = MXDriver_Java._instance;
        for (int i = 0; i < java.InputDevicesRoomSize(); ++i) {
            MXMIDIIn device = new MXMIDIIn(java, i);
            try {
                if (device.getName().equals("Real Time Sequencer")) continue;
                temp.addNameAndValue(device.getName(), device);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MXDriver_UWP uwp = MXDriver_UWP._instance;
        for (int i = 0; i < uwp.InputDevicesRoomSize(); ++i) {
            MXMIDIIn device = new MXMIDIIn(uwp, i);
            try {
                if (device.getName().equals("Real Time Sequencer")) continue;
                temp.addNameAndValue(device.getName(), device);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._listAllInput = temp;
        return this._listAllInput;
    }

    synchronized void onClose(MXMIDIIn input) {
        this.clearMIDIInCache();
    }

    protected synchronized void clearMIDIInCache() {
        this._listUsingInput = null;
    }

    public synchronized MXWrapList<MXMIDIIn> listSelectedInput() {
        if (this._listUsingInput != null) {
            return this._listUsingInput;
        }
        MXWrapList<MXMIDIIn> newInput = new MXWrapList<MXMIDIIn>();
        for (MXMIDIIn midi : this.listAllInput().valueList()) {
            if (midi.getPortAssignCount() <= 0) continue;
            newInput.addNameAndValue(midi.toString(), midi);
        }
        this._listUsingInput = newInput;
        return newInput;
    }

    public synchronized void closeAll() {
        for (MXMIDIIn input : this.listAllInput().valueList()) {
            if (!input.isOpen()) continue;
            System.out.println("closing input " + input);
            input.close();
        }
    }

    @Override
    public void prepareSettingFields(MXSetting setting) {
        setting.register("device[].name");
        setting.register("device[].open");
        setting.register("device[].port");
        setting.register("device[].toMaster");
    }

    @Override
    public void afterReadSettingFile(MXSetting setting) {
        MXDriver_Empty dummy = MXDriver_Empty.getInstance();
        for (int seek = 0; seek < 1000; ++seek) {
            String deviceName = setting.getSetting("device[" + seek + "].name");
            String deviceOpen = setting.getSetting("device[" + seek + "].open");
            String deviceMaster = setting.getSetting("device[" + seek + "].toMaster");
            String devicePort = setting.getSetting("device[" + seek + "].port");
            if (deviceName == null || deviceName.length() == 0) break;
            if (devicePort == null || devicePort.length() == 0) {
                devicePort = String.valueOf(seek);
            }
            try {
                MXWrapList<MXMIDIIn> detected;
                MXMIDIIn in;
                if (deviceName == null) continue;
                if (deviceOpen == null) {
                    deviceOpen = "0";
                }
                if (deviceOpen.equals("1") && devicePort == null) {
                    devicePort = String.valueOf(seek);
                }
                if ((in = (detected = this.listAllInput()).valueOfName(deviceName)) != null) {
                    if (deviceOpen.equals("1")) {
                        in.openInput(5000L);
                    }
                } else {
                    in = new MXMIDIIn(dummy, dummy.InputAddDevice(deviceName));
                    in.setPortAssigned(seek, true);
                    detected.addNameAndValue(deviceName, in);
                }
                ArrayList<String> split = new ArrayList<String>();
                MXUtil.split(devicePort, split, ',');
                for (String t1 : split) {
                    try {
                        int x = Integer.parseInt(t1);
                        in.setPortAssigned(x, true);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                in.setMasterList(deviceMaster);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.clearMIDIInCache();
    }

    @Override
    public void beforeWriteSettingFile(MXSetting setting) {
        MXWrapList<MXMIDIIn> all = this.listAllInput();
        int x = 0;
        for (MXMIDIIn e : all.valueList()) {
            if (e.getPortAssignCount() <= 0) continue;
            StringBuffer assigned = new StringBuffer();
            for (int p = 0; p < 16; ++p) {
                if (!e.isPortAssigned(p)) continue;
                if (assigned.length() > 0) {
                    assigned.append(",");
                }
                assigned.append(Integer.toString(p));
            }
            if (assigned.length() <= 0) continue;
            setting.setSetting("device[" + x + "].name", e.getName());
            setting.setSetting("device[" + x + "].open", e.isOpen() ? "1" : "0");
            setting.setSetting("device[" + x + "].port", assigned.toString());
            setting.setSetting("device[" + x + "].toMaster", e.getMasterList());
            ++x;
        }
    }
}

