/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.port;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiUnavailableException;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.MXThreadList;
import jp.synthtarou.midimixer.libs.common.log.MXDebugPrint;
import jp.synthtarou.midimixer.libs.midi.MXException;
import jp.synthtarou.midimixer.libs.midi.driver.MXDriver_PlayList;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIIn;
import jp.synthtarou.midimixer.libs.midi.smf.SMFCallback;
import jp.synthtarou.midimixer.libs.midi.smf.SMFMessage;
import jp.synthtarou.midimixer.libs.midi.smf.SMFMessageList;
import jp.synthtarou.midimixer.libs.midi.smf.SMFPlayer;

public class MXMIDIInForPlayer
extends MXMIDIIn {
    private static final MXDebugPrint _debug = new MXDebugPrint(MXMIDIInForPlayer.class);
    boolean[] _existNoteChannel = new boolean[16];
    private SMFPlayer _sequencer = null;
    private boolean _gotBreak = false;
    int _firstNotePos = -1;

    public MXMIDIInForPlayer() {
        super(new MXDriver_PlayList(), 0);
    }

    public void openFile(File file) throws IOException, MidiUnavailableException, InvalidMidiDataException {
        int hi2;
        String fileName = file.toString();
        if (this._sequencer != null) {
            this._sequencer.allNoteOff();
            if (this._sequencer.getLastFile().equals(file)) {
                return;
            }
            this._sequencer = null;
        }
        int _noteLowest = 200;
        int _noteHighest = 0;
        this._sequencer = new SMFPlayer(file);
        int[] programList = new int[16];
        ArrayList<Integer> drums = new ArrayList<Integer>();
        int firstNotePos = -1;
        ArrayList<SMFMessage> list = this._sequencer.listMessage().listAll();
        for (int i = 0; i < list.size(); ++i) {
            int msg = 0;
            if (list.get(i).isBinaryMessage()) continue;
            try {
                msg = list.get(i).toDwordMessage();
            }
            catch (MXException e) {
                continue;
            }
            int status = msg >> 8 >> 8;
            int command = status & 0xF0;
            int ch = status & 0xF;
            int data1 = msg >> 8 & 0xFF;
            int data2 = msg & 0xFF;
            if (command == 144) {
                if (firstNotePos < 0) {
                    firstNotePos = i;
                }
                this._existNoteChannel[ch] = true;
                if (ch == 9 && data2 >= 1) {
                    drums.add(data1);
                    continue;
                }
                if (data1 < _noteLowest) {
                    _noteLowest = data1;
                }
                if (data1 <= _noteHighest) continue;
                _noteHighest = data1;
                continue;
            }
            if (command != 192 || programList[ch] >= 0) continue;
            programList[ch] = data1;
        }
        int lo2 = _noteLowest;
        lo2 /= 12;
        for (hi2 = lo2 *= 12; hi2 < _noteHighest; hi2 += 12) {
        }
        int x = lo2 / 12;
        int width = hi2 / 12;
        width -= x;
        x *= 12;
        if (width <= 2) {
            if (x >= 12) {
                x -= 12;
                ++width;
            }
            if (width <= 2) {
                ++width;
            }
        }
        boolean rows = false;
        int[] drumProgs = new int[drums.size()];
        for (int id = 0; id < drums.size(); ++id) {
            drumProgs[id] = (Integer)drums.get(id);
        }
        MXMain.getMain().getPlayListProcess().createPianoControls(lo2, width, this._existNoteChannel, programList, drumProgs);
        this._firstNotePos = firstNotePos;
    }

    public static String[] readFileInfo(File file) {
        ArrayList<Object> ret = new ArrayList<Object>();
        String fileName = file.toString();
        try {
            SMFPlayer player = new SMFPlayer(file);
            SMFMessageList list = player.listMessage();
            ArrayList<SMFMessage> listMessage = list.listAll();
            for (SMFMessage message : listMessage) {
                if (message._status != 255) continue;
                int type = message._dataType;
                byte[] data = message.getBinary();
                String text = null;
                try {
                    text = new String(data, "ASCII");
                    text = new String(data);
                    text = new String(data, "SJIS");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                int number = 0;
                switch (type) {
                    case 0: {
                        if (data.length < 2) break;
                        number = data[0] * 128 + data[1];
                        ret.add("Sequence Number : " + number);
                        break;
                    }
                    case 1: {
                        ret.add("Text : " + text);
                        break;
                    }
                    case 2: {
                        ret.add("Copyright : " + text);
                        break;
                    }
                    case 3: {
                        ret.add("Track Name : " + text);
                    }
                }
            }
        }
        catch (Exception e) {
            ret.add("Can't open [" + file.toString() + "]");
            ret.add(e.toString());
        }
        String[] list = new String[ret.size()];
        ret.toArray(list);
        return list;
    }

    public long getLength() {
        return this._sequencer.getLength();
    }

    public int getFirstNotePos() {
        if (this._firstNotePos < 0) {
            ArrayList<SMFMessage> list = this._sequencer.listMessage().listAll();
            int pos = 0;
            for (SMFMessage smf : list) {
                int command = smf._status;
                if ((command & 0xF0) == 144) {
                    this._firstNotePos = pos;
                    break;
                }
                ++pos;
            }
            if (this._firstNotePos < 0) {
                this._firstNotePos = 0;
            }
        }
        return this._firstNotePos >= 0 ? this._firstNotePos : 0;
    }

    public synchronized void startSequencer(final SMFCallback parent, int position) throws IOException {
        if (this._sequencer != null) {
            this._sequencer.stopPlayer();
        }
        this._gotBreak = false;
        this._sequencer.setCurrentPosition(position);
        this._sequencer.startPlayer(new SMFCallback(){
            Thread _last;

            @Override
            public void smfPlayNote(SMFMessage smf) {
                try {
                    if (this._last != Thread.currentThread()) {
                        this._last = Thread.currentThread();
                        MXThreadList.attachIfNeed("smfPlayNote", this._last);
                    }
                    if (smf.isBinaryMessage()) {
                        MXMIDIInForPlayer.this.receiveLongMessage(smf.getBinary());
                    } else {
                        int dword = smf.toDwordMessage();
                        MXMIDIInForPlayer.this.receiveShortMessage(dword);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void smfStarted() {
                parent.smfStarted();
            }

            @Override
            public void smfStoped(boolean fineFinish) {
                parent.smfStoped(fineFinish);
            }

            @Override
            public void smfProgress(int pos, int finish) {
                parent.smfProgress(pos, finish);
            }
        });
    }

    public synchronized boolean isSequencerPlaying() {
        if (this._sequencer != null) {
            return this._sequencer.isRunning();
        }
        return false;
    }

    public synchronized void stopSequencer() {
        if (this._sequencer != null) {
            this._sequencer.stopPlayer();
            this.allNoteOff();
        }
    }
}

