/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.port;

import java.util.ArrayList;
import javax.swing.JComponent;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.MXThreadList;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.common.MXWrapList;
import jp.synthtarou.midimixer.libs.common.log.MXDebugPrint;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXMessageTemplate;
import jp.synthtarou.midimixer.libs.midi.MXNoteOffWatcher;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.midi.MXTiming;
import jp.synthtarou.midimixer.libs.midi.driver.MXDriver;
import jp.synthtarou.midimixer.libs.midi.driver.MXDriver_Java;
import jp.synthtarou.midimixer.libs.midi.driver.MXDriver_UWP;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIInForPlayer;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIInManager;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant16;

public class MXMIDIIn {
    private static final MXDebugPrint _debug = new MXDebugPrint(MXMIDIIn.class);
    public static final MXMIDIInForPlayer INTERNAL_PLAYER = new MXMIDIInForPlayer();
    private String _name;
    private MXDriver _driver;
    private int _driverOrder;
    private MXNoteOffWatcher _myNoteOff = new MXNoteOffWatcher();
    private boolean[] _assigned;
    private int _assignCount = 0;
    private boolean[] _toMaster = new boolean[16];
    private MXVisitant16 _visitant16 = new MXVisitant16();
    public static final MXReceiver returnReceirer = new MXReceiver(){

        @Override
        public String getReceiverName() {
            return "Return";
        }

        @Override
        public JComponent getReceiverView() {
            return null;
        }

        @Override
        protected void processMXMessageImpl(MXMessage message) {
            MXTiming timing = new MXTiming();
            MXWrapList<MXMIDIIn> list = MXMIDIInManager.getManager().listAllInput();
            for (int x = 0; x < list.size(); ++x) {
                MXMIDIIn input = list.valueOfIndex(x);
                for (int port = 0; port < 16; ++port) {
                    if (!input.isPortAssigned(port)) continue;
                    MXMessage ported = MXMessageFactory.fromClone(message);
                    ported.setPort(port);
                    input.dispatchToPort(ported);
                }
            }
        }
    };
    Thread lastSent = null;
    Thread _attached = null;

    public MXDriver getDriver() {
        return this._driver;
    }

    public int getDriverOrder() {
        return this._driverOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MXMIDIInManager manager;
        MXMIDIInManager mXMIDIInManager = manager = MXMIDIInManager.getManager();
        synchronized (mXMIDIInManager) {
            if (this.isOpen()) {
                this.allNoteOff();
                manager.onClose(this);
                this._driver.InputDeviceClose(this._driverOrder);
            }
        }
    }

    public boolean isOpen() {
        if (this instanceof MXMIDIInForPlayer) {
            return true;
        }
        if (this._driver == null) {
            return false;
        }
        return this._driver.InputDeviceIsOpen(this._driverOrder);
    }

    public MXMIDIIn(MXDriver driver, int driverOrder) {
        this._name = driver.InputDeviceName(driverOrder);
        this._assigned = new boolean[16];
        this._driver = driver;
        this._driverOrder = driverOrder;
        if (driver instanceof MXDriver_UWP) {
            MXDriver_UWP._instance.addInputCatalog(this);
        }
        if (driver instanceof MXDriver_Java) {
            MXDriver_UWP._instance.addInputCatalog(this);
        }
    }

    public boolean isPortAssigned(int port) {
        return this._assigned[port];
    }

    public int getPortAssignCount() {
        return this._assignCount;
    }

    public String getPortAssignedAsText() {
        StringBuffer assigned = new StringBuffer();
        for (int p = 0; p < 16; ++p) {
            if (!this.isPortAssigned(p)) continue;
            if (assigned.length() > 0) {
                assigned.append(",");
            }
            assigned.append((char)(65 + p));
        }
        return assigned.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortAssigned(int port, boolean flag) {
        MXMIDIInManager mXMIDIInManager = MXMIDIInManager.getManager();
        synchronized (mXMIDIInManager) {
            if (this._assigned[port] != flag) {
                if (!flag) {
                    this._myNoteOff.allNoteOffToPort(new MXTiming(), port);
                }
                this._assigned[port] = flag;
                int x = 0;
                for (int i = 0; i < this._assigned.length; ++i) {
                    if (!this._assigned[i]) continue;
                    ++x;
                }
                this._assignCount = x;
                MXMIDIInManager.getManager().clearMIDIInCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetPortAssigned() {
        MXMIDIInManager mXMIDIInManager = MXMIDIInManager.getManager();
        synchronized (mXMIDIInManager) {
            for (int i = 0; i < 16; ++i) {
                this.setPortAssigned(i, false);
            }
        }
    }

    public boolean isToMaster(int channel) {
        return this._toMaster[channel];
    }

    public void setToMaster(int channel, boolean toMaster) {
        this._toMaster[channel] = toMaster;
    }

    public String getMasterList() {
        StringBuffer str = new StringBuffer();
        for (int ch = 0; ch < 16; ++ch) {
            if (!this.isToMaster(ch)) continue;
            if (str.length() == 0) {
                str.append(Integer.toString(ch));
                continue;
            }
            str.append(",");
            str.append(Integer.toString(ch));
        }
        return str.toString();
    }

    public void setMasterList(String text) {
        if (text == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        MXUtil.split(text, list, ',');
        this._toMaster = new boolean[16];
        for (String x : list) {
            int ch = MXUtil.parseTextForNumber(x);
            if (ch < 0) continue;
            this._toMaster[ch] = true;
        }
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allNoteOff() {
        Object object = MXTiming.mutex;
        synchronized (object) {
            MXTiming timing = new MXTiming();
            this._myNoteOff.allNoteOff(timing);
        }
        for (int ch = 0; ch < 16; ++ch) {
            int status = 0xB0 | ch;
            int data1 = 123;
            this.receiveShortMessage(status << 16 | data1 << 8);
            data1 = 120;
            this.receiveShortMessage(status << 16 | data1 << 8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allNoteOffToPort(int target) {
        Object object = MXTiming.mutex;
        synchronized (object) {
            this._myNoteOff.allNoteOffToPort(new MXTiming(), target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openInput(long timeout) {
        MXMIDIInManager manager;
        MXMIDIInManager mXMIDIInManager = manager = MXMIDIInManager.getManager();
        synchronized (mXMIDIInManager) {
            if (this._driver == null) {
                return false;
            }
            if (this.isOpen()) {
                return true;
            }
            return this._driver.InputDeviceOpen(this._driverOrder, timeout, this);
        }
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        MXMIDIIn in = (MXMIDIIn)o;
        return in._name == this._name;
    }

    public String textForMasterChannel() {
        StringBuffer masterMark = new StringBuffer();
        for (int ch = 0; ch < 16; ++ch) {
            if (!this.isToMaster(ch)) continue;
            if (masterMark.length() != 0) {
                masterMark.append(", ");
            }
            masterMark.append((Object)(ch + 1));
        }
        return masterMark.toString();
    }

    public int parseMasteredText(String text) {
        if (text == null) {
            return 0;
        }
        String[] array = text.split("[ ,]+");
        int hit = 0;
        for (int i = 0; i < array.length; ++i) {
            int ch1;
            String parts = array[i];
            if (parts.length() < 1 || (ch1 = parts.charAt(0) - 48) < 0 || ch1 > 9) continue;
            if (parts.length() >= 2) {
                int ch2 = parts.charAt(2) - 48;
                if (ch2 < 0 || ch2 > 9) continue;
                ch1 = ch1 * 10 + ch2;
            }
            if (ch1 >= 1 && ch1 <= 16) {
                this.setToMaster(ch1 - 1, true);
            }
            ++hit;
        }
        return hit;
    }

    public void receiveShortMessage(int dword) {
        this.startMainPath(dword, null);
    }

    public void receiveLongMessage(byte[] data) {
        this.startMainPath(-1, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMainPath(int dword, byte[] data) {
        if (Thread.currentThread() != this._attached) {
            this._attached = Thread.currentThread();
            MXThreadList.attachIfNeed("startMainPath", this._attached);
        }
        if (this.lastSent != Thread.currentThread()) {
            this.lastSent = Thread.currentThread();
            if (Thread.currentThread().getPriority() != 10) {
                Thread.currentThread().setPriority(10);
                System.out.println("Thread MAX");
            }
        }
        int status = dword >> 16 & 0xFF;
        int data1 = dword >> 8 & 0xFF;
        int data2 = dword & 0xFF;
        int command = status & 0xF0;
        int channel = status & 0xF;
        if (status == 248 || status == 254) {
            return;
        }
        Object object = MXTiming.mutex;
        synchronized (object) {
            MXTiming timing = new MXTiming();
            if (command == 144 && data2 == 0) {
                command = 128;
                status = command | channel;
                dword = status << 16 | data1 << 8 | data2;
            }
            if (this == INTERNAL_PLAYER) {
                MXMain.getMain().getPlayListProcess().updatePianoKeys(dword);
            } else if (command == 128) {
                if (this == INTERNAL_PLAYER) {
                    MXMain.getMain().getPlayListProcess().updatePianoKeys(dword);
                }
                if (this._myNoteOff.raiseHandler(0, timing, status & 0xF, data1)) {
                    return;
                }
            } else if (command == 176 && data1 == 123) {
                this._myNoteOff.allNoteOff(timing);
            } else if (command == 176 && data1 == 120) {
                this._myNoteOff.allNoteOff(timing);
            }
            for (int port = 0; port < 16; ++port) {
                if (!this.isPortAssigned(port)) continue;
                MXMessage message = null;
                if (data == null) {
                    message = MXMessageFactory.fromShortMessage(port, status, data1, data2);
                    if ((status & 0xF0) == 144) {
                        MXMessage noteon = MXMessageFactory.fromShortMessage(0, status, data1, data2);
                        noteon._timing = timing;
                        MXMessage noteoff = MXMessageFactory.fromShortMessage(port, 128 + message.getChannel(), data1, 0);
                        this._myNoteOff.setHandler(noteon, noteoff, new MXNoteOffWatcher.Handler(){

                            @Override
                            public void onNoteOffEvent(MXMessage target) {
                                MXMain.addOutsideInput(target);
                                MXMIDIIn.this.dispatchToPort(target);
                            }
                        });
                    }
                } else {
                    message = MXMessageFactory.fromBinary(port, data);
                }
                if (message == null) continue;
                message._timing = timing;
                MXMain.addOutsideInput(message);
                this.dispatchToPort(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchToPort(MXMessage message) {
        int port = message.getPort();
        Object object = MXTiming.mutex;
        synchronized (object) {
            if (message.isMessageTypeChannel()) {
                boolean worked = false;
                int ch = message.getChannel();
                int command = message.getCommand();
                int gate = message.getGate();
                MXVisitant visit = this._visitant16.get(ch);
                visit.updateVisitantChannel(message);
                message.setVisitant(visit.getSnapShot());
                if (command == 176) {
                    if (gate == 0 || gate == 32) {
                        if (visit.isHavingBank()) {
                            MXMessage message2 = MXMessageFactory.fromShortMessage(port, command + ch, 0, 0);
                            message2._timing = message._timing;
                            message2.setVisitant(visit.getSnapShot());
                            MXMIDIIn.dispatchMainPath(message2);
                        }
                        return;
                    }
                    if (gate == 6 || gate == 38) {
                        if (visit.isHaveDataentryRPN()) {
                            int[] temp0 = new int[]{16384, 0, 0, 0};
                            MXMessageTemplate template = new MXMessageTemplate(temp0);
                            message = template.buildMessage(port, 0, 0);
                            message.setVisitant(visit.getSnapShot());
                            MXMIDIIn.dispatchMainPath(message);
                        } else if (visit.isHaveDataentryNRPN()) {
                            int[] temp0 = new int[]{16640, 0, 0, 0};
                            MXMessageTemplate template = new MXMessageTemplate(temp0);
                            message = template.buildMessage(port, 0, 0);
                            message.setVisitant(visit.getSnapShot());
                            MXMIDIIn.dispatchMainPath(message);
                        }
                        return;
                    }
                    if (gate == 100 || gate == 101 || gate == 98 || gate == 99) {
                        return;
                    }
                }
                if (visit.isIncompleteBankInfo() && (command != 176 || gate != 0 && gate != 32)) {
                    visit.forceCompleteBankInfo();
                }
                if (visit.isIncomplemteDataentry() && (command != 176 || gate != 6 && gate != 38)) {
                    visit.forceCompleteBankDataentry();
                }
                if (visit.isIncomplemteDataroom() && (command != 176 || gate != 100 && gate != 101 && gate != 98 && gate != 99)) {
                    visit.forceCompleteBankDataroom();
                }
            }
            MXMIDIIn.dispatchMainPath(message);
        }
    }

    private static void dispatchMainPath(MXMessage message) {
        MXMain.getMain().messageDispatch(message, MXMain.getMain().getInputProcess());
    }
}

