/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.driver;

import java.util.ArrayList;
import jp.synthtarou.midimixer.MXThreadList;
import jp.synthtarou.midimixer.libs.midi.driver.MXDriver;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIIn;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIOut;
import jp.synthtarou.midimixer.windows.MXLIB01UWPMidi;

public class MXDriver_UWP
implements MXDriver {
    public static final MXDriver_UWP _instance = new MXDriver_UWP();
    MXLIB01UWPMidi windows10;
    ArrayList<MXMIDIIn> _listInputCatalog = new ArrayList();
    ArrayList<MXMIDIOut> _listOutputCatalog = new ArrayList();
    Thread _last;

    public MXDriver_UWP() {
        this.windows10 = new MXLIB01UWPMidi();
    }

    public String driverSuffix() {
        return "(UWP)";
    }

    @Override
    public boolean isUsable() {
        return this.windows10.isDLLAvail();
    }

    @Override
    public void StartLibrary() {
        if (this.isUsable()) {
            this.windows10.StartLibrary();
        }
    }

    @Override
    public int InputDevicesRoomSize() {
        if (!this.isUsable()) {
            return 0;
        }
        return this.windows10.InputDevicesRoomSize();
    }

    @Override
    public String InputDeviceName(int device) {
        if (!this.isUsable()) {
            return "";
        }
        return this.windows10.InputDeviceName(device) + "(UWP)";
    }

    @Override
    public String InputDeviceId(int device) {
        if (!this.isUsable()) {
            return "";
        }
        return this.windows10.InputDeviceId(device);
    }

    @Override
    public boolean InputDeviceIsOpen(int device) {
        if (!this.isUsable()) {
            return false;
        }
        return this.windows10.InputIsOpen(device);
    }

    @Override
    public boolean InputDeviceOpen(int device, long timeout, MXMIDIIn input) {
        if (!this.isUsable()) {
            return false;
        }
        return this.windows10.InputOpen(device, timeout);
    }

    @Override
    public void InputDeviceClose(int device) {
        if (!this.isUsable()) {
            return;
        }
        this.windows10.InputClose(device);
    }

    @Override
    public int OutputDevicesRoomSize() {
        if (!this.isUsable()) {
            return 0;
        }
        return this.windows10.OutputDevicesRoomSize();
    }

    @Override
    public String OutputDeviceName(int device) {
        if (!this.isUsable()) {
            return "";
        }
        return this.windows10.OutputDeviceName(device) + "(UWP)";
    }

    @Override
    public String OutputDeviceId(int device) {
        if (!this.isUsable()) {
            return "";
        }
        return this.windows10.OutputDeviceId(device);
    }

    @Override
    public boolean OutputDeviceIsOpen(int device) {
        if (!this.isUsable()) {
            return false;
        }
        return this.windows10.OutputIsOpen(device);
    }

    @Override
    public boolean OutputDeviceOpen(int device, long timeout) {
        if (!this.isUsable()) {
            return false;
        }
        return this.windows10.OutputOpen(device, timeout);
    }

    @Override
    public void OutputDeviceClose(int device) {
        if (!this.isUsable()) {
            return;
        }
        this.windows10.OutputClose(device);
    }

    @Override
    public boolean OutputShortMessage(int device, int message) {
        if (!this.isUsable()) {
            return false;
        }
        return this.windows10.OutputShortMessage(device, message);
    }

    @Override
    public boolean OutputLongMessage(int device, byte[] message) {
        if (!this.isUsable()) {
            return false;
        }
        return this.windows10.OutputLongMessage(device, message);
    }

    public void addInputCatalog(MXMIDIIn input) {
        int order = input.getDriverOrder();
        if (input.getDriver() == this) {
            while (this._listInputCatalog.size() <= order) {
                this._listInputCatalog.add(null);
            }
            this._listInputCatalog.set(order, input);
        }
    }

    public MXMIDIIn findInputCatalog(int order) {
        Thread t = Thread.currentThread();
        if (this._last != t) {
            this._last = t;
            MXThreadList.attachIfNeed("MXDriver_UWP", t);
        }
        while (this._listInputCatalog.size() <= order) {
            this._listInputCatalog.add(null);
        }
        MXMIDIIn in = this._listInputCatalog.get(order);
        if (in.getDriverOrder() == order) {
            return in;
        }
        throw new IllegalArgumentException();
    }

    public void closeAllInput() {
        for (MXMIDIIn in : this._listInputCatalog) {
            if (in == null) continue;
            in.close();
        }
    }

    public void addOuputCatalog(MXMIDIOut output) {
        int order = output.getDriverOrder();
        if (output.getDriver() == this) {
            while (this._listOutputCatalog.size() <= order) {
                this._listOutputCatalog.add(null);
            }
            this._listOutputCatalog.set(order, output);
        }
    }

    public MXMIDIOut findOutputCatalog(int order) {
        while (this._listOutputCatalog.size() <= order) {
            this._listOutputCatalog.add(null);
        }
        MXMIDIOut out = this._listOutputCatalog.get(order);
        if (out.getDriverOrder() == order) {
            return out;
        }
        throw new IllegalArgumentException();
    }

    public void closeAllOutput() {
        for (MXMIDIOut out : this._listOutputCatalog) {
            if (out == null) continue;
            out.close();
        }
    }
}

