/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi.driver;

import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import jp.synthtarou.midimixer.MXThreadList;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.midi.driver.MXDriver;
import jp.synthtarou.midimixer.libs.midi.port.MXMIDIIn;

public class MXDriver_Java
implements MXDriver {
    public static final MXDriver_Java _instance = new MXDriver_Java();
    ArrayList<MidiDevice> _listInput;
    ArrayList<MidiDevice> _listOutput;

    @Override
    public boolean isUsable() {
        return true;
    }

    @Override
    public void StartLibrary() {
        this.listAllInput();
        this.listAllOutput();
    }

    public synchronized void listAllInput() {
        if (this._listInput != null) {
            return;
        }
        ArrayList<MidiDevice> newList = new ArrayList<MidiDevice>();
        MidiDevice.Info[] infoList = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < infoList.length; ++i) {
            MidiDevice device = null;
            try {
                device = MidiSystem.getMidiDevice(infoList[i]);
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
                continue;
            }
            if (device.getMaxTransmitters() == 0) continue;
            try {
                String name = device.getDeviceInfo().getName();
                try {
                    String charset2 = System.getProperty("file.encoding");
                    String name2 = new String(name.getBytes(charset2), charset2);
                    String charset3 = System.getProperty("sun.jnu.encoding");
                    String name3 = new String(name.getBytes(charset3), charset3);
                    if (!name.equals(name2) || !name.equals(name3)) {
                        StringBuffer out = new StringBuffer();
                        for (int x = 0; x < name.length(); ++x) {
                            char ch = name.charAt(x);
                            out.append(Integer.toHexString(ch));
                            out.append(",");
                        }
                        System.out.println(name + " = " + name2 + " = " + name3);
                        continue;
                    }
                    System.out.println(name + " = safe for " + charset2 + " ," + charset3);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (name.equals("Real Time Sequencer")) continue;
                newList.add(device);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._listInput = newList;
    }

    public synchronized void listAllOutput() {
        if (this._listOutput != null) {
            return;
        }
        ArrayList<MidiDevice> newList = new ArrayList<MidiDevice>();
        MidiDevice.Info[] infoList = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < infoList.length; ++i) {
            String name;
            MidiDevice device = null;
            try {
                device = MidiSystem.getMidiDevice(infoList[i]);
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
                continue;
            }
            if (device.getMaxReceivers() == 0 || (name = device.getDeviceInfo().getName()).equals("Real Time Sequencer")) continue;
            newList.add(device);
        }
        this._listOutput = newList;
    }

    @Override
    public int InputDevicesRoomSize() {
        this.listAllInput();
        return this._listInput.size();
    }

    @Override
    public String InputDeviceName(int x) {
        this.listAllInput();
        MidiDevice device = this._listInput.get(x);
        return device.getDeviceInfo().getName();
    }

    @Override
    public String InputDeviceId(int x) {
        this.listAllInput();
        return this.InputDeviceName(x);
    }

    @Override
    public boolean InputDeviceIsOpen(int x) {
        this.listAllInput();
        return this._listInput.get(x).isOpen();
    }

    @Override
    public boolean InputDeviceOpen(int device, long timeout, MXMIDIIn input) {
        this.listAllInput();
        if (!this._listInput.get(device).isOpen()) {
            try {
                this._listInput.get(device).open();
                if (this._listInput.get(device).isOpen()) {
                    this._listInput.get(device).getTransmitter().setReceiver(new JavaInputReceiver(input));
                    return true;
                }
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void InputDeviceClose(int x) {
        this.listAllInput();
        if (!this._listInput.get(x).isOpen()) {
            return;
        }
        this._listInput.get(x).close();
    }

    @Override
    public int OutputDevicesRoomSize() {
        this.listAllOutput();
        return this._listOutput.size();
    }

    @Override
    public String OutputDeviceName(int x) {
        this.listAllOutput();
        return this._listOutput.get(x).getDeviceInfo().getName();
    }

    @Override
    public String OutputDeviceId(int x) {
        this.listAllOutput();
        return this.OutputDeviceName(x);
    }

    @Override
    public boolean OutputDeviceIsOpen(int x) {
        this.listAllOutput();
        return this._listOutput.get(x).isOpen();
    }

    @Override
    public boolean OutputDeviceOpen(int device, long timeout) {
        this.listAllOutput();
        if (!this._listOutput.get(device).isOpen()) {
            try {
                this._listOutput.get(device).open();
                if (this._listOutput.get(device).isOpen()) {
                    return true;
                }
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    @Override
    public void OutputDeviceClose(int x) {
        this.listAllOutput();
        if (!this._listOutput.get(x).isOpen()) {
            return;
        }
        this._listOutput.get(x).close();
    }

    @Override
    public boolean OutputShortMessage(int x, int message) {
        this.listAllOutput();
        int status = message >> 8 >> 8 & 0xFF;
        int data1 = message >> 8 & 0xFF;
        int data2 = message & 0xFF;
        if (this._listOutput.get(x).isOpen()) {
            try {
                ShortMessage msg = new ShortMessage(status, data1, data2);
                this._listOutput.get(x).getReceiver().send(msg, 0L);
                return true;
            }
            catch (Throwable e) {
                System.out.println("Unknown Message: " + MXUtil.toHexFF(status) + "  " + MXUtil.toHexFF(data1) + " " + MXUtil.toHexFF(data2));
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean OutputLongMessage(int x, byte[] data) {
        this.listAllOutput();
        if (data == null || data.length == 0) {
            return true;
        }
        try {
            int status = data[0] & 0xFF;
            switch (status) {
                case 240: 
                case 247: {
                    try {
                        SysexMessage msg = new SysexMessage(data, data.length);
                        this._listOutput.get(x).getReceiver().send(msg, 0L);
                        return true;
                    }
                    catch (InvalidMidiDataException e) {
                        System.out.println("Bug Message " + MXUtil.dumpHexFF(data));
                        break;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        break;
                    }
                }
                case 255: {
                    break;
                }
                default: {
                    if (data.length <= 3) {
                        byte data2;
                        byte data1 = data.length >= 2 ? data[1] : (byte)0;
                        byte by = data2 = data.length >= 3 ? data[2] : (byte)0;
                        if (this._listOutput.get(x).isOpen()) {
                            try {
                                ShortMessage msg3 = new ShortMessage(status & 0xFF, data1 & 0xFF, data2 & 0xFF);
                                this._listOutput.get(x).getReceiver().send(msg3, 0L);
                                return true;
                            }
                            catch (InvalidMidiDataException msg3) {
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    break;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    class JavaInputReceiver
    implements Receiver {
        MXMIDIIn _input;
        Thread _last;

        public JavaInputReceiver(MXMIDIIn input) {
            this._input = input;
        }

        @Override
        public void send(MidiMessage msg, long timestamp) {
            if (this._last != Thread.currentThread()) {
                this._last = Thread.currentThread();
                MXThreadList.attachIfNeed("MXDriver_java", this._last);
            }
            if (msg instanceof ShortMessage) {
                ShortMessage shortMsg = (ShortMessage)msg;
                int status = shortMsg.getStatus() & 0xFF;
                int data1 = shortMsg.getData1() & 0xFF;
                int data2 = shortMsg.getData2() & 0xFF;
                if (status == 255 || status == 254) {
                    return;
                }
                int dword = (status << 8 | data1) << 8 | data2;
                this._input.receiveShortMessage(dword);
            } else {
                byte[] data = msg.getMessage();
                this._input.receiveLongMessage(data);
            }
        }

        @Override
        public void close() {
            this._input.close();
        }
    }
}

