/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi;

import java.util.ArrayList;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.common.MXWrapList;
import jp.synthtarou.midimixer.libs.common.log.MXDebugPrint;

public class MXUtilMidi {
    private static final MXDebugPrint _debug = new MXDebugPrint(MXUtilMidi.class);
    protected static final String[] noteSymbols = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    static int[] alphaToNote = new int[]{9, 11, 0, 2, 4, 5, 7};

    public static MXWrapList<Integer> createNormalGate() {
        MXWrapList<Integer> newList = new MXWrapList<Integer>();
        for (int i = 0; i < 128; ++i) {
            newList.addNameAndValue(String.valueOf(i), i);
        }
        return newList;
    }

    public static MXWrapList<Integer> createProgram() {
        MXWrapList<Integer> newList = new MXWrapList<Integer>();
        for (int i = 0; i < 128; ++i) {
            Integer number = i;
            newList.addNameAndValue("" + number, number);
        }
        return newList;
    }

    public static MXWrapList<Integer> createVelocity() {
        MXWrapList<Integer> list = new MXWrapList<Integer>();
        for (int i = 0; i <= 127; ++i) {
            list.addNameAndValue(String.valueOf(i), i);
        }
        return list;
    }

    public static MXWrapList<Boolean> createSendFilter() {
        MXWrapList<Boolean> list = new MXWrapList<Boolean>();
        list.addNameAndValue("Send", Boolean.TRUE);
        list.addNameAndValue("Don't send", Boolean.FALSE);
        return list;
    }

    public static MXWrapList<Integer> createXSB() {
        MXWrapList<Integer> newList = new MXWrapList<Integer>();
        for (int i = 0; i < 256; ++i) {
            String name = MXUtil.toHexFF(i);
            Integer number = i;
            newList.addNameAndValue(name, number);
        }
        return newList;
    }

    public static MXWrapList<Integer> createCommand() {
        MXWrapList<Integer> list = new MXWrapList<Integer>();
        for (int i = 128; i <= 240; i += 16) {
            String name = MXUtilMidi.nameOfChannelMessage(i);
            String title = Integer.valueOf(i) + " " + name;
            list.addNameAndValue(title, i);
        }
        return list;
    }

    public static MXWrapList<Integer> createSystemModeOneShot() {
        String name;
        int i;
        MXWrapList<Integer> list = new MXWrapList<Integer>();
        for (i = 240; i <= 247; ++i) {
            name = MXUtilMidi.nameOfSystemCommonMessage(i);
            list.addNameAndValue(name + "(" + i + ")", i);
        }
        for (i = 248; i <= 255; ++i) {
            name = MXUtilMidi.nameOfSystemRealtimeMessage(i);
            list.addNameAndValue(name + "(" + i + ")", i);
        }
        return list;
    }

    public static MXWrapList<Integer> createChannel(boolean addOmni) {
        MXWrapList<Integer> list = new MXWrapList<Integer>();
        if (addOmni) {
            list.addNameAndValue("any", -1);
        }
        for (int i = 0; i < 16; ++i) {
            list.addNameAndValue(String.valueOf(i + 1), i);
        }
        return list;
    }

    public static MXWrapList<Integer> createChannelModeSlider() {
        MXWrapList<Integer> list = new MXWrapList<Integer>();
        for (int i = 120; i <= 127; ++i) {
            if (i != 122) continue;
            String name = MXUtilMidi.nameOfControlChange(i);
            list.addNameAndValue(name + "(" + i + ")", i);
        }
        return list;
    }

    public static MXWrapList<Integer> createPercent() {
        MXWrapList<Integer> list = new MXWrapList<Integer>();
        for (int i = 100; i >= 0; i -= 10) {
            list.addNameAndValue(String.valueOf(i) + "%", i);
        }
        return list;
    }

    public static MXWrapList<Integer> createPortShort() {
        MXWrapList<Integer> list = new MXWrapList<Integer>();
        for (int i = 0; i < 16; ++i) {
            list.addNameAndValue(Character.toString(65 + i), i);
        }
        return list;
    }

    public static MXWrapList<Integer> createPortAssigned(boolean addOmni) {
        MXWrapList<Integer> list = new MXWrapList<Integer>();
        if (addOmni) {
            list.addNameAndValue("Any ", -1);
        }
        for (int i = 0; i < 16; ++i) {
            list.addNameAndValue(Character.toString(65 + i), i);
        }
        return list;
    }

    public static MXWrapList<Integer> createChannelModeOnShot() {
        MXWrapList<Integer> list = new MXWrapList<Integer>();
        for (int i = 120; i <= 127; ++i) {
            if (i == 122) continue;
            String name = MXUtilMidi.nameOfControlChange(i);
            list.addNameAndValue(name + "(" + i + ")", i);
        }
        return list;
    }

    public static MXWrapList<Integer> createControlChange() {
        MXWrapList<Integer> list = new MXWrapList<Integer>();
        for (int i = 0; i <= 119; ++i) {
            String name = MXUtilMidi.nameOfControlChange(i);
            list.addNameAndValue(name + "(" + i + ")", i);
        }
        return list;
    }

    public static MXWrapList<Integer> createNoteNo() {
        MXWrapList<Integer> list = new MXWrapList<Integer>();
        for (int i = 0; i <= 127; ++i) {
            list.addNameAndValue(MXUtilMidi.nameOfNote(i), i);
        }
        return list;
    }

    public static MXWrapList<Integer> createZero() {
        MXWrapList<Integer> list = new MXWrapList<Integer>();
        list.addNameAndValue("---", 0);
        return list;
    }

    public static final String nameOfChannelMessage(int command) {
        switch (command) {
            case 144: {
                return "ON   ";
            }
            case 128: {
                return "OFF  ";
            }
            case 160: {
                return "PresP";
            }
            case 176: {
                return "CC   ";
            }
            case 192: {
                return "PROG ";
            }
            case 208: {
                return "Press";
            }
            case 224: {
                return "PITCH";
            }
            case 240: {
                return "SYSEX";
            }
        }
        return null;
    }

    public static String nameOfNote(int noteNo) {
        int oct = noteNo / 12 - 1;
        return noteSymbols[noteNo %= 12] + Integer.toString(oct);
    }

    public static int noteOfName(String note) {
        char ch = note.charAt(0);
        int base = -1;
        int index = 0;
        if (ch >= 'a' && ch <= 'z') {
            ch = (char)(ch - 32);
        }
        if (ch >= 'A' && ch <= 'G') {
            int key = alphaToNote[ch - 65];
            if (note.charAt(++index) == '#') {
                ++key;
                ++index;
            }
            int oct = Integer.parseInt(note.substring(index));
            return key += oct * 12;
        }
        return -1;
    }

    public static final String nameOfControlChange(int data1cc) {
        String namePrefix = "";
        switch (data1cc) {
            case 0: {
                return namePrefix + "BANK";
            }
            case 1: {
                return namePrefix + "MODW";
            }
            case 2: {
                return namePrefix + "BRTH";
            }
            case 3: {
                return namePrefix + "CC03";
            }
            case 4: {
                return namePrefix + "FOOT";
            }
            case 5: {
                return namePrefix + "PRTA";
            }
            case 6: {
                return namePrefix + "DATA ";
            }
            case 7: {
                return namePrefix + "VOL ";
            }
            case 8: {
                return namePrefix + "BAL ";
            }
            case 9: {
                return namePrefix + "CC09";
            }
            case 10: {
                return namePrefix + "PAN ";
            }
            case 11: {
                return namePrefix + "EXP ";
            }
            case 12: {
                return namePrefix + "EFC1";
            }
            case 13: {
                return namePrefix + "EFC2";
            }
            case 14: {
                return namePrefix + "CC14";
            }
            case 15: {
                return namePrefix + "CC15";
            }
            case 16: {
                return namePrefix + "CMN1";
            }
            case 17: {
                return namePrefix + "CMN2";
            }
            case 18: {
                return namePrefix + "CMN3";
            }
            case 19: {
                return namePrefix + "CMN4";
            }
            case 64: {
                return namePrefix + "DUMP";
            }
            case 65: {
                return namePrefix + "PORT";
            }
            case 66: {
                return namePrefix + "SFTE";
            }
            case 67: {
                return namePrefix + "SOFT";
            }
            case 68: {
                return namePrefix + "REGD";
            }
            case 69: {
                return namePrefix + "FREZ";
            }
            case 70: {
                return namePrefix + "VALI";
            }
            case 71: {
                return namePrefix + "TMBR";
            }
            case 72: {
                return namePrefix + "RELS";
            }
            case 73: {
                return namePrefix + "ATCK";
            }
            case 74: {
                return namePrefix + "BLIG";
            }
            case 75: {
                return namePrefix + "DCAY";
            }
            case 76: {
                return namePrefix + "VRate";
            }
            case 77: {
                return namePrefix + "VDpth";
            }
            case 78: {
                return namePrefix + "VDlay";
            }
            case 79: {
                return namePrefix + "CC79";
            }
            case 80: {
                return namePrefix + "CMN5";
            }
            case 81: {
                return namePrefix + "CMN6";
            }
            case 82: {
                return namePrefix + "CMN7";
            }
            case 83: {
                return namePrefix + "CMN8";
            }
            case 84: {
                return namePrefix + "NOTE#";
            }
            case 85: {
                return namePrefix + "CC85";
            }
            case 86: {
                return namePrefix + "CC86";
            }
            case 87: {
                return namePrefix + "CC87";
            }
            case 88: {
                return namePrefix + "VEL2";
            }
            case 89: {
                return namePrefix + "CC89";
            }
            case 90: {
                return namePrefix + "CC90";
            }
            case 91: {
                return namePrefix + "REVR";
            }
            case 92: {
                return namePrefix + "TRML";
            }
            case 93: {
                return namePrefix + "CHOR";
            }
            case 94: {
                return namePrefix + "DETU";
            }
            case 95: {
                return namePrefix + "PHAS";
            }
            case 96: {
                return namePrefix + "INC ";
            }
            case 97: {
                return namePrefix + "DEC ";
            }
            case 98: {
                return namePrefix + "NRPN L";
            }
            case 99: {
                return namePrefix + "NRPN M";
            }
            case 100: {
                return namePrefix + "RPN L";
            }
            case 101: {
                return namePrefix + "RPN M";
            }
            case 120: {
                return "AllOff";
            }
            case 121: {
                return "ResetCC";
            }
            case 122: {
                return "Local";
            }
            case 123: {
                return "AllNoteOff";
            }
            case 124: {
                return "OmniOff";
            }
            case 125: {
                return "OmniOn";
            }
            case 126: {
                return "Mono";
            }
            case 127: {
                return "Poly";
            }
        }
        return "#CC(" + data1cc + ")";
    }

    public static String nameOfSystemRealtimeMessage(int command) {
        switch (command) {
            case 248: {
                return "Clock";
            }
            case 249: {
                return "#F9";
            }
            case 250: {
                return "Seq Start";
            }
            case 251: {
                return "Seq Cont";
            }
            case 252: {
                return "Seq Stop";
            }
            case 253: {
                return "#FD";
            }
            case 254: {
                return "Active";
            }
            case 255: {
                return "Reset";
            }
        }
        return null;
    }

    public static String nameOfPortShort(int port) {
        if (port < 0) {
            return "-";
        }
        char portchar = (char)(65 + port);
        return String.valueOf(portchar);
    }

    public static String nameOfPortInput(int port) {
        if (port < 0) {
            return "-";
        }
        char portchar = (char)(65 + port);
        return String.valueOf(portchar);
    }

    public static String nameOfPortOutput(int port) {
        if (port < 0) {
            return "-";
        }
        char portchar = (char)(65 + port);
        return String.valueOf(portchar);
    }

    public static String nameOfSystemCommonMessage(int status) {
        switch (status) {
            case 240: {
                return "SysEx[";
            }
            case 241: {
                return "Time  ";
            }
            case 242: {
                return "SngPos";
            }
            case 243: {
                return "SngNum";
            }
            case 244: {
                return "Sys F4";
            }
            case 245: {
                return "Sys F5";
            }
            case 246: {
                return "Tuner ";
            }
            case 247: {
                return "]SysEx";
            }
        }
        return null;
    }

    public static String nameOfMessage(int status, int data1, int data2) {
        int command = status & 0xF0;
        if (command == 176) {
            if (data1 == 96) {
                return "INC";
            }
            if (data1 == 97) {
                return "DEC";
            }
            if (data1 == 6) {
                return "DATA";
            }
            return MXUtilMidi.nameOfControlChange(data1);
        }
        if (command >= 128 && command <= 224) {
            String name = MXUtilMidi.nameOfChannelMessage(command);
            if (command == 144 || command == 128 || command == 160) {
                return name;
            }
            return name;
        }
        if (status >= 240 && status <= 247) {
            return MXUtilMidi.nameOfSystemCommonMessage(status);
        }
        if (status >= 248 && status <= 255) {
            return MXUtilMidi.nameOfSystemRealtimeMessage(status);
        }
        return "?";
    }

    public static int valueOfPortName(String capital) {
        char portchar = capital.charAt(0);
        if (portchar == '(') {
            return -1;
        }
        return portchar - 65;
    }

    public static int[] textToNoteList(String text) {
        ArrayList<String> list = new ArrayList<String>();
        MXUtil.split(text, list, ' ');
        ArrayList<Integer> retList = new ArrayList<Integer>();
        for (String noteText : list) {
            int note = MXUtilMidi.noteOfName(noteText);
            if (note >= 0) {
                retList.add(note);
                continue;
            }
            System.out.println("parse error [note:" + noteText + "]");
        }
        int[] ret = new int[retList.size()];
        for (int x = 0; x < ret.length; ++x) {
            ret[x] = (Integer)retList.get(x);
        }
        return ret;
    }

    public static String noteListToText(int[] note) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < note.length; ++i) {
            str.append(MXUtilMidi.nameOfNote(note[i]));
            str.append(" ");
        }
        return str.toString();
    }
}

