/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi;

import java.util.Set;
import java.util.TreeMap;

public class MXScaledNumber {
    int _fromsetRoomCount;
    int _tosetRoomCount;

    public MXScaledNumber(int fromsetRoomCount, int tosetRoomCount) {
        this._fromsetRoomCount = fromsetRoomCount;
        this._tosetRoomCount = tosetRoomCount;
    }

    public int getNewNumber(int from, boolean invert) {
        if (from == 0) {
            return 0;
        }
        if (from == this._fromsetRoomCount - 1) {
            return this._tosetRoomCount - 1;
        }
        double fromD = from;
        double toD = fromD * (double)this._tosetRoomCount / (double)this._fromsetRoomCount;
        double multi = (double)this._tosetRoomCount / (double)this._fromsetRoomCount;
        long x = Math.round(toD += (multi -= 1.0) / 2.0);
        return (int)x;
    }

    public static void test(int rangeFrom, int rangeTo, boolean invert) {
        TreeMap<Integer, Integer> count = new TreeMap<Integer, Integer>();
        MXScaledNumber exp = new MXScaledNumber(rangeFrom, rangeTo);
        for (int i = 0; i < rangeFrom; ++i) {
            int from = i;
            int to = exp.getNewNumber(from, invert);
            Integer x = (Integer)count.get(to);
            if (x == null) {
                x = 0;
            }
            count.put(to, x + 1);
        }
        Set keys = count.keySet();
        int minKey = 10000;
        int maxKey = -1;
        int minCount = 10000;
        int maxCount = -1;
        for (Integer seek : keys) {
            Integer value;
            if (seek < minKey) {
                minKey = seek;
            }
            if (seek > maxKey) {
                maxKey = seek;
            }
            if ((value = (Integer)count.get(seek)) < minCount) {
                minCount = value;
            }
            if (value <= maxCount) continue;
            maxCount = value;
        }
        System.out.println("\u5e45 " + rangeFrom + "\u3000\u304b\u3089\u3000" + rangeTo + " \u306b\u4f38\u7e2e\u3057\u307e\u3059");
        System.out.println("  \u4f38\u7e2e\u3055\u308c\u3066\u3001:" + keys.size() + " \u901a\u308a\u306e\u5206\u5e03\u304c\u3067\u304d\u307e\u3057\u305f");
        System.out.println("  \u5206\u5e03\u306f\u3001" + minKey + "\u304b\u3089" + maxKey + " \u306b\u5206\u3051\u3089\u308c\u307e\u3057\u305f");
        System.out.println("  \u308f\u3051\u305f\u7bb1\u306b\u306f\u3001" + minCount + " \u304b\u3089 " + maxCount + " \u500b\u3065\u3064\u5165\u3063\u3066\u3044\u307e\u3059");
    }

    public static void main(String[] args) {
        for (int x = 0; x <= 1; ++x) {
            boolean invert = x == 1;
            MXScaledNumber.test(128, 32768, invert);
            MXScaledNumber.test(32768, 128, invert);
            MXScaledNumber.test(100, 10000, invert);
            MXScaledNumber.test(10000, 100, invert);
            MXScaledNumber.test(2, 3, invert);
            MXScaledNumber.test(3, 2, invert);
            MXScaledNumber.test(20, 300, invert);
            MXScaledNumber.test(300, 20, invert);
            MXScaledNumber.test(59049, 1024, invert);
            MXScaledNumber.test(1024, 59049, invert);
        }
    }
}

