/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi;

import javax.swing.JComponent;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.common.log.MXDebugPrint;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXTiming;

public abstract class MXReceiver {
    private static final MXDebugPrint _debug = new MXDebugPrint(MXReceiver.class);
    private static MXMain _lock = MXMain.getMain();
    private MXReceiver _nextReceiver;
    boolean _usingThis = true;

    public abstract String getReceiverName();

    public abstract JComponent getReceiverView();

    public final MXReceiver getNextReceiver() {
        return this._nextReceiver;
    }

    public void setNextReceiver(MXReceiver next) {
        this._nextReceiver = next;
    }

    protected abstract void processMXMessageImpl(MXMessage var1);

    public synchronized void processMXMessage(MXMessage message) {
        this.processMXMessageImpl(message);
    }

    protected void sendToNext(MXMessage message) {
        if (message._timing == null) {
            message._timing = new MXTiming();
        }
        if (this._nextReceiver != null) {
            MXMain.getMain().messageDispatch(message, this._nextReceiver);
        } else {
            _debug.println("receiver not set " + message);
            _debug.printStackTrace();
        }
    }

    public final boolean isUsingThisRecipe() {
        return this._usingThis;
    }

    public final void setUsingThisRecipe(boolean usingThis) {
        this._usingThis = usingThis;
    }
}

