/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi;

import java.util.Iterator;
import java.util.LinkedList;
import jp.synthtarou.midimixer.libs.common.log.MXDebugPrint;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXTiming;

public class MXNoteOffWatcher {
    private static final MXDebugPrint _debug = new MXDebugPrint(MXNoteOffWatcher.class);
    private LinkedList<Element> _list = new LinkedList();
    Handler _lastHandler;

    public String toString() {
        return "(MXNoteOff + " + this._list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setHandler(MXMessage noteOn, MXMessage noteOff, Handler listener) {
        Object object = MXTiming.mutex;
        synchronized (object) {
            if (noteOn.getCommand() != 144) {
                _debug.println("Its not note on " + noteOn);
                return false;
            }
            this._lastHandler = listener;
            Element e = new Element();
            e.catchSide = noteOn;
            e.sendSide = noteOff;
            e.listener = listener;
            this._list.add(e);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allNoteOff(MXTiming timing) {
        Object object = MXTiming.mutex;
        synchronized (object) {
            for (Element e : this._list) {
                MXMessage base = e.sendSide;
                MXMessage msg = MXMessageFactory.fromShortMessage(base.getPort(), 128 + base.getChannel(), base.getGate(), 0);
                msg._timing = timing;
                e.listener.onNoteOffEvent(msg);
            }
            this._list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allNoteOffToPort(MXTiming timing, int to) {
        Object object = MXTiming.mutex;
        synchronized (object) {
            for (Element e : this._list) {
                if (e.sendSide.getPort() != to) continue;
                MXMessage base = e.sendSide;
                MXMessage msg = MXMessageFactory.fromShortMessage(base.getPort(), 128 + base.getChannel(), base.getGate(), 0);
                msg._timing = timing;
                e.listener.onNoteOffEvent(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allNoteFromPort(MXTiming timing, int from) {
        Object object = MXTiming.mutex;
        synchronized (object) {
            for (Element e : this._list) {
                if (e.catchSide.getPort() != from) continue;
                MXMessage base = e.sendSide;
                MXMessage msg = MXMessageFactory.fromShortMessage(base.getPort(), 128 + base.getChannel(), base.getGate(), 0);
                msg._timing = timing;
                e.listener.onNoteOffEvent(msg);
            }
        }
    }

    public boolean raiseHandler(MXMessage target) {
        return this.raiseHandler(target.getPort(), target._timing, target.getChannel(), target.getData1());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean raiseHandler(int port, MXTiming timing, int ch, int note) {
        Object object = MXTiming.mutex;
        synchronized (object) {
            int proc = 0;
            Iterator it = this._list.iterator();
            while (it.hasNext()) {
                Element e = (Element)it.next();
                if (e.catchSide.getPort() != port || e.catchSide.getChannel() != ch || e.catchSide.getData1() != note) continue;
                MXMessage noteOff = MXMessageFactory.fromShortMessage(e.sendSide.getPort(), 128 + e.sendSide.getChannel(), e.sendSide.getData1(), 0);
                noteOff._timing = timing;
                e.listener.onNoteOffEvent(noteOff);
                it.remove();
                ++proc;
            }
            return proc > 0;
        }
    }

    private static class Element {
        MXMessage catchSide;
        MXMessage sendSide;
        Handler listener;

        private Element() {
        }
    }

    public static interface Handler {
        public void onNoteOffEvent(MXMessage var1);
    }
}

