/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.midi;

import java.util.ArrayList;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.common.MXWrap;
import jp.synthtarou.midimixer.libs.common.MXWrapList;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;

public class MXMessageTemplate
implements Cloneable {
    int _metaType;
    Throwable _trace;
    private final int[] _template;
    private int _bytePosHiValue;
    private int _bytePosValue;
    private int _bytePosGate;
    private int _bytePosHiGate;
    protected int _checksumLength = 0;
    protected int _checksumTo;
    private boolean _init = false;
    public static final String EXCOMMAND_PROGRAM_INC = "@PROG_INC";
    public static final String EXCOMMAND_PROGRAM_DEC = "@PROG_DEC";
    public static final int DTEXT_NONE = 256;
    public static final int DTEXT_VL = 512;
    public static final int DTEXT_VH = 768;
    public static final int DTEXT_GL = 1024;
    public static final int DTEXT_GH = 1280;
    public static final int DTEXT_CH = 1536;
    public static final int DTEXT_1CH = 1792;
    public static final int DTEXT_2CH = 2048;
    public static final int DTEXT_3CH = 2304;
    public static final int DTEXT_PCH = 2560;
    public static final int DTEXT_1RCH = 2816;
    public static final int DTEXT_2RCH = 3072;
    public static final int DTEXT_3RCH = 3328;
    public static final int DTEXT_4RCH = 3584;
    public static final int DTEXT_VF1 = 3840;
    public static final int DTEXT_VF2 = 4096;
    public static final int DTEXT_VF3 = 4352;
    public static final int DTEXT_VF4 = 4608;
    public static final int DTEXT_VPGL = 4864;
    public static final int DTEXT_VPGH = 5120;
    public static final int DTEXT_CCNUM = 5376;
    public static final int DTEXT_RSCTRT1 = 6656;
    public static final int DTEXT_RSCTRT2 = 6912;
    public static final int DTEXT_RSCTRT3 = 7168;
    public static final int DTEXT_RSCTRT1P = 7424;
    public static final int DTEXT_RSCTRT2P = 7680;
    public static final int DTEXT_RSCTRT3P = 7936;
    public static final int DTEXT_RSCTPT1 = 8192;
    public static final int DTEXT_RSCTPT2 = 8448;
    public static final int DTEXT_RSCTPT3 = 8704;
    public static final int DTEXT_RSCTPT1P = 8960;
    public static final int DTEXT_RSCTPT2P = 9216;
    public static final int DTEXT_RSCTPT3P = 9472;
    public static final int DTEXT_CHECKSUM = 9728;
    public static final int DTEXT_4CH = 9984;
    public static final int DTEXT_5CH = 10240;
    public static final int DTEXT_6CH = 10496;
    public static final int DTEXT_7CH = 10752;
    public static final int DTEXT_8CH = 11008;
    public static final int DTEXT_9CH = 11264;
    public static final int DTEXT_ACH = 11520;
    public static final int DTEXT_BCH = 11776;
    public static final int DTEXT_CCH = 12032;
    public static final int DTEXT_DCH = 12288;
    public static final int DTEXT_ECH = 12544;
    public static final int DTEXT_FCH = 12800;
    public static final int DTEXT_RPN = 16384;
    public static final int DTEXT_NRPN = 16640;
    public static final int DTEXT_PROGINC = 20480;
    public static final int DTEXT_PROGDEC = 20736;
    static MXWrapList<Integer> textAlias = new MXWrapList();

    public Object clone() {
        MXMessageTemplate temp = new MXMessageTemplate(this._template);
        temp._metaType = this._metaType;
        temp._bytePosGate = this.getBytePosGate();
        temp._bytePosHiGate = this.getBytePosHiGate();
        temp._bytePosValue = this.getBytePosValue();
        temp._bytePosHiValue = this.getBytePosHiValue();
        temp._checksumLength = this._checksumLength;
        temp._checksumTo = this._checksumTo;
        return temp;
    }

    public MXMessageTemplate(int[] template) {
        this._template = template;
        this._trace = new Throwable(this.toString());
        this.initFields();
    }

    public MXMessageTemplate(int[] template, int checksumLength) {
        if (template == null) {
            throw new IllegalArgumentException("MXMessage is NULL");
        }
        if (template.length == 0) {
            throw new IllegalArgumentException("MXMessage.length == 0");
        }
        this._template = template;
        this._trace = new Throwable();
        this._checksumLength = checksumLength;
        this.initFields();
    }

    public int get(int pos) {
        if (this._template == null) {
            return 0;
        }
        if (pos < 0 || pos >= this._template.length) {
            return 0;
        }
        return this._template[pos];
    }

    public int size() {
        if (this._template == null) {
            return 0;
        }
        return this._template.length;
    }

    public void initFields() {
        this._bytePosHiValue = -1;
        this._bytePosValue = -1;
        this._bytePosGate = -1;
        this._bytePosHiGate = -1;
        if (this._template == null) {
            return;
        }
        if (this._template[0] == 255) {
            this._metaType = this._template[1];
        }
        for (int i = 0; i < this._template.length; ++i) {
            int x = this._template[i];
            if (this._template[i] == 512) {
                this._bytePosValue = i;
                continue;
            }
            if (this._template[i] == 768) {
                this._bytePosHiValue = i;
                continue;
            }
            if (this._template[i] == 1024) {
                this._bytePosGate = i;
                continue;
            }
            if (this._template[i] == 1280) {
                this._bytePosHiGate = i;
                continue;
            }
            if (x != 9728) continue;
            this._checksumTo = i;
        }
        this._init = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] makeBytes(byte[] data, MXMessage message) {
        MXMessageTemplate mXMessageTemplate = this;
        synchronized (mXMessageTemplate) {
            if (data == null || this._template.length != data.length) {
                data = new byte[this._template.length];
            }
            int _checksumTo = -1;
            this._bytePosHiValue = -1;
            this._bytePosValue = -1;
            this._bytePosGate = -1;
            this._bytePosHiGate = -1;
            if (this.isDataentry()) {
                data[0] = (byte)(176 + message.getChannel());
                data[1] = 6;
                data[2] = 0;
            } else {
                for (int i = 0; i < this._template.length; ++i) {
                    int x = this._template[i];
                    if ((x & 0xFF00) != 0) {
                        if (x == 9728) {
                            _checksumTo = i;
                        } else {
                            x = MXMessageTemplate.getDValue(x, message);
                        }
                    }
                    data[i] = (byte)(x & 0xFF);
                }
                int command = data[0] & 0xF0;
                if (command >= 128 && command <= 224) {
                    data[0] = (byte)(command + message.getChannel());
                }
                if (this._checksumLength >= 0 && _checksumTo >= 0) {
                    int x128 = 0;
                    for (int x = _checksumTo - this._checksumLength; x < _checksumTo; ++x) {
                        x128 += data[x];
                    }
                    int r = 128 - (x128 &= 0x7F);
                    data[_checksumTo] = (byte)(r & 0x7F);
                }
            }
        }
        return data;
    }

    public void sealChecksum(byte[] data) {
        if (this._checksumLength >= 0 && this._checksumTo >= 0) {
            int x128 = 0;
            for (int x = this._checksumTo - this._checksumLength; x < this._checksumTo; ++x) {
                x128 += data[x];
            }
            int r = 128 - (x128 &= 0x7F);
            data[this._checksumTo] = (byte)(r & 0x7F);
        }
    }

    public static int getDValue(int alias, MXMessage message) {
        int gate = message.getGate();
        int value = message.getValue();
        int channel = message.getChannel();
        String str = MXMessageTemplate.fromD(alias);
        switch (alias & 0xFF00) {
            case 256: 
            case 16384: 
            case 16640: 
            case 20480: 
            case 20736: {
                return 0;
            }
            case 512: {
                alias = value & 0x7F;
                break;
            }
            case 768: {
                alias = value >> 7 & 0x7F;
                break;
            }
            case 1024: {
                alias = gate & 0x7F;
                break;
            }
            case 1280: {
                alias = gate >> 7 & 0x7F;
                break;
            }
            case 1536: {
                alias = channel;
                break;
            }
            case 1792: {
                alias = 16 + channel;
                break;
            }
            case 2048: {
                alias = 32 + channel;
                break;
            }
            case 2304: {
                alias = 48 + channel;
                break;
            }
            case 9984: {
                alias = 64 + channel;
                break;
            }
            case 10240: {
                alias = 80 + channel;
                break;
            }
            case 10496: {
                alias = 96 + channel;
                break;
            }
            case 10752: {
                alias = 112 + channel;
                break;
            }
            case 11008: {
                alias = 128 + channel;
                break;
            }
            case 11264: {
                alias = 144 + channel;
                break;
            }
            case 11520: {
                alias = 160 + channel;
                break;
            }
            case 11776: {
                alias = 176 + channel;
                break;
            }
            case 12032: {
                alias = 192 + channel;
                break;
            }
            case 12288: {
                alias = 208 + channel;
                break;
            }
            case 12544: {
                alias = 224 + channel;
                break;
            }
            case 12800: {
                alias = 240 + channel;
                break;
            }
            case 2560: {
                if (message.getPort() >= 0 && message.getPort() <= 3) {
                    alias = message.getPort() * 16 + channel;
                    break;
                }
                alias = 48 + channel;
                break;
            }
            case 2816: 
            case 3072: 
            case 3328: 
            case 3584: {
                throw new IllegalArgumentException("1RCH, 2RCH, 3RCH, 4RCH not supported.");
            }
            case 3840: {
                alias = value & 0xF;
                break;
            }
            case 4096: {
                alias = value >> 4 & 0xF;
                break;
            }
            case 4352: {
                alias = value >> 8 & 0xF;
                break;
            }
            case 4608: {
                alias = value >> 12 & 0xF;
                break;
            }
            case 4864: {
                alias = value + gate & 0x7F;
                break;
            }
            case 5120: {
                alias = value + gate >> 7 & 0x7F;
                break;
            }
            case 6656: 
            case 6912: 
            case 7168: {
                throw new IllegalArgumentException("RSCTRT1, RSCTRT2, RSCTRT3 not supported.");
            }
            case 7424: 
            case 7680: 
            case 7936: {
                throw new IllegalArgumentException("RSCTRT1P, RSCTRT2P, RSCTRT3P not supported.");
            }
            case 8192: 
            case 8448: 
            case 8704: {
                throw new IllegalArgumentException("RSCTPT1, RSCTPT2, RSCTPT3 not supported.");
            }
            case 8960: 
            case 9216: 
            case 9472: {
                throw new IllegalArgumentException("RSCTPT1P, RSCTPT2P, RSCTPT3P not supported.");
            }
            case 9728: {
                break;
            }
            case 0: {
                return (byte)alias;
            }
            default: {
                boolean haveEx = false;
                throw new IllegalArgumentException("something wrong " + Integer.toHexString(alias) + " , " + MXMessageTemplate.fromD(alias));
            }
        }
        return (byte)alias;
    }

    public static String fromD(int dtext) {
        int index = textAlias.indexOfValue(dtext);
        if (index >= 0) {
            return ((MXWrap)MXMessageTemplate.textAlias.get((int)index)).name;
        }
        return Integer.toHexString(dtext) + "h";
    }

    public String toDText(MXMessage message) {
        ArrayList<String> array = this.toDArray(message);
        StringBuffer text = new StringBuffer();
        String last = "]";
        for (String seg : array) {
            if (seg.length() == 0) continue;
            if (!(text.length() < 0 || seg.equals("[") || seg.equals("]") || last.equals("[") || last.equals("]"))) {
                text.append(" ");
            }
            last = seg;
            text.append(seg);
        }
        return text.toString();
    }

    public ArrayList<String> toDArray(MXMessage message) {
        int i;
        ArrayList<String> texts = new ArrayList<String>();
        if (this._template == null) {
            return texts;
        }
        if (this._template[0] == 20480) {
            texts.add(EXCOMMAND_PROGRAM_INC);
            return texts;
        }
        if (this._template[0] == 20736) {
            texts.add(EXCOMMAND_PROGRAM_DEC);
            return texts;
        }
        if (this.isDataentry()) {
            if (this._template[0] == 16384) {
                texts.add("@RPN");
            } else {
                texts.add("@NRPN");
            }
            MXVisitant visitant = message.getVisitant();
            if (visitant != null) {
                texts.add(MXMessageTemplate.fromD(visitant.getDataentryMSB()));
                texts.add(MXMessageTemplate.fromD(visitant.getDataentryLSB()));
                texts.add(MXMessageTemplate.fromD(message.getValue()));
                return texts;
            }
            new Exception("RPN have no DATA").printStackTrace();
            return null;
        }
        if (message.isMessageTypeChannel()) {
            int command = message.getCommand();
            int channel = message.getChannel();
            int data1 = message.getData1();
            int data2 = message.getData2();
            if (command == 224) {
                texts.add("@PB");
                texts.add(MXMessageTemplate.fromD(this._template[1]));
                texts.add(MXMessageTemplate.fromD(this._template[2]));
                return texts;
            }
            if (command == 208) {
                texts.add("@CP");
                texts.add(MXMessageTemplate.fromD(this._template[1]));
                return texts;
            }
            if (command == 160) {
                texts.add("@PKP");
                texts.add(MXMessageTemplate.fromD(this._template[1]));
                texts.add(MXMessageTemplate.fromD(this._template[2]));
                return texts;
            }
            if (command == 176) {
                texts.add("@CC");
                texts.add(MXMessageTemplate.fromD(this._template[1]));
                texts.add(MXMessageTemplate.fromD(this._template[2]));
                return texts;
            }
        }
        int csumFrom = -1;
        if (this._checksumLength >= 0) {
            for (i = 0; i < this._template.length; ++i) {
                if (this._template[i] != 9728) continue;
                csumFrom = i - this._checksumLength;
                break;
            }
        }
        for (i = 0; i < this._template.length; ++i) {
            if (i == csumFrom) {
                texts.add("[");
            }
            int code = this._template[i];
            if (i == 0 && message.isMessageTypeChannel()) {
                code &= 0xF0;
            }
            if (code == 9728) {
                texts.add("]");
                continue;
            }
            texts.add(MXMessageTemplate.fromD(code));
        }
        return texts;
    }

    public static int readAliasText(String str) {
        int find;
        int code = -1;
        if (str.startsWith("#") && (find = textAlias.indexOfName(str)) >= 0) {
            code = (Integer)((MXWrap)MXMessageTemplate.textAlias.get((int)find)).value;
            return code & 0xFF00;
        }
        return MXUtil.parseTextForNumber(str) & 0xFF;
    }

    public MXMessage buildMessage(int port, int gate, int value) {
        MXMessage message = new MXMessage(port, this);
        message.setPort(port);
        message.setGate(gate);
        message.setValue(value);
        return message;
    }

    public int getBytePosHiValue() {
        this.initFields();
        return this._bytePosHiValue;
    }

    public int getBytePosValue() {
        this.initFields();
        return this._bytePosValue;
    }

    public int getBytePosGate() {
        this.initFields();
        return this._bytePosGate;
    }

    public int getBytePosHiGate() {
        this.initFields();
        return this._bytePosHiGate;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this._template.length; ++i) {
            int x = this._template[i];
            String seg = MXMessageTemplate.fromD(x);
            if (seg == null) {
                seg = Integer.toHexString(x);
            }
            if (str.length() != 0) {
                str.append(", ");
            }
            str.append(seg);
        }
        return str.toString();
    }

    public boolean isDataentry() {
        return this._template.length > 0 && (this._template[0] == 16384 || this._template[0] == 16640);
    }

    static {
        textAlias.addNameAndValue("#NONE", 256);
        textAlias.addNameAndValue("#VL", 512);
        textAlias.addNameAndValue("#VH", 768);
        textAlias.addNameAndValue("#GL", 1024);
        textAlias.addNameAndValue("#GH", 1280);
        textAlias.addNameAndValue("#CH", 1536);
        textAlias.addNameAndValue("#1CH", 1792);
        textAlias.addNameAndValue("#2CH", 2048);
        textAlias.addNameAndValue("#3CH", 2304);
        textAlias.addNameAndValue("#PCH", 2560);
        textAlias.addNameAndValue("#1RCH", 2816);
        textAlias.addNameAndValue("#2RCH", 3072);
        textAlias.addNameAndValue("#3RCH", 3328);
        textAlias.addNameAndValue("#4RCH", 3584);
        textAlias.addNameAndValue("#VF1", 3840);
        textAlias.addNameAndValue("#VF2", 4096);
        textAlias.addNameAndValue("#VF3", 4352);
        textAlias.addNameAndValue("#VF4", 4608);
        textAlias.addNameAndValue("#VPGL", 4864);
        textAlias.addNameAndValue("#VPGH", 5120);
        textAlias.addNameAndValue("#RSCTRT1", 6656);
        textAlias.addNameAndValue("#RSCTRT2", 6912);
        textAlias.addNameAndValue("#RSCTRT3", 7168);
        textAlias.addNameAndValue("#RSCTRT1P", 7424);
        textAlias.addNameAndValue("#RSCTRT2P", 7680);
        textAlias.addNameAndValue("#RSCTRT3P", 7936);
        textAlias.addNameAndValue("#RSCTPT1", 8192);
        textAlias.addNameAndValue("#RSCTPT2", 8448);
        textAlias.addNameAndValue("#RSCTPT3", 8704);
        textAlias.addNameAndValue("#RSCTPT1P", 8960);
        textAlias.addNameAndValue("#RSCTPT2P", 9216);
        textAlias.addNameAndValue("#RSCTPT3P", 9472);
        textAlias.addNameAndValue("#CHECKSUM", 9728);
        textAlias.addNameAndValue("#4CH", 9984);
        textAlias.addNameAndValue("#5CH", 10240);
        textAlias.addNameAndValue("#6CH", 10496);
        textAlias.addNameAndValue("#7CH", 10752);
        textAlias.addNameAndValue("#8CH", 11008);
        textAlias.addNameAndValue("#9CH", 11264);
        textAlias.addNameAndValue("#ACH", 11520);
        textAlias.addNameAndValue("#BCH", 11776);
        textAlias.addNameAndValue("#CCH", 12032);
        textAlias.addNameAndValue("#DCH", 12288);
        textAlias.addNameAndValue("#ECH", 12544);
        textAlias.addNameAndValue("#FCH", 12800);
        textAlias.addNameAndValue("#RPN", 16384);
        textAlias.addNameAndValue("#NRPN", 16640);
    }
}

