/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.domino;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.domino.DTextFolder;
import jp.synthtarou.midimixer.libs.domino.DTextMessage;
import jp.synthtarou.midimixer.libs.domino.DTextMessageList;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDFile;
import jp.synthtarou.midimixer.libs.midi.programlist.database.PDFileManager;

public class DTextPicker
extends JPanel {
    ArrayList<PDFile> _listRoot = new ArrayList();
    DTextMessage _textReturn;
    private JButton jButtonAddXML;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelName;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldData;
    private JTree jTree1;

    public DTextMessage getTextReturn() {
        return this._textReturn;
    }

    public DTextPicker() {
        this.initComponents();
        PDFileManager manager = PDFileManager.getManager();
        for (int i = 0; i < manager.size(); ++i) {
            this.add(manager.get(i));
        }
        this.setPreferredSize(new Dimension(600, 600));
    }

    public void add(PDFile root) {
        this._listRoot.add(root);
        this.jTree1.setModel(this.createTreeModel());
    }

    public TreeModel createTreeModel() {
        return new DefaultTreeModel(this.createTreeNode());
    }

    public DefaultMutableTreeNode createTreeNode() {
        DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode("treeRoot", true);
        for (PDFile xml : this._listRoot) {
            if (xml.getCCList() == null) continue;
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(xml.getName(), true);
            this.buildTree(child, xml.getCCList());
            treeRoot.add(child);
        }
        return treeRoot;
    }

    public void buildTree(DefaultMutableTreeNode node, DTextMessageList ccList) {
        for (DTextFolder folder : ccList._listFolder) {
            DefaultMutableTreeNode folderNode = new DefaultMutableTreeNode(folder, true);
            node.add(folderNode);
            this.buildTree(folderNode, folder._list);
        }
        for (DTextMessage message : ccList._listMessage) {
            DefaultMutableTreeNode messageNode = new DefaultMutableTreeNode(message, false);
            node.add(messageNode);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jTextFieldData = new JTextField();
        this.jButtonAddXML = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabelName = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                DTextPicker.this.jTree1ValueChanged(evt);
            }
        });
        this.jTree1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DTextPicker.this.jTree1PropertyChange(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jTextFieldData.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jTextFieldData, gridBagConstraints);
        this.jButtonAddXML.setText("Add DominoXML");
        this.jButtonAddXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DTextPicker.this.jButtonAddXMLActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        this.add((Component)this.jButtonAddXML, gridBagConstraints);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DTextPicker.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DTextPicker.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jButtonCancel, gridBagConstraints);
        this.jLabel1.setText("Name");
        this.add((Component)this.jLabel1, new GridBagConstraints());
        this.jLabel2.setText("Data");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabelName.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabelName, gridBagConstraints);
    }

    private void jTree1PropertyChange(PropertyChangeEvent evt) {
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTree1.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            Object sel = node.getUserObject();
            if (sel instanceof DTextFolder) {
                DTextFolder folder = (DTextFolder)sel;
                this.jLabelName.setText(folder._name);
                this.jTextFieldData.setText("");
                this._textReturn = null;
            } else if (sel instanceof DTextMessage) {
                DTextMessage message = (DTextMessage)sel;
                this.jLabelName.setText(message._name);
                this.jTextFieldData.setText(message._dataText + ", Gate:" + message.getGate());
                this._textReturn = message;
            }
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        MXUtil.closeOwnerWindow(this);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this._textReturn = null;
        MXUtil.closeOwnerWindow(this);
    }

    private void jButtonAddXMLActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Try go [OutputPort] Setting");
    }
}

