/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.console;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import jp.synthtarou.midimixer.libs.MXGlobalTimer;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.console.ConsoleElement;
import jp.synthtarou.midimixer.libs.midi.MXTiming;

public class ConsoleModel
implements ListModel<String> {
    ArrayList<ConsoleElement> _list = new ArrayList();
    ArrayList<ListDataListener> _listener = new ArrayList();
    LinkedList<ConsoleElement> _queue = new LinkedList();
    static final int _capacity = 5000;
    static final int _timer = 500;
    int _startPos = 0;
    int _writePos = 0;
    JList _refList;
    MXTiming _selectedTiming = null;
    public boolean _showAllLine = false;
    public boolean _globalSelection = true;
    ListCellRenderer<Object> _renderer = new ListCellRenderer<Object>(){
        DefaultListCellRenderer _def = new DefaultListCellRenderer();

        @Override
        public Component getListCellRendererComponent(JList list, Object var, int index, boolean isSelected, boolean cellHasFocus) {
            ConsoleElement value = ConsoleModel.this.getConsoleElement(index);
            if (ConsoleModel.this._globalSelection) {
                boolean prevSele = isSelected;
                cellHasFocus = false;
                isSelected = false;
                Color back = null;
                boolean gray = false;
                if (value == null) {
                    if (ConsoleModel.this._globalSelection && ConsoleModel.this._selectedTiming == null) {
                        isSelected = prevSele;
                        back = null;
                        gray = true;
                    }
                    var = "-";
                } else if (ConsoleModel.this._selectedTiming == value.getTiming()) {
                    back = Color.red;
                    isSelected = true;
                    back = ConsoleModel.this._selectedTiming != null ? Color.cyan : Color.gray;
                    if (ConsoleModel.this._refList.hasFocus()) {
                        cellHasFocus = true;
                    }
                }
                Component c = null;
                c = this._def.getListCellRendererComponent((JList<?>)list, var, index, isSelected, cellHasFocus);
                if (gray && (back = c.getBackground()) != null) {
                    back = MXUtil.mixedColor(back, Color.white, 20);
                }
                if (back != null) {
                    c.setBackground(back);
                }
                return c;
            }
            Component c = null;
            c = this._def.getListCellRendererComponent((JList<?>)list, var, index, isSelected, cellHasFocus);
            return c;
        }
    };
    boolean _switchPause = false;
    long _repaintLastTick = 0L;
    boolean _repainReserved = false;
    boolean reserved2 = false;
    long lastTick2 = 0L;

    public void bind(JList list) {
        list.setModel(this);
        list.setCellRenderer(this._renderer);
        this._refList = list;
    }

    public void unbind(JList list) {
        this._refList = null;
    }

    public static int getGlobalCapacity() {
        return 5000;
    }

    @Override
    public int getSize() {
        return 5000;
    }

    @Override
    public String getElementAt(int index) {
        ConsoleElement e = this.getConsoleElement(index);
        if (e == null) {
            return "";
        }
        return e.formatMessageLong();
    }

    public int viewIndex(int viewpos) {
        int index = viewpos + this._list.size() - 5000 + this._startPos;
        if (index < 0) {
            return -1;
        }
        while (index >= 5000) {
            index -= 5000;
        }
        if (index >= this._list.size()) {
            return -1;
        }
        return index;
    }

    public int indexView(int index) {
        int viewpos;
        for (viewpos = index - this._list.size() + 5000 - this._startPos; viewpos < 0; viewpos += 5000) {
        }
        while (viewpos >= 5000) {
            viewpos -= 5000;
        }
        return viewpos;
    }

    public ConsoleElement getConsoleElement(int viewpos) {
        int index = this.viewIndex(viewpos);
        if (index >= 0) {
            return this._list.get(index);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ConsoleElement e) {
        if (e.getTiming() == null) {
            new Exception("null timing" + e.formatMessageLong()).printStackTrace();
        }
        LinkedList<ConsoleElement> linkedList = this._queue;
        synchronized (linkedList) {
            this._queue.add(e);
        }
        this.countDown();
    }

    public void switchPause(boolean pause) {
        if (this._switchPause) {
            this._switchPause = false;
            this.fireImpl();
        } else {
            this.fireImpl();
            this._switchPause = true;
        }
    }

    private synchronized void addImpl(ConsoleElement e) {
        if (this._writePos >= 5000) {
            this._writePos = 0;
        }
        if (this._list.size() >= 5000) {
            ConsoleElement prevE;
            int prev = this._writePos - 1;
            if (prev < 0) {
                prev = 4999;
            }
            if ((prevE = this._list.get(prev)) != null) {
                // empty if block
            }
            this._list.set(this._writePos, e);
            ++this._writePos;
            this._startPos = this._writePos;
        } else {
            this._list.add(e);
            ++this._writePos;
        }
    }

    private void countDown() {
        long tickNow = System.currentTimeMillis();
        if (this._switchPause) {
            return;
        }
        if (this._repainReserved) {
            return;
        }
        if (tickNow - this._repaintLastTick >= 500L) {
            this.fireImpl();
        } else {
            this._repainReserved = true;
            MXGlobalTimer.letsCountdown(500L - (tickNow - this._repaintLastTick), new Runnable(){

                @Override
                public void run() {
                    ConsoleModel.this.fireImpl();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireImpl() {
        LinkedList<ConsoleElement> pop;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConsoleModel.this.fireImpl();
                }
            });
            return;
        }
        this._repainReserved = false;
        this._repaintLastTick = System.currentTimeMillis();
        Object object = this._queue;
        synchronized (object) {
            pop = this._queue;
            this._queue = new LinkedList();
        }
        object = this;
        synchronized (object) {
            for (ConsoleElement e : pop) {
                this.addImpl(e);
            }
            ListDataEvent e = new ListDataEvent(this, 0, 0, this._list.size());
            try {
                for (ListDataListener listener : this._listener) {
                    listener.contentsChanged(e);
                }
                this._refList.ensureIndexIsVisible(4999);
                this._refList.repaint();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this._listener.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this._listener.remove(l);
    }

    public void setSelectedTiming(final MXTiming selection) {
        this._selectedTiming = selection;
        long tickNow = System.currentTimeMillis();
        if (tickNow - this.lastTick2 >= 100L) {
            this.reserved2 = true;
            this.fireSelectByTiming(selection);
        } else {
            if (this.reserved2) {
                return;
            }
            this.reserved2 = true;
            MXGlobalTimer.letsCountdown(100L - (tickNow - this.lastTick2), new Runnable(){

                @Override
                public void run() {
                    ConsoleModel.this.fireSelectByTiming(selection);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSelectByTiming(MXTiming selection) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConsoleModel.this.fireImpl();
                }
            });
            return;
        }
        if (selection == null) {
            this._refList.repaint();
            return;
        }
        if (this.reserved2) {
            this.lastTick2 = System.currentTimeMillis();
            this.reserved2 = false;
            ConsoleModel consoleModel = this;
            synchronized (consoleModel) {
                MXTiming t1;
                ConsoleElement e2;
                int low = 0;
                int high = this.getSize();
                while (low < high) {
                    int middle = (high + low) / 2;
                    ConsoleElement elem = this.getConsoleElement(middle);
                    if (elem == null) {
                        low = middle + 1;
                        continue;
                    }
                    MXTiming middlesNumber = elem.getTiming();
                    if (middlesNumber == null) {
                        low = middle + 1;
                        continue;
                    }
                    int comp = middlesNumber.compareTo(selection);
                    if (comp == 0) {
                        low = high = middle;
                        break;
                    }
                    if (comp < 0) {
                        low = middle + 1;
                        continue;
                    }
                    high = middle - 1;
                }
                if (low != high) {
                    this._refList.ensureIndexIsVisible(low);
                    this._refList.repaint();
                    return;
                }
                while (low >= 0) {
                    ConsoleElement e1 = this.getConsoleElement(low);
                    e2 = this.getConsoleElement(low - 1);
                    if (e1 == null || e2 == null) break;
                    t1 = e1.getTiming();
                    MXTiming t2 = e2.getTiming();
                    if (t1 == null || t2 == null || t1.compareTo(t2) != 0) break;
                    --low;
                }
                while (high + 1 < this.getSize()) {
                    ConsoleElement e1 = this.getConsoleElement(high);
                    e2 = this.getConsoleElement(high + 1);
                    if (e1 == null || e2 == null) break;
                    t1 = e1.getTiming();
                    MXTiming t2 = e2.getTiming();
                    if (t1 == null || t2 == null || t1.compareTo(t2) != 0) break;
                    ++high;
                }
                this._refList.ensureIndexIsVisible(low);
                this._refList.repaint();
            }
        }
    }

    public void clear() {
        this._list = new ArrayList();
        this._queue = new LinkedList();
        this._startPos = 0;
        this._writePos = 0;
        ListDataEvent e = new ListDataEvent(this, 0, 0, this._list.size());
        for (ListDataListener listener : this._listener) {
            listener.contentsChanged(e);
        }
    }
}

