/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs.common.async;

import java.util.Comparator;
import java.util.TreeMap;
import jp.synthtarou.midimixer.libs.common.async.Transaction;

public class TransactionBox {
    private static TransactionBox _instance = new TransactionBox();
    Comparator<Transaction> tr = new Comparator<Transaction>(){

        @Override
        public int compare(Transaction o1, Transaction o2) {
            if (o1._transactionTicket < o2._transactionTicket) {
                return -1;
            }
            if (o1._transactionTicket > o2._transactionTicket) {
                return 1;
            }
            return 0;
        }
    };
    TreeMap<Transaction, Transaction> _keepTable = new TreeMap(this.tr);
    int _lastSentTicket = 1;

    public static TransactionBox getInstance() {
        return _instance;
    }

    protected TransactionBox() {
    }

    public synchronized void entryWithTicket(Transaction tr) {
        do {
            ++this._lastSentTicket;
            tr._transactionTicket = tr._transactionTicket;
            if (this._lastSentTicket < 65000) continue;
            this._lastSentTicket = 1;
        } while (this._keepTable.containsKey(tr));
        this._keepTable.put(tr, tr);
    }

    public final void callmeWhenFinished(int ticket, int result) {
        Transaction tr = this.getTransaction(ticket);
        if (tr != null) {
            tr.notifyFinished(result);
            this.closeTicket(tr);
            if (result < 0) {
                System.err.println("Error in " + tr._taskName + " result = " + result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void callmeWhenCanceled(int ticket) {
        Transaction tr = this.getTransaction(ticket);
        tr._canceled = true;
        tr._result = -1;
        tr._running = false;
        TransactionBox transactionBox = this;
        synchronized (transactionBox) {
            this.notifyAll();
        }
        this.closeTicket(tr);
        System.out.println("callmeWhenCanceled " + tr.getTransactionTicket() + " : " + tr._taskName);
    }

    protected synchronized void closeTicket(Transaction tr) {
        this._keepTable.remove(tr);
    }

    private synchronized Transaction getTransaction(int ticket) {
        Transaction dummy = new Transaction(ticket);
        return this._keepTable.get(dummy);
    }
}

