/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer.libs;

import java.util.Comparator;
import java.util.TreeSet;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.libs.midi.MXMessage;
import jp.synthtarou.midimixer.libs.midi.MXMessageFactory;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.midi.port.MXVisitant;
import jp.synthtarou.midimixer.mx30controller.MGStatus;

public class UniqueChecker {
    TreeSet<MGStatus> _alreadyStatus = new TreeSet<MGStatus>(new StatusComparator());
    TreeSet<MXMessage> _alreadyMessage = new TreeSet<MXMessage>(new MessageComparator());
    final MXReceiver _receiver;

    public UniqueChecker(MXReceiver receiver) {
        this._receiver = receiver;
    }

    public boolean checkAlready(MGStatus status) {
        return this._alreadyStatus.contains(status);
    }

    public void push(MGStatus status) {
        this._alreadyStatus.add(status);
    }

    public boolean sendOnlyNeed(MXMessage message) {
        if (message.getCommand() == 144 && message.getValue() == 0) {
            MXMessage message2 = MXMessageFactory.fromShortMessage(message.getPort(), 128 + message.getChannel(), message.getGate(), 0);
            message2._timing = message._timing;
        }
        if (this._receiver == null) {
            return false;
        }
        if (this._alreadyMessage.contains(message)) {
            return false;
        }
        this._alreadyMessage.add(message);
        MXMain.getMain().messageDispatch(message, this._receiver);
        return true;
    }

    static class MessageComparator
    implements Comparator<MXMessage> {
        MessageComparator() {
        }

        @Override
        public int compare(MXMessage o1, MXMessage o2) {
            if (o1.isDataentry()) {
                if (!o2.isDataentry()) {
                    return -1;
                }
                MXVisitant v1 = o1.getVisitant();
                MXVisitant v2 = o2.getVisitant();
                int x = v1.getDataroomType() - v2.getDataroomType();
                if (x == 0) {
                    x = v1.getDataroomMSB() - v2.getDataroomMSB();
                }
                if (x == 0) {
                    x = v1.getDataroomLSB() - v2.getDataroomLSB();
                }
                if (x == 0) {
                    x = v1.getDataentryMSB() - v2.getDataentryMSB();
                }
                if (x == 0) {
                    x = v1.getDataentryLSB() - v2.getDataentryLSB();
                }
                if (x == 0) {
                    x = v1.getDataentryValue14() - v2.getDataentryValue14();
                }
                return x;
            }
            if (o2.isDataentry()) {
                return 1;
            }
            byte[] t1 = o1.getDataBytes();
            byte[] t2 = o2.getDataBytes();
            if (t1 == null) {
                if (t2 == null) {
                    return 0;
                }
                return -1;
            }
            if (t2 == null) {
                return 1;
            }
            int x = t1.length - t2.length;
            if (x < 0) {
                return -1;
            }
            if (x > 0) {
                return 1;
            }
            for (int i = 0; i < t1.length; ++i) {
                x = t1[i] - t2[i];
                if (x < 0) {
                    return -1;
                }
                if (x <= 0) continue;
                return 1;
            }
            return 0;
        }
    }

    static class StatusComparator
    implements Comparator<MGStatus> {
        StatusComparator() {
        }

        @Override
        public int compare(MGStatus o1, MGStatus o2) {
            int p = o1.getPort() - o2.getPort();
            if (p < 0) {
                return -1;
            }
            if (p > 0) {
                return 1;
            }
            int z = o1.getUiType() - o2.getUiType();
            if (z < 0) {
                return -1;
            }
            if (z > 0) {
                return 1;
            }
            int y = o1.getRow() - o2.getRow();
            if (y < 0) {
                return -1;
            }
            if (y > 0) {
                return 1;
            }
            int x = o1.getColumn() - o2.getColumn();
            if (x < 0) {
                return -1;
            }
            if (x > 0) {
                return 1;
            }
            return 0;
        }
    }
}

