/*
 * Decompiled with CFR 0.152.
 */
package jp.synthtarou.midimixer;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.synthtarou.midimixer.MXMain;
import jp.synthtarou.midimixer.MXVersionDialog;
import jp.synthtarou.midimixer.libs.common.MXUtil;
import jp.synthtarou.midimixer.libs.common.log.MXDebugPrint;
import jp.synthtarou.midimixer.libs.midi.MXReceiver;
import jp.synthtarou.midimixer.libs.swing.themes.ThemeManagerDialog;
import jp.synthtarou.midimixer.mx10input.MX10View;
import jp.synthtarou.midimixer.mx60output.MX60View;
import jp.synthtarou.midimixer.mx80vst.MX80Panel;

public class MXMainWindow
extends JFrame {
    private static final MXDebugPrint _debug = new MXDebugPrint(MXMainWindow.class);
    MXMain _main;
    private JMenuBar jMenuBar1;
    private JMenu jMenuFile;
    private JMenuItem jMenuSaveNow;
    private JMenu jMenuWindow;
    private JTabbedPane jTabbedPane1;

    public MXMainWindow(MXMain main) {
        this._main = main;
        this.initComponents();
        this.jMenuBar1.add(Box.createHorizontalGlue());
        JMenu helpParent = new JMenu("Help");
        this.jMenuBar1.add(helpParent);
        JMenuItem helpMenu = new JMenuItem("Wiki");
        helpMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String wikiPage = "https://osdn.net/projects/midimixer/wiki/FrontPage";
                try {
                    Desktop.getDesktop().browse(new URI(wikiPage));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(MXMainWindow.this, "Failed launch www-Browser", "Error", 0);
                }
            }
        });
        helpParent.add(helpMenu);
        JMenuItem helpMenu2 = new JMenuItem("Forum");
        helpMenu2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String wikiPage = "https://osdn.net/projects/midimixer/forums/";
                try {
                    Desktop.getDesktop().browse(new URI(wikiPage));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(MXMainWindow.this, "Failed launch www-Browser", "Error", 0);
                }
            }
        });
        helpParent.add(helpMenu2);
        JMenu appMenu = new JMenu("MIX Recipe VSTi 0.4");
        this.jMenuBar1.add(appMenu);
        JMenuItem themeMenu = new JMenuItem("Theme");
        appMenu.add(themeMenu);
        themeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new ThemeManagerDialog(MXMainWindow.this, true).setVisible(true);
            }
        });
        JMenuItem versionMenu = new JMenuItem("About MIXRecipe");
        appMenu.add(versionMenu);
        versionMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MXVersionDialog.showAsModal(MXMainWindow.this);
            }
        });
    }

    public void initLatebind(Collection<MXReceiver> viewList) {
        this.setTitle("MIX Recipe VSTi 0.4");
        this.setSize(new Dimension(1200, 700));
        MXUtil.centerWindow(this);
        this.setVisible(true);
        int count = 0;
        for (MXReceiver re : viewList) {
            this.jTabbedPane1.add(re.getReceiverName(), re.getReceiverView());
            JMenuItem menu = new JMenuItem(re.getReceiverName());
            menu.addActionListener(new WindowMenuItemListener(count));
            ++count;
            this.jMenuWindow.add(menu);
        }
        JMenuItem menu = new JMenuItem("Free Console / SysEX");
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MXMain.getMain().openFreeConsole();
            }
        });
        this.jMenuWindow.add(menu);
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MXMainWindow.this.tabPanelStateChanged(evt);
            }
        });
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuSaveNow = new JMenuItem();
        this.jMenuWindow = new JMenu();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 2));
        this.getContentPane().add(this.jTabbedPane1);
        this.jMenuFile.setText("File");
        this.jMenuSaveNow.setText("Save All Parameters");
        this.jMenuSaveNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MXMainWindow.this.jMenuSaveNowActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuSaveNow);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuWindow.setText("Window");
        this.jMenuBar1.add(this.jMenuWindow);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void jMenuSaveNowActionPerformed(ActionEvent evt) {
        this._main.saveEverySettingToFile();
    }

    public JTabbedPane getTabbedPanel() {
        return this.jTabbedPane1;
    }

    private void tabPanelStateChanged(ChangeEvent evt) {
        Component view;
        int x = this.jTabbedPane1.getSelectedIndex();
        if (x >= 0 && (view = this.jTabbedPane1.getComponentAt(x)) != null) {
            view.requestFocusInWindow();
            if (view instanceof MX60View) {
                MX60View v60 = (MX60View)view;
                v60.refreshList();
            }
            if (view instanceof MX10View) {
                MX10View v10 = (MX10View)view;
                v10.refreshList();
            }
            if (view instanceof MX80Panel) {
                MX80Panel v80 = (MX80Panel)view;
                v80.onResizeSynth();
            }
        }
    }

    class WindowMenuItemListener
    implements ActionListener {
        int _page;

        public WindowMenuItemListener(int page) {
            this._page = page;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MXMainWindow.this.jTabbedPane1.setSelectedIndex(this._page);
        }
    }
}

