
###############################################################################
# check Env
###############################################################################
if ENV['PAGER'] == nil || ENV['PAGER'] == ""
    if File.exist?("/usr/bin/lv") || File.exist?("/usr/local/bin/lv")
        ENV['PAGER'] = "lv"
    elsif File.exist?("/usr/bin/less") || File.exist?("/usr/local/bin/less") 
        ENV['PAGER'] = "less"
    else
        ENV['PAGER'] = "more"
    end
end

if ENV['EDITOR'] == nil || ENV['EDITOR'] == ""
    if File.exist?("/usr/bin/vim") || File.exist?("/usr/local/bin/vim") 
        ENV['EDITOR'] = "vim"
    else
        ENV['EDITOR'] = "vi"
    end
end

if ENV['SHELL'] == nil || ENV['SHELL'] == "" 
    if File.exist?("/bin/zsh") || File.exist?("/usr/bin/zsh") || File.exist?("/usr/local/bin/zsh") 
        ENV['SHELL'] = "zsh"
    elsif File.exist?("/bin/bash") || File.exist?("/usr/bin/bash") || File.exist?("/usr/local/bin/bash") 
        ENV['SHELL'] = "bash"
    elsif File.exist?("/bin/tcsh") || File.exist?("/usr/bin/tcsh") || File.exist?("/usr/local/bin/tcsh") 
        ENV['SHELL'] = "tcsh"
     else
        ENV['SHELL'] = "sh"
    end
end

###############################################################################
# KCODE
###############################################################################
if `uname -s`.index("CYGWIN") || ENV['LANG'] == "ja_JP.SJIS" || ENV['LANG'] == "ja_JP.sjis"
    $KCODE = "SJIS"
elsif ENV['LANG'] != nil && (ENV['LANG'].index("utf") || ENV['LANG'].index("UTF"))
    $KCODE = "UTF8"
else
    $KCODE = "EUC"
end

###############################################################################
# function definitions
###############################################################################
def is_one_dir()
    vo = view_option();

    return vo == "one_dir" || vo == "one_dir2" || vo == "one_dir3" || vo == "one_dir5";
end

def glob_mark(glob)
    garray = Dir[glob]

    i = 0
    while i < cursor_max()
        fname = file_name(i)
        
        if !File.directory?(adir_path() + fname)
            garray.each {|item|
                if item == fname
                    mark_on(i)
                    break
                end
            }
        end

        i = i + 1
    end
end


def glob_mark_dir(glob)
    garray = Dir[glob]

    i = 0
    while i < cursor_max()
        fname = file_name(i)
        
        if File.directory?(adir_path() + fname) && fname != ".." && fname != "."
            garray.each {|item|
                if item == fname
                    mark_on(i)
                    break
                end
            }
        end

        i = i + 1
    end
end

def regex_mark(regex)
    i = 0
    while i < cursor_max()
        fname = file_name(i)
        
        if !File.directory?(adir_path() + fname)
            if fname =~ regex
                mark_on(i)
            end
        end
        
        i = i + 1
    end
end

def regex_mark_dir(regex)
    i = 0
    while i < cursor_max()
        fname = file_name(i)
        
        if File.directory?(adir_path() + fname) && fname != ".." && fname != "."
            if fname =~ regex
                mark_on(i)
            end
        end
        
        i = i + 1
    end
end

def mark_all_clear()
    i = 0
    while i < cursor_max()
        mark_off(i)
        i = i + 1
    end
end

def mark_all_dir()
    i = 0
    while i < cursor_max()
        fname = file_name(i)
        if File.directory?(fname) && fname != "." && fname != ".."
            mark_on(i)
        end
        
        i+=1
    end
end

def mark_with_comparison()
    if !is_one_dir()
        ret = select_string("Size", ["same", "ignore"], -1)
        
        if ret == -1
            return
        end
        
        size = ret == 0
        
        ret = select_string("Timestamp", ["same", "ignore"], -1)
        
        if ret == -1
            return
        end
        
        timestamp = ret == 0
        
        ret = select_string("Directory", ["ignore", "mark"], -1)
        
        if ret == -1
            return 
        end
        
        directory = ret == 1
        
        i = 0
        while i < cursor_max()
            fname = file_name(i)
            if file_num_sdir(fname) != -1 && fname != "." && fname != ".."
                stat1 = File.stat(adir_path()+fname)
                stat2 = File.stat(sdir_path()+fname)
                
                if (stat1.ftype() == stat2.ftype()) && (!size || size && stat1.size==stat2.size) && (!timestamp || timestamp && stat1.mtime == stat2.mtime) && (directory || !directory && stat1.ftype!="directory")
                    mark_on(i)
                end
            end
            
            i+=1
        end
    end
end

def enter_cursor_down
    if $option_enter_cursor_down
        cursor_move(cursor() + 1)
    end
end

if `uname -s`.index("CYGWIN")
    def key_enter_mark_win_program(prg_name)
        cmdline = 'cmdline("%Q ' + prg_name;
        adir_mark.each {|fname|
            str = adir_path() + fname
            
            if str.index("'")
               cmd = 'cygpath -l -w "' + str + '"'
            else
               cmd = "cygpath -l -w '" + str + "'"
            end
            out = `#{cmd}`
            out.chomp!()
            
            i = 0
            while i < out.length()
               if (i == 0 || !( (kanji_mode()=="euc"||kanji_mode()=="sjis") && is_kanji(out[i-1]))) && out[i] == '\\'[0]
                   out.insert(i, "\\\\\\")
                   i+=3
               end
               
               i+=1
            end
            
            if out.index("'")
                cmdline = cmdline + ' \\"' + out + '\\"';
            else
                cmdline = cmdline + ' \'' + out + '\'';
            end
        }
        cmdline = cmdline + ' &", 0)';
        
        eval(cmdline);
    end

    def key_enter_mark_win_program2(prg_name)
        cmdline = 'shell("%Q ' + prg_name;
        adir_mark.each {|fname|
            str = adir_path() + fname
            
            if str.index("'")
               cmd = 'cygpath -l -w "' + str + '"'
            else
               cmd = "cygpath -l -w '" + str + "'"
            end
            out = `#{cmd}`
            out.chomp!()
            
            i = 0
            while i < out.length()
               if (i == 0 || !( (kanji_mode()=="euc"||kanji_mode()=="sjis") && is_kanji(out[i-1]))) && out[i] == '\\'[0]
                   out.insert(i, "\\")
                   i+=1
               end
               
               i+=1
            end
            
            if out.index("'")
                cmdline = cmdline + ' \\"' + out + '\\"';
            else
                cmdline = cmdline + ' \'' + out + '\'';
            end
        }
        cmdline = cmdline + ' &", "' + prg_name +  '")';
        
        eval(cmdline);
    end
    
    def key_enter_win_program(prg_name)
        key_enter_mark_win_program(prg_name)
        enter_cursor_down
    end

    def key_enter_win_program2(prg_name)
        key_enter_mark_win_program2(prg_name)
        enter_cursor_down
    end
end

def fdclone_type_pagedown()
    if is_one_dir() then
        cursor_move(cursor()+10)
    else
        if cursor_max() <= cursor_maxy() then
            cursor_move(cursor()+10)
        else
            n = (cursor_max()/cursor_maxy())*cursor_maxy()
            if cursor() < n then
                cursor_move(cursor()+cursor_maxy())
            end
        end
    end
end

def fdclone_type_pageup()
    if is_one_dir() then
        cursor_move(cursor()-10)
    else
        if cursor_max() <= cursor_maxy() then
            cursor_move(cursor()-10)
        else 
            if cursor() >= cursor_maxy() then
                cursor_move(cursor()-cursor_maxy())
            end
        end
    end
end

def afu_type_pagedown()
    if is_one_dir() then
        cursor_move(cursor()+10)
    else
        if cursor_max() <= cursor_maxy() then
            cursor_move(cursor()+10)
        else
            cursor_move(cursor()+cursor_maxy()-2)
        end
    end
end

def afu_type_pageup()
    if is_one_dir() then
        cursor_move(cursor()-10)
    else
        if cursor_max() <= cursor_maxy() then
            cursor_move(cursor()-10)
        else    
            cursor_move(cursor()-cursor_maxy()+2)
        end
    end
end

###############################################################################
# hook
###############################################################################
def fdclone_type_cursor_move_hook()
    vo = view_option()
    maxy = cursor_maxy()
    
    if vo == "all" || vo == "one_dir" then
         if cursor() >= scrolltop() + maxy then
             set_scrolltop( (cursor()/maxy)*maxy )
         end
         if cursor() < scrolltop() then
             set_scrolltop( (cursor()/maxy)*maxy )
         end
    elsif vo == "one_dir2" then
        if cursor() >= scrolltop() + maxy*2 then
             set_scrolltop( (cursor()/(maxy*2))*(maxy*2) )
        end
        if cursor() < scrolltop() then
            set_scrolltop( (cursor()/(maxy*2))*(maxy*2) )
        end
    elsif vo == "one_dir3" then
        if cursor() >= scrolltop() + maxy*3 then
             set_scrolltop( (cursor()/(maxy*3))*(maxy*3) )
        end
        if cursor() < scrolltop() then
            set_scrolltop( (cursor()/(maxy*3))*(maxy*3) )
        end
    elsif vo == "one_dir5" then
        if cursor() >= scrolltop() + maxy*5 then
             set_scrolltop( (cursor()/(maxy*5))*(maxy*5) )
        end
        if cursor() < scrolltop() then
            set_scrolltop( (cursor()/(maxy*5))*(maxy*5) )
        end
    end
end

def afu_type_cursor_move_hook()
    vo = view_option()
    maxy = cursor_maxy()
    
    if vo == "all" || vo == "one_dir" then
         if cursor() >= scrolltop() + maxy-2 then
             set_scrolltop(cursor() -maxy+2)
         end
         if cursor() < scrolltop() then
             set_scrolltop(cursor())
         end
    elsif vo == "one_dir2" then
        if cursor() >= scrolltop() + maxy*2 then
             set_scrolltop( (cursor()/(maxy*2))*(maxy*2) )
        end
        if cursor() < scrolltop() then
            set_scrolltop( (cursor()/(maxy*2))*(maxy*2) )
        end
    elsif vo == "one_dir3" then
        if cursor() >= scrolltop() + maxy*3 then
             set_scrolltop( (cursor()/(maxy*3))*(maxy*3) )
        end
        if cursor() < scrolltop() then
            set_scrolltop( (cursor()/(maxy*3))*(maxy*3) )
        end
    elsif vo == "one_dir5" then
        if cursor() >= scrolltop() + maxy*5 then
             set_scrolltop( (cursor()/(maxy*5))*(maxy*5) )
        end
        if cursor() < scrolltop() then
            set_scrolltop( (cursor()/(maxy*5))*(maxy*5) )
        end
    end
end

def cursor_move_hook(i)
    afu_type_cursor_move_hook()
end

###############################################################################
# key settings
###############################################################################
if `uname -s`.chomp() == "FreeBSD"
    CP_OPTION = "-Rp"
else                        # cygwin || Linux
    CP_OPTION = "-Rpd"
end

keycommand NOMETA, KEY_UP,           "*",        "cursor_move(cursor()-1)"
keycommand NOMETA, KEY_DOWN,         "*",        "cursor_move(cursor()+1)"

def key_left()
    if is_one_dir() then
        if cursor_x() > 0 then
            cursor_move(cursor()-cursor_maxy())
        end
    else
        if is_adir_left() then
            if $option_left_right_dir_up
                dir_move('..')
            end
        else
            cursor_left()
        end
    end
end

keycommand NOMETA, KEY_LEFT,         "*",        "key_left()"

def key_right()
    if is_one_dir() then
        if cursor_x() < (cursor_maxx()-1)
            cursor_move(cursor()+cursor_maxy())
        end
    else
        if is_adir_right() then
            if $option_left_right_dir_up
                dir_move('..')
            end
        else
            cursor_right()
        end
    end
end

keycommand NOMETA, KEY_RIGHT,        "*",        "key_right()"

keycommand NOMETA, KEY_PAGEUP,       "*",        "afu_type_pageup()"
keycommand NOMETA, KEY_PAGEDOWN,     "*",        "afu_type_pagedown()"
keycommand NOMETA, KEY_CTRL_P,       "*",        "cursor_move(cursor()-1)"
keycommand NOMETA, KEY_CTRL_N,       "*",        "cursor_move(cursor()+1)"
keycommand NOMETA, KEY_CTRL_B,       "*",        "key_left()"
keycommand NOMETA, KEY_CTRL_F,       "*",        "key_right()"
keycommand NOMETA, KEY_CTRL_D,       "*",        "afu_type_pagedown()"
keycommand NOMETA, KEY_CTRL_U,       "*",        "afu_type_pageup()"
keycommand NOMETA, KEY_CTRL_A,       "*",        "cursor_move(0)"
keycommand NOMETA, KEY_CTRL_E,       "*",        "cursor_move(cursor_max()-1)"
keycommand NOMETA, KEY_CTRL_H,       "*",        "dir_move('..')"
keycommand NOMETA, KEY_BACKSPACE,    "*",        "dir_move('..')"
keycommand META,   KEY_LEFT,         "*",        "dir_back()"
keycommand NOMETA, KEY_META_LEFT,    "*",        "dir_back()"
keycommand NOMETA, KEY_BACKSLASH,    "*",        "dir_move('/')"
keycommand NOMETA, KEY_TILDA,        "*",        "dir_move('~')"
keycommand NOMETA, KEY_SPACE,        "*",        "mark2(cursor); cursor_move(cursor + 1)"
keycommand NOMETA, KEY_HOME,         "*",        "mark_all_files()"
keycommand NOMETA, KEY_END,          "*",        "mark_all()"
keycommand NOMETA, KEY_CTRL_L,       "*",        "refresh()"
keycommand NOMETA, KEY_QMARK,        "*",        "help()"
#keycommand NOMETA, KEY_ESCAPE,       "*",        "mf_exit()"
keycommand NOMETA, KEY_SLASH,        "*",        "isearch()"
keycommand META, KEY_SLASH,          "*",        "isearch_partmatch()"


def key_dot()
    def mask_hook_ldir(fname)
        nil
    end
    def mask_hook_rdir(fname)
        nil
    end
    
    if adir_mask() == "*" && is_dot_dir_mask()
        set_mask("{*,.*}")
        set_mask_sdir("{*,.*}")
        dot_dir_mask(false)
        reread()
    else
        set_mask("*")
        set_mask_sdir("*")
        dot_dir_mask(true)
        reread()
    end
end

keycommand NOMETA, KEY_DOT,    "*",     "key_dot()"


def file_copy(path)
    if path[-1] == "/"[0] || marking()
        if !File.exist?(path)
            strings = ["Yes", "No"]
            if select_string("#{path} does not exist. would you like to create this directory?", strings, 1) == 0
                `mkdir -p #{path} > /dev/null 2> /dev/null`
            end
        end
        if File.directory?(path)
            copy_p(adir_path(), adir_mark(), path, true)
        end
    else
        copy_p(adir_path(), adir_mark(), path, true)
    end
end

def key_copy_p()
    if is_one_dir()
        cmdline('%Q%r%M file_copy(%D1)', -2)
    else 
        if $option_afu_copy
            if marking()
                copy_p(adir_path(), adir_mark(), sdir_path(), true)
            else
                cmdline('%Q%r%M file_copy(%D2)', -2)
            end
        else
            cmdline('%Q%r%M file_copy(%D2)', -2)
        end
    end
end

keycommand NOMETA, KEY_c,      "*",     "key_copy_p()"

keycommand META, KEY_c,      "*",     "if is_one_dir() then cmdline('%tcp #{CP_OPTION} %m1 %D1', -1) else cmdline('%tcp #{CP_OPTION} %m1 %D2', -1) end"

def file_move(path)
    if path[-1] == "/"[0]
        if !File.exist?(path)
            strings = ["Yes", "No"]
            if select_string("#{path} does not exist. would you like to create this directory?", strings, 1) == 0
                `mkdir -p #{path} > /dev/null 2> /dev/null`
            end
        end
        
        if File.directory?(path)
            move(adir_path(), adir_mark(), path, true)
        end
    else
        move(adir_path(), adir_mark(), path, true)
    end
end

def key_move()
    if is_one_dir() 
        cmdline('%Q%r%M file_move(%D1)', -2)
    else 
        if $option_afu_copy
            if marking()
                move(adir_path(), adir_mark(), sdir_path(), true)
            else
                cmdline('%Q%r%M file_move(%D2)', -2)
            end
        else
            cmdline('%Q%r%M file_move(%D2)', -2)
        end
    end
end

keycommand NOMETA, KEY_m,      "*",     "key_move()"
keycommand META, KEY_m,        "*",     "if is_one_dir() then cmdline('%tmv %m1 %D1', -1) else cmdline('%tmv %m1 %D2', -1) end"

def key_delete()
#    if is_one_dir() || !$option_afu_copy || $option_afu_copy && marking()
        remove(adir_path(), adir_mark(), true)
#    end
end

keycommand NOMETA, KEY_d,      "*",     "key_delete()"
keycommand NOMETA, KEY_DELETE, "*",     "key_delete()"

def key_trashbox()
#    if is_one_dir() || !$option_afu_copy || $option_afu_copy && marking()
        trashbox(adir_path(), adir_mark(), true)
#    end
end

keycommand NOMETA, KEY_D,      "*",     "key_trashbox()"

keycommand META, KEY_d,        "*",     "cmdline('%trm -R %m1', 0)"

keycommand NOMETA, KEY_e,      "*",     "shell('%q $EDITOR %f', '%f')"
keycommand NOMETA, KEY_E,      "*",     "shell('%q%t $EDITOR %f', '%f')"
keycommand NOMETA, KEY_v,      "*",     "shell('%q $PAGER %f', '%f')"
keycommand NOMETA, KEY_V,      "*",     "shell('%q%t $PAGER %f', '%f')"

def rename(cname, fname)
    if File.exist?(adir_path() + fname)
        message("file exists(" + fname + ")")
        return false
    end

    begin
        File.rename(cname, fname)
    rescue
        message("rename failed")
        return false
    end
    
    return true
end

def key_rename
    if !marking()
        p = 0
        if cursor_name()[0] != "."[0]
            ret = cursor_name().rindex(".")
            if ret
                p = cursor_name().length - ret
            end
        end
        
        cmdline('%Q%r rename %f, %f', -1 -p)
    end
end

keycommand NOMETA, KEY_r,      "*",     "key_rename()"

def key_rename_mark()
    ret1 = input_box("from", "", 0)
    if ret1[0] == 1
        return
    end
    from = ret1[1]
    
    ret2 = input_box("to", "", 0)
    if ret2[0] == 1
        return
    end
    
    to = ret2[1]
    
    adir_mark2 = []
    adir_mark().each {|file|
        begin
            file2 = file.gsub(/#{from}/, to)
        rescue
            message("regex error")
            refresh
            return
        end
        
        adir_mark2.push(file2)
    }
    
    ### kakuninn ###
    maxx = mgetmaxx()
    maxy = mgetmaxy()
    
    i = 0
    while i < adir_mark2.size() 
        maxx = mgetmaxx()
        maxy = mgetmaxy()
        
        mclear()
        redraw()
        
        mbox(0, 0, maxx-1, maxy-2)
        line = 0
        while line*2+2 < maxy-2 && i < adir_mark2.size()
            mmvprintw(line*2+1, 1, adir_mark()[i])
            mmvprintw(line*2+2, 1, ' -> ' + adir_mark2[i])
            line+=1
            i+=1
        end
        
        if i < adir_mark2.size()
            message("HIT ANY KEY")
        end
    end
    
    ret3 = select_string("rename ok?", ["Yes", "No"], 1)
    
    if ret3 == 1
        return
    end
    
    i = 0
    adir_mark_ = adir_mark().clone
    while i < adir_mark_.size()
        fnum = file_num(adir_mark_[i])
        if !rename(adir_mark_[i], adir_mark2[i])
            break
        end
        
        mark_off(fnum)
        i+=1
    end
    
    reread
end

keycommand NOMETA, KEY_r,      ".mark",     "key_rename_mark()"

keycommand NOMETA, KEY_b,      ".mark", "cmdline('for i in %m1; do cp #{CP_OPTION} $i $i.bak; done', -6)"

def key_backup()
    if cursor_name().index("'")
        cmdline("%Q%r copy_p(adir_path(), adir_mark(), \"#{cursor_name()}.bak\", true)", -8)
    else
        cmdline("%Q%r copy_p(adir_path(), adir_mark(), '#{cursor_name()}.bak', true)", -8)
    end
end

keycommand NOMETA, KEY_b,      "*",     "key_backup()"

def key_pack()
    if is_one_dir()
        if marking()
            if adir_path().index("'")
                cmdline("tar cvfz \"#{adir_path()}.tgz\" %m1", -9)
            else
                cmdline("tar cvfz '#{adir_path()}.tgz' %m1", -9)
            end
        else
            if adir_path().index("'") || cursor_noext().index("'")
                cmdline("tar cvfz \"#{adir_path() + cursor_noext()}.tgz\" %m1", -9)
            else
                cmdline("tar cvfz '#{adir_path() + cursor_noext()}.tgz' %m1", -9)
            end
        end
    else
        if marking()
            if sdir_path().index("'")
                cmdline("tar cvfz \"#{sdir_path()}.tgz\" %m1", -9)
            else
                cmdline("tar cvfz '#{sdir_path()}.tgz' %m1", -9)
            end
        else
            if sdir_path().index("'") || cursor_noext().index("'")
                cmdline("tar cvfz \"#{sdir_path() + cursor_noext()}.tgz\" %m1", -9)
            else
                cmdline("tar cvfz '#{sdir_path() + cursor_noext()}.tgz' %m1", -9)
            end
        end
    end
end

keycommand NOMETA, KEY_p,      "*",     "key_pack()"

def key_Pack()
    if marking()
        cmdline("tar cvfz '.tgz' %m1", -9)
    else
        if cursor_noext().index("'")
            cmdline("tar cvfz \"#{cursor_noext()}.tgz\" %m1", -9)
        else
            cmdline("tar cvfz '#{cursor_noext()}.tgz' %m1", -9)
        end
    end
end

keycommand NOMETA, KEY_P,      "*",     "key_Pack()"

def make_dir(fname)
    if File.exist?(adir_path() + fname)
        message("file exists")
        return
    end

    begin
        Dir.mkdir(adir_path() + fname, 0755)
    rescue
        message("make_dir() failed")
    end
end

def key_make_dir()
   cmdline("%r%Q make_dir ''", -1)
end

keycommand NOMETA, KEY_k,      "*",     "key_make_dir()"

def make_new_file(fname)
    if File.exist?(adir_path() + fname)
        message("file exists")
        return
    end

    begin 
        f = File.new(adir_path() + fname,File::CREAT|File::TRUNC|File::WRONLY)
        #f.chmod(0644)
        f.close()
    rescue
        message("make_new_file() failed")
    end
end

def key_new_file()
    cmdline("%r%Q make_new_file ''", -1)
end

keycommand NOMETA, KEY_n,      "*",     "key_new_file()"

def make_new_link(src, dest)
    if File.exist?(dest) && File.stat(dest).directory?
        if dest[dest.length-1] != "/"[0]
            dest = dest + "/"
        end

        if src =~ /\/\/.+\/.+/
            bname = src.scan(/\/\/.+\/(.+)/)[0][0]
        else
            bname= File.basename(src)
        end

        dest = dest + bname
    end

    if File.exist?(dest)
        message("file exists")
        return
    end

    begin 
        File.symlink(src, dest)
    rescue
        message("make_new_link() failed")
    end
    
    reread()
end

def make_new_link_mark(src, dest)
    if !File.exist?(dest) || !File.stat(dest).directory?
        message("distination is not directory")
        return
    end

    if dest[dest.length-1] != "/"[0]
        dest = dest + "/"
    end

    begin
        mark_num_ = mark_num()
        progress_mark = mark_num()
        
        src.each {|path|
            if path =~ /\/\/.+\/.+/
                fname = path.scan(/\/\/.+\/(.+)/)[0][0]
            else
                fname = File.basename(path)
            end
            
            cursor_move(file_num(fname))
            
            ### draw progress box ###
            redraw()
            
            maxx = mgetmaxx()
            maxy = mgetmaxy()
            
            y = maxy / 2
            
            mbox(y, (maxx-22)/2, 22, 3)
            mmvprintw(y, (maxx-22)/2+2, "progress")
            mmvprintw(y+1, (maxx-22)/2+1, "(%d/%d) files", progress_mark, mark_num_)
            mrefresh()
            
            ### make sym link ###
            File.symlink(path, dest + fname)
            
            fname2 = path[adir_path().length..-1]
            mark_off(file_num(fname2))
            progress_mark-=1
        }
    rescue
        message("make_new_link_mark() failed")
    end
    
    redraw()
    mrefresh()
    
    reread()
end

def key_link()
    if is_one_dir() 
        if marking()
            cmdline("%r%Q%Mmake_new_link_mark(adir_mark_fullpath(), %D1)", -2);
        else
            cmdline("%r%Q%Mmake_new_link(%F, %D1)", -2)
        end
    else 
        if $option_afu_copy
            if marking()
                make_new_link_mark(adir_mark_fullpath(), sdir_path())
            end
        else
            if marking()
               cmdline('%r%Q%Mmake_new_link_mark(adir_mark_fullpath(), %D2)', -2)
            else
                cmdline("%r%Q%Mmake_new_link(%F, %D2)", -2)
            end
        end
    end
end

keycommand NOMETA, KEY_l,      "*",     "key_link()"

def key_Link
    if !marking()
        cmdline("%r%Qmake_new_link(%F, '')", -2)
    end
end

keycommand NOMETA, KEY_L,      "*",     "key_Link()"

def key_unpack_gz
    if cursor_name().rindex(".tar.gz")
        if is_one_dir() 
            cmdline('tar xvfz %f -C %D1', -1)
        else
            cmdline('tar xvfz %f -C %D2', -1)
        end
    else
        cmdline('gzip -d %F', -1)
    end
end

def key_Unpack_gz()
    if cursor_name().rindex(".tar.gz")
        cmdline('tar xvfz %f -C %D1', -1)
    else
        cmdline('gzip -d %F', -1)
    end
end

def key_unpack_bz2()
    if cursor_name().rindex(".tar.bz2")
        if is_one_dir()
            cmdline('tar xvfj %f -C %D1', -1)
        else
            cmdline('tar xvfj %f -C %D2', -1)
        end
    else
        cmdline('bzip2 -d %f', -1)
    end
end

def key_Unpack_bz2()
    if cursor_name().rindex(".tar.bz2")
        cmdline('tar xvfj %f -C %D1', -1)
    else
        cmdline('bzip2 -d %f', -1)
    end
end

keycommand NOMETA, KEY_u, ".gz",      "key_unpack_gz()"
keycommand NOMETA, KEY_U, ".gz",      "key_Unpack_gz()"
keycommand NOMETA, KEY_u, ".bz2",     "key_unpack_bz2()"
keycommand NOMETA, KEY_U, ".bz2",     "key_Unpack_bz2()"
keycommand NOMETA, KEY_u, ".tar",     "if is_one_dir() then cmdline('tar xvf %f -C %D1', -1) else cmdline('tar xvf %f -C %D2', -1) end"
keycommand NOMETA, KEY_U, ".tar",     "cmdline('tar xvf %f -C %D1', -1)"
keycommand NOMETA, KEY_u, ".tgz",     "if is_one_dir() then cmdline('tar xvfz %f -C %D1', -1) else cmdline('tar xvfz %f -C %D2', -1) end"
keycommand NOMETA, KEY_U, ".tgz",     "cmdline('tar xvfz %f -C %D1', -1)"
keycommand NOMETA, KEY_u, ".lzh",     "if is_one_dir() then cmdline('cd %D1; lha x %F', adir_path().size() + 5) else cmdline('cd %D2; lha x %F', sdir_path().size() + 5) end"
keycommand NOMETA, KEY_U, ".lzh",     "cmdline('cd %D1; lha x %F', adir_path().size() + 5)"
keycommand NOMETA, KEY_u, ".ZIP",     "if is_one_dir() then cmdline('unzip %f -d %D1', -1) else cmdline('unzip %f -d %D2', -1) end"
keycommand NOMETA, KEY_U, ".ZIP",     "cmdline('unzip %f -d %D1', -1)"
keycommand NOMETA, KEY_u, ".zip",     "if is_one_dir() then cmdline('unzip %f -d %D1', -1) else cmdline('unzip %f -d %D2', -1) end"
keycommand NOMETA, KEY_U, ".zip",     "cmdline('unzip %f -d %D1', -1)"

keycommand NOMETA, KEY_g,      "*",         "cmdline(\"%q grep '' * -n 2> /dev/null | $PAGER\", 10)"
keycommand NOMETA, KEY_g,      ".mark",     "cmdline(\"%q grep '' %m1 -n 2> /dev/null | $PAGER\", 10)"

if `uname -s`.chomp() == "Linux" || `uname -s`.index("CYGWIN")
    keycommand NOMETA, KEY_G,      "*",     "cmdline(\"%q grep -R '' * -n 2> /dev/null | $PAGER\", 13)"
    keycommand NOMETA, KEY_G,      ".mark",     "cmdline(\"%q grep -R '' %m1 -n 2> /dev/null | $PAGER\", 13)"
else
    keycommand NOMETA, KEY_G,      "*",     "cmdline(\"%q find . | xargs grep -n '' 2> /dev/null | $PAGER\", 28)"
end

def key_mgrep()
    cmdline("%q mgrep \"grep -n '' *\"", 20)
end

keycommand META,   KEY_g,      "*",     "key_mgrep()"
keycommand NOMETA, KEY_STAR,   "*",     "cmdline(\"%r%Q%M glob_mark('*')\", -2)"
keycommand META,   KEY_STAR,   "*",     "cmdline(\"%r%Q%M glob_mark_dir('*')\", -2)"
keycommand NOMETA, KEY_PLUS,   "*",     "cmdline(\"%r%Q%M regex_mark(//)\", -2)"
keycommand META,   KEY_PLUS,   "*",     "cmdline(\"%r%Q%M regex_mark_dir(//)\", -2)"
keycommand NOMETA, KEY_i,      ".dir",  "cmdline('du -sh %f', 7)"
keycommand NOMETA, KEY_i,      "*",     "cmdline('file %m1', 0)"

defmenu("jump",
   "(1) ~/tmp", KEY_1, "dir_move('~/tmp')",
   "(2) ~/public_html", KEY_2, "dir_move('~/public_html')",
   "(3) /usr/include", KEY_3, "dir_move('/usr/include')"
   );

keycommand NOMETA,   KEY_j,      "*",     "menu('jump')"

keycommand NOMETA, KEY_J,      "*",     "cmdline(\"%r%Q dir_move %D1\", -1)"

def key_copy_directory()
    if !is_one_dir()
        dir_move(sdir_path())
        cursor_move(cursor_sdir())
        set_scrolltop(scrolltop_sdir())
        
        if is_adir_left() && $out_of_find_rdir != nil
            $out_of_find_ldir = $out_of_find_rdir
            
            reread()
        elsif is_adir_right() && $out_of_find_ldir != nil
            $out_of_find_rdir = $out_of_find_ldir
            
            reread()
        end
    end
end

keycommand NOMETA, KEY_o,      "*",     "key_copy_directory()"

def key_copy_directory2()
    if !is_one_dir()
        sdir_move(adir_path())
        cursor_move_sdir(cursor())
        set_scrolltop_sdir(scrolltop())
        
        if is_adir_left() && $out_of_find_ldir != nil
            $out_of_find_rdir = $out_of_find_ldir
            
            reread()
        elsif is_adir_right() && $out_of_find_rdir != nil
            $out_of_find_ldir = $out_of_find_rdir
            
            reread()
        end
    end
end

keycommand NOMETA, KEY_O,      "*",     "key_copy_directory2()"

def key_exchange_directory()
    if !is_one_dir()
        out_ldir = $out_of_find_ldir
        out_rdir = $out_of_find_rdir
        
        d = adir_path()
        c = cursor()
        s = scrolltop()
        
        dir_move(sdir_path())
        cursor_move(cursor_sdir())
        set_scrolltop(scrolltop_sdir())
        
        sdir_move(d)
        cursor_move_sdir(c)
        set_scrolltop_sdir(s)
        
        $out_of_find_ldir = out_rdir
        $out_of_find_rdir = out_ldir
        if $out_of_find_ldir != nil || $out_of_find_rdir != nil
            reread()
        end
    end
end

keycommand NOMETA, KEY_w,      "*",     "key_exchange_directory()"
keycommand NOMETA, KEY_q,      "*",     "mf_exit()"

keycommand NOMETA, KEY_f,            "*",        "isearch()"
keycommand NOMETA, KEY_F,            "*",        "isearch_partmatch()"

$disk_read_hook_ldir_on = false
$disk_read_hook_rdir_on = false

def disk_read_hook_ldir()
    if $out_of_find_ldir
        dir = Dir.pwd()
        Dir.chdir(ldir_path())
        
        find_out = $out_of_find_ldir
    
        add_file_ldir("..")
        
        find_out.each { |fname|
            fname.chomp!()
            
            if fname == "."
                next
            end
            
            if fname[0..1] == "./"
                fname = fname[2..-1]
            end
            
            add_file_ldir(fname)
        }
        
        Dir.chdir(dir)
        
        return true
    else
        return nil
    end
end

def disk_read_hook_rdir()
    if $out_of_find_rdir
        dir = Dir.pwd()
        Dir.chdir(rdir_path())
        
        find_out = $out_of_find_rdir
        
        add_file_rdir("..")
        
        find_out.each { |fname|
            fname.chomp!()
            
            if fname == "."
                next
            end
            
            if fname[0..1] == "./"
                fname = fname[2..-1]
            end
            
            add_file_rdir(fname)
        }
        
        Dir.chdir(dir)
        
        return true
    else
        return nil
    end
end

def path_change_hook(is_ldir)
    if is_ldir
        $out_of_find_ldir = nil
    else
        $out_of_find_rdir = nil
    end
end

def key_find(cmd)
    trap("SIGINT") {
        puts "terminated"
        exit 0
    }
    
    puts "searching disk..."
    
    out = `#{cmd}`
    if is_adir_left()
        $out_of_find_ldir = out
    else
        $out_of_find_rdir = out
    end
end

if `uname -s`.index("CYGWIN")
    defmenu("find",
        "(n)ame",          KEY_n,  "cmdline(\"%r%q key_find(\\\"/usr/bin/find . -name '' -follow 2> /dev/null\\\")\", 39)",
        "(r)egex",         KEY_r,  "cmdline(\"%r%q key_find(\\\"/usr/bin/find . -regex '' -follow 2> /dev/null\\\")\", 40)",
        "modified (t)ime", KEY_t,  "cmdline(\"%r%q key_find(\\\"/usr/bin/find . -mtime - -follow 2> /dev/null\\\")\", 40)",
        "modified (m)in",  KEY_m,  "cmdline(\"%r%q key_find(\\\"/usr/bin/find . -mmin - -follow 2> /dev/null\\\")\", 39)",
        "(u)ser",          KEY_u,  "cmdline(\"%r%q key_find(\\\"/usr/bin/find . -user  -follow 2> /dev/null\\\")\", 38)",
        "(g)roup",         KEY_g,  "cmdline(\"%r%q key_find(\\\"/usr/bin/find . -group  -follow 2> /dev/null\\\")\", 39)",
        "(p)ermision",     KEY_p,  "cmdline(\"%r%q key_find(\\\"/usr/bin/find . -perm  -follow 2> /dev/null\\\")\", 38)",
        "(s)ize",          KEY_s,  "cmdline(\"%r%q key_find(\\\"/usr/bin/find . -size k -follow 2> /dev/null\\\")\", 38)",
        "t(y)pe",          KEY_y,  "cmdline(\"%r%q key_find(\\\"/usr/bin/find . -type  -follow 2> /dev/null\\\")\", 38)"
    )
else
    defmenu("find",
        "(n)ame",          KEY_n,  "cmdline(\"%r%q key_find(\\\"find . -name '' -follow 2> /dev/null\\\")\", 30)",
        "(r)egex",         KEY_r,  "cmdline(\"%r%q key_find(\\\"find . -regex '' -follow 2> /dev/null\\\")\", 31)",
        "modified (t)ime", KEY_t,  "cmdline(\"%r%q key_find(\\\"find . -mtime - -follow 2> /dev/null\\\")\", 31)",
        "modified (m)in",  KEY_m,  "cmdline(\"%r%q key_find(\\\"find . -mmin - -follow 2> /dev/null\\\")\", 30)",
        "(u)ser",          KEY_u,  "cmdline(\"%r%q key_find(\\\"find . -user  -follow 2> /dev/null\\\")\", 29)",
        "(g)roup",         KEY_g,  "cmdline(\"%r%q key_find(\\\"find . -group  -follow 2> /dev/null\\\")\", 30)",
        "(p)ermision",     KEY_p,  "cmdline(\"%r%q key_find(\\\"find . -perm  -follow 2> /dev/null\\\")\", 29)",
        "(s)ize",          KEY_s,  "cmdline(\"%r%q key_find(\\\"find . -size k -follow 2> /dev/null\\\")\", 29)",
        "t(y)pe",          KEY_y,  "cmdline(\"%r%q key_find(\\\"find . -type  -follow 2> /dev/null\\\")\", 29)"
    )
end

keycommand META, KEY_f,                 "*",        "menu('find')"

def glob_mask(mask)
    if is_adir_left()
        def mask_hook_ldir(fname)
            nil
        end
    else
        def mask_hook_rdir(fname)
            nil
        end
    end
    
    set_mask(mask)
    reread_adir()
end

def regex_mask(mask) 
    if is_adir_left()
        def mask_hook_ldir(fname)
            begin
                if fname == "."
                    return false
                elsif fname == ".."
                    return true
                elsif File.stat(fname).directory?()
                    return true
                elsif fname =~ /#{ldir_mask()}/
                    return true
                else
                    return false
                end
            rescue
                return false
            end
        end
    else
        def mask_hook_rdir(fname)
            begin
                if fname == "."
                    return false
                elsif fname == ".."
                    return true
                elsif File.stat(fname).directory?()
                    return true
                elsif fname =~ /#{rdir_mask()}/
                    return true
                else
                    return false
                end
            rescue
                return false
            end
        end
    end
    
    set_mask(mask)
    reread_adir()
end


defmenu("sort",
   "sort (n)ame", KEY_n, "sort_name()",
   "sort (N)ame reverse", KEY_N, "sort_name_reverse()",
   "sort (e)xtension", KEY_e, "sort_ext()",
   "sort (E)xtension reverse", KEY_E, "sort_ext_reverse()",
   "sort (s)ize", KEY_s, "sort_size()",
   "sort (S)ize reverse", KEY_S, "sort_size_reverse()",
   "sort (t)ime", KEY_t, "sort_time()",
   "sort (T)ime reverse", KEY_T, "sort_time_reverse()",
   "sort (u)ser", KEY_u, "sort_user()",
   "sort (U)ser reverse", KEY_U, "sort_user_reverse()",
   "sort (g)roup", KEY_g, "sort_group()",
   "sort (G)roup reverse", KEY_G, "sort_group_reverse()",
   "sort toggle (d)ir up", KEY_d, "sort_toggle_dir_up()",
   "view 2dir(a)ll", KEY_a, "view_all()",
   "view 1dir(1)", KEY_1, "view_onedir()",
   "view 1dir(2)", KEY_2, "view_onedir2()",
   "view 1dir(3)", KEY_3, "view_onedir3()",
   "view 1dir(5)", KEY_5, "view_onedir5()",
   "view toggle name(o)nly", KEY_o, "view_nameonly()",
   "view toggle (c)olor", KEY_c, "view_color()",
   "view glob (m)ask", KEY_m, "if is_remain_marks() then cmdline(\"%Q%r glob_mask('')\", -2); else cmdline(\"%Q%r%M glob_mask('')\", -2); end",
   "view regex (M)ask", KEY_M, "if is_remain_marks() then cmdline(\"%Q%r regex_mask('')\", -2); else cmdline(\"%Q%r%M regex_mask('')\", -2); end",
   "view toggle (.) directory mask", KEY_DOT, "dot_dir_mask(!is_dot_dir_mask); reread()"
   );

keycommand NOMETA, KEY_s,      "*",     "menu('sort')"

if `uname -s`.index("CYGWIN")
    defmenu("attribute",
       "ch(m)od (permission)", KEY_m, "cmdline('chmod  %m1', 7)",
       "ch(o)wn (owner)", KEY_o, "cmdline('chown  %m1', 7)",
       "ch(g)rp (group)", KEY_g, "cmdline('chgrp  %m1', 7)",
       "ch(M)od -R (permission)", KEY_M, "cmdline('chmod -R  %m1', 10)",
       "ch(O)wn -R (owner)", KEY_O, "cmdline('chown -R  %m1', 10)",
       "ch(G)rp -R (group)", KEY_G, "cmdline('chgrp -R  %m1', 10)",
       "m(a)ttr (permission and date)", KEY_a, "shell('mattr %m1', 'mattr')",
       "m(A)ttr (windows attribute)", KEY_A, "shell('mattrcyg %m1', 'mattrcyg')");
else
    defmenu("attribute",
       "ch(m)od (permission)", KEY_m, "cmdline('chmod  %m1', 7)",
       "ch(o)wn (owner)", KEY_o, "cmdline('chown  %m1', 7)",
       "ch(g)rp (group)", KEY_g, "cmdline('chgrp  %m1', 7)",
       "ch(M)od -R (permission)", KEY_M, "cmdline('chmod -R  %m1', 10)",
       "ch(O)wn -R (owner)", KEY_O, "cmdline('chown -R  %m1', 10)",
       "ch(G)rp -R (group)", KEY_G, "cmdline('chgrp -R  %m1', 10)",
       "m(a)ttr (permission and date)", KEY_a, "shell('mattr %m1', 'mattr')");
end

keycommand NOMETA, KEY_a,      "*",     "menu('attribute')"

defmenu("file_attr_sudo",
   "sudo ch(m)od (permission)", KEY_m, "cmdline('sudo chmod  %m1', 12)",
   "sudo ch(o)wn (owner)", KEY_o, "cmdline('sudo chown  %m1', 12)",
   "sudo ch(g)rp (group)", KEY_g, "cmdline('sudo chgrp  %m1', 12)",
   "sudo ch(M)od -R (permission)", KEY_M, "cmdline('sudo chmod -R  %m1', 15)",
   "sudo ch(O)wn -R (owner)", KEY_O, "cmdline('sudo chown -R  %m1', 15)",
   "sudo ch(G)rp -R (group)", KEY_G, "cmdline('sudo chgrp -R  %m1', 15)",
   "sudo m(a)ttr (permission and date)", KEY_a, "shell('sudo mattr %m1', 'mattr')");

def key_sudo_unpack()
    ext = cursor_ext()
    if ext == "gz" 
        if cursor_name().rindex(".tar.gz")
            if is_one_dir()
                cmdline('sudo tar xvfz %f -C %D1', -1)
            else
                cmdline('sudo tar xvfz %f -C %D2', -1)
            end
        else
            cmdline('sudo gzip -d %F', -1)
        end
    elsif ext == "bz2"
        if cursor_name().rindex(".tar.bz2")
            if is_one_dir()
                cmdline('sudo tar xvfj %f -C %D1', -1)
            else
                cmdline('sudo tar xvfj %f -C %D2', -1)
            end
        else
            cmdline('sudo bzip2 -d %f', -1)
        end
    elsif ext == "tar"
        if is_one_dir() 
            cmdline('sudo tar xvf %f -C %D1', -1) 
        else 
            cmdline('sudo tar xvf %f -C %D2', -1)
        end
    elsif ext == "tgz"
        if is_one_dir()
            cmdline('sudo tar xvfz %f -C %D1', -1)
        else
            cmdline('sudo tar xvfz %f -C %D2', -1)
        end
    elsif ext == "lzh"
        if is_one_dir()
            cmdline('cd %D1; sudo lha x %F', adir_path().size() + 5)
        else 
            cmdline('cd %D2; sudo lha x %F', sdir_path().size() + 5)
        end
    elsif ext == "zip" || ext == "ZIP"
        if is_one_dir()
            cmdline('sudo unzip %f -d %D1', -1)
        else
            cmdline('sudo unzip %f -d %D2', -1)
        end
    end
end

def key_sudo_Unpack()
    ext = cursor_ext()
    
    if ext == "gz"
        if cursor_name().rindex(".tar.gz")
            cmdline('sudo tar xvfz %f -C %D1', -1)
        else
            cmdline('sudo gzip -d %F', -1)
        end
    elsif ext == "bz2"
        if cursor_name().rindex(".tar.bz2")
            cmdline('sudo tar xvfj %f -C %D1', -1)
        else
            cmdline('sudo bzip2 -d %f', -1)
        end
    elsif ext == "tar"
        cmdline('sudo tar xvf %f -C %D1', -1)
    elsif ext == "tgz"
        cmdline('sudo tar xvfz %f -C %D1', -1)
    elsif ext == "zip" || ext == "ZIP"
        cmdline('sudo unzip %f -d %D1', -1)
    elsif ext == "lzh"
        cmdline('cd %D1; sudo lha x %F', adir_path().size() + 5)
    end
end

def key_sudo_excute()
    if File.stat(adir_path() + cursor_name()).executable?
        cmdline('sudo ./%f ', 0)
    else
        cmdline('sudo  ./%f', 6)
    end
end

def key_sudo_eXcute()
    if File.stat(adir_path() + cursor_name()).executable?
        cmdline('%t sudo ./%f ', 0)
    else
        cmdline('%t sudo  ./%f', 9)
    end
end

defmenu("sudo-menu",
   "sudo (c)opy", KEY_c,   "if is_one_dir() then cmdline('sudo cp #{CP_OPTION} %m1 %D1', -1) else cmdline('sudo cp #{CP_OPTION} %m1 %D2', -1) end",
   "sudo (m)v", KEY_m,      "if is_one_dir() then cmdline('sudo mv %m1 %D1', -1) else cmdline('sudo mv %m1 %D2', -1) end",
   "sudo (d)elete",  KEY_d, "cmdline('sudo rm -R %m1', 0)",
   "sudo (r)ename", KEY_r, "cmdline('sudo mv %f %f', -1)",
   "sudo (a)ttr menu",  KEY_a, "menu('file_attr_sudo')",
   "sudo (e)dit", KEY_e,   "shell('%q sudo $EDITOR %f', '%f')",
   "sudo (E)dit", KEY_E,   "shell('%t%q sudo $EDITOR %f', '%f')",
   "sudo (v)iewer", KEY_v,     "shell('%q sudo $PAGER %f', '%f')",
   "sudo (V)iewer", KEY_V,     "shell('%t%q sudo $PAGER %f', '%f')",
   "sudo (p)ack", KEY_p, "if is_one_dir() then cmdline('sudo tar cvfz %X.tgz %m1', -9) else cmdline('sudo tar cvfz %D2%X.tgz %m1', -9) end", 
   "sudo (P)ack", KEY_P,     "cmdline('sudo tar cvfz %X.tgz %m1', -9)",
   "sudo (u)npack", KEY_u,     "key_sudo_unpack()",
   "sudo (U)npack", KEY_U,     "key_sudo_Unpack()",
   "sudo ma(k)e dir", KEY_k,   "cmdline(\"sudo mkdir -p ''\", -1)", 
   "sudo (n)ew file", KEY_n,   "cmdline(\"sudo touch ''\", -1)",
   "sudo make (l)ink", KEY_l,  "if is_one_dir() then cmdline('sudo ln -s %M1 %D1', -1) else cmdline('sudo ln -s %M1 %D2', -1) end",
   "sudo make (L)ink", KEY_L,  "cmdline('sudo ln -s %F %D1', -1)",
   "sudo (g)rep", KEY_g,       "cmdline(\"%q sudo grep '' * -n 2> /dev/null | $PAGER\", 15)",
   "sudo (G)rep", KEY_G,       "cmdline(\"%q sudo grep -R '' * -n 2> /dev/null | $PAGER\", 17)",
   "sudo e(x)ecute", KEY_x, "key_sudo_excute()",
   "sudo e(X)ecute", KEY_X, "key_sudo_eXcute()",
   "sudo (b)ackup", KEY_b, "cmdline('sudo cp #{CP_OPTION} %f %f', -1)",
   "sudo run shell(:)", KEY_COLON, "shell('%q echo \"-+- \"%D1\" -+-\"; ls -aFG; sudo $SHELL', \"#{ENV['SHELL']}\")", 
   "sudo s(h)ell", KEY_h,   "cmdline('sudo ', 0)",
   "sudo s(H)ell with xterminal", KEY_H,   "cmdline('%t sudo ', 0)");

if !`uname -s`.index("CYGWIN")
    keycommand NOMETA, KEY_DOLLAR,       "*",     "menu('sudo-menu')"
end

defmenu("extra-menu",
   "(1) cmdline completion $PATH rehash",   KEY_1, "rehash()", 
   "(2) back to previous direcotry",        KEY_2, "dir_back()",
   "(3) regex_mark",                        KEY_3, "cmdline(\"%r%Q%M regex_mark(//)\", -2)",
   "(4) regex_mark_dir",                    KEY_4, "cmdline(\"%r%Q%M regex_mark_dir(//)\", -2)",
   "(5) mark_all_files",                    KEY_5, "mark_all_files()",
   "(6) mark_all",                          KEY_6, "mark_all()",
   "(7) mark_all_dir",                      KEY_7, "mark_all_dir()",
   "(8) mark_all_clear",                    KEY_8, "mark_all_clear()",
   "(9) mark_with_comparison",              KEY_9, "mark_with_comparison()",
   "(a) compile",                           KEY_a, "cmdline(\"%q mcompile 'make -k '\", -1)"
   );

keycommand NOMETA, KEY_UNDERBAR,     "*",     "menu('extra-menu')"

keycommand NOMETA, KEY_h,            "*",        "cmdline('', 0)"
keycommand NOMETA, KEY_H,            "*",        "cmdline('%t ', 0)"

keycommand NOMETA, KEY_x,            ".mark",    "cmdline('for i in %m1; do  ./$i; done', 18)"
if `uname -s`.index("CYGWIN")
    keycommand NOMETA, KEY_x,        ".exe",     "cmdline('./%f ', 0)"
else
    keycommand NOMETA, KEY_x,        ".execute", "cmdline('./%f ', 0)"
end
keycommand META, KEY_x,              "*",        "cmdline('%r ', 0)"
keycommand NOMETA, KEY_x,            "*",        "cmdline(' ./%f', 1)"

keycommand NOMETA, KEY_X,            ".mark",    "cmdline('%t for i in %m1; do  ./$i; done', 21)"
if `uname -s`.index("CYGWIN")
    keycommand NOMETA, KEY_X,        ".exe",     "cmdline('%t ./%f', 0)"
else
    keycommand NOMETA, KEY_X,        ".execute", "cmdline('%t ./%f', 0)"
end
keycommand NOMETA, KEY_X,            "*",        "cmdline('%t  ./%f', 4)"

keycommand NOMETA, KEY_COLON,        "*",        "shell('%q echo \"-+- \"%D1\" -+-\"; ls -aFG; $SHELL', \"#{ENV['SHELL']}\")"

if `uname -s`.index("CYGWIN")
    keycommand META, KEY_COLON,        "*",        "shell('%Q cygstart \"$PWD\" &', 'explore')"
else
    gnome = false
    kde = false
    xfce = false
    `ps ax`.each {|line|
        prog_name = line.split[4]
        if prog_name == "nautilus"
            gnome = true
        elsif prog_name == "kdeinit:"
            kde = true
        elsif prog_name == "xfdesktop"
            xfce = true
        end
    }
    if gnome
        keycommand META, KEY_COLON,        "*",        "shell('%q nautilus file://$PWD 2>/dev/null &', 'nautilus')"
    elsif kde
        keycommand META, KEY_COLON,        "*",        "shell('%q konqueror $PWD 2>/dev/null &', 'konqueror')"
    elsif xfce
        keycommand META, KEY_COLON,        "*",        "shell('%q xffm $PWD 2>/dev/null &', 'xffm')"
    end
end

keycommand NOMETA, KEY_z,            "*",        "xterm_next()"
keycommand NOMETA, KEY_Z,            "*",        "xterm_toggle()"

keycommand NOMETA, KEY_CTRL_C,       "*",        "copy2()"
keycommand NOMETA, KEY_CTRL_X,       "*",        "cut()"
keycommand NOMETA, KEY_CTRL_V,       "*",        "past()"

$default_onedir = "view_onedir2()"

def key_tab()
    if is_one_dir()
        if is_adir_left
            sdir_move(adir_path())
            view_all()
            cursor_other()
        else
            cursor_other()
            dir_move(sdir_path())
            view_all()
            cursor_other()
        end
    else
        if is_adir_left
            eval($default_onedir)
        else
            cursor_other()
            eval($default_onedir)
        end
    end
end

keycommand NOMETA, KEY_CTRL_I,       "*",        "key_tab()"
keycommand NOMETA, KEY_CTRL_T,       "*",        "tab_new(tab_max(), adir_path(), scrolltop(), cursor()); dir_move('~')"
keycommand NOMETA, KEY_CTRL_W,       "*",        "if tab_max() == 0 then dir_move('~') else tab_up(tab_max()-1); tab_close(tab_max()-1) end"

keycommand META, KEY_0,            "*",        "tab_select()"
keycommand META, KEY_1,            "*",        "tab_new(tab_max(), adir_path(), scrolltop(), cursor()); tab_up(0); tab_close(0)"
keycommand META, KEY_2,            "*",        "tab_new(tab_max(), adir_path(), scrolltop(), cursor()); tab_up(1); tab_close(1)"
keycommand META, KEY_3,            "*",        "tab_new(tab_max(), adir_path(), scrolltop(), cursor()); tab_up(2); tab_close(2)"
keycommand META, KEY_4,            "*",        "tab_new(tab_max(), adir_path(), scrolltop(), cursor()); tab_up(3); tab_close(3)"
keycommand META, KEY_5,            "*",        "tab_new(tab_max(), adir_path(), scrolltop(), cursor()); tab_up(4); tab_close(4)"
keycommand META, KEY_6,            "*",        "tab_new(tab_max(), adir_path(), scrolltop(), cursor()); tab_up(5); tab_close(5)"
keycommand META, KEY_7,            "*",        "tab_new(tab_max(), adir_path(), scrolltop(), cursor()); tab_up(6); tab_close(6)"
keycommand META, KEY_8,            "*",        "tab_new(tab_max(), adir_path(), scrolltop(), cursor()); tab_up(7); tab_close(7)"
keycommand META, KEY_9,            "*",        "tab_new(tab_max(), adir_path(), scrolltop(), cursor()); tab_up(8); tab_close(8)"

def key_num(tab_num)
    if tab_num < tab_max()
        if is_one_dir()
            if is_adir_left()
                sdir_move(tab_path(tab_num))
                set_scrolltop_sdir(tab_scrolltop(tab_num))
                cursor_move_sdir(tab_cursor(tab_num))
                view_all()
            else
                cursor_other()
                dir_move(tab_path(tab_num))
                set_scrolltop(tab_scrolltop(tab_num))
                cursor_move(tab_cursor(tab_num))
                view_all()
            end
        else
            if is_adir_left()
                eval($default_onedir)
            else
                cursor_other()
                eval($default_onedir)
            end
        end
    end
end

keycommand NOMETA, KEY_1,            "*",        "key_num(0)"
keycommand NOMETA, KEY_2,            "*",        "key_num(1)"
keycommand NOMETA, KEY_3,            "*",        "key_num(2)"
keycommand NOMETA, KEY_4,            "*",        "key_num(3)"
keycommand NOMETA, KEY_5,            "*",        "key_num(4)"
keycommand NOMETA, KEY_6,            "*",        "key_num(5)"
keycommand NOMETA, KEY_7,            "*",        "key_num(6)"
keycommand NOMETA, KEY_8,            "*",        "key_num(7)"
keycommand NOMETA, KEY_9,            "*",        "key_num(8)"

def key_open_dir_in_other()
    if is_one_dir()
        if is_adir_left()
            sdir_move(adir_path() + cursor_name())
            view_all()
        else
            cursor_other()
            dir_move(adir_path() + cursor_name())
            view_all()
        end
    else
        sdir_move(adir_path() + cursor_name())
    end
end

keycommand NOMETA, KEY_0,            ".dir",        "key_open_dir_in_other()"

###############################################################################
# keymap
###############################################################################
keymap   KEY_UP,        27,   91,   65,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_UP,        27,   79,   65,   -1,       -1,    -1, -1,-1,-1,-1
keymap   KEY_DOWN,      27,   91,   66,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_DOWN,      27,   79,   66,   -1,       -1,    -1, -1,-1,-1,-1
keymap   KEY_RIGHT,     27,   91,   67,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_RIGHT,     27,   79,   67,   -1,       -1,    -1, -1,-1,-1,-1
keymap   KEY_LEFT,      27,   91,   68,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_LEFT,      27,   79,   68,   -1,       -1,    -1, -1,-1,-1,-1
keymap   KEY_INSERT,    27,   91,   50,   126,     -1,     -1, -1,-1,-1,-1
keymap   KEY_DELETE,    27,   91,   51,   126,     -1,     -1, -1,-1,-1,-1
keymap   KEY_BACKSPACE, 127,  -1,   -1,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_HOME,      27,   79,   72,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_HOME,      27,   91,   72,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_HOME,      27,   91,   55,   126,     -1,     -1, -1,-1,-1,-1
keymap   KEY_HOME,      27,   91,   0,    -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_HOME,      27,   91,   49,   126,      -1,    -1, -1,-1,-1,-1
keymap   KEY_END,       27,   79,   70,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_END,       27,   91,   70,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_END,       27,   91,   56,   126,     -1,     -1, -1,-1,-1,-1
keymap   KEY_END,       27,   91,   101,  -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_END,       27,   91,   52,   126,      -1,    -1, -1,-1,-1,-1
keymap   KEY_PAGEUP,    27,   91,   53,   126,     -1,     -1, -1,-1,-1,-1
keymap   KEY_PAGEDOWN,  27,   91,   54,   126,     -1,     -1, -1,-1,-1,-1
keymap   KEY_F1,        27,   91,   49,   49,      126,    -1, -1,-1,-1,-1
keymap   KEY_F1,        27,   79,   80,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_F2,        27,   91,   49,   50,      126,    -1, -1,-1,-1,-1
keymap   KEY_F2,        27,   79,   81,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_F3,        27,   91,   49,   51,      126,    -1, -1,-1,-1,-1
keymap   KEY_F3,        27,   79,   82,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_F4,        27,   91,   49,   52,      126,    -1, -1,-1,-1,-1
keymap   KEY_F4,        27,   79,   83,   -1,      -1,     -1, -1,-1,-1,-1
keymap   KEY_F5,        27,   91,   49,   53,      126,    -1, -1,-1,-1,-1
keymap   KEY_F6,        27,   91,   49,   55,      126,    -1, -1,-1,-1,-1
keymap   KEY_F7,        27,   91,   49,   56,      126,    -1, -1,-1,-1,-1
keymap   KEY_F8,        27,   91,   49,   57,      126,    -1, -1,-1,-1,-1
keymap   KEY_F9,        27,   91,   50,   48,      126,    -1, -1,-1,-1,-1
keymap   KEY_F10,       27,   91,   50,   49,      126,    -1, -1,-1,-1,-1
keymap   KEY_F11,       27,   91,   50,   51,      126,    -1, -1,-1,-1,-1
keymap   KEY_F12,       27,   91,   50,   52,      126,    -1, -1,-1,-1,-1

keymap   KEY_META_LEFT, 27,   91,   51,    68,      -1,    -1, -1,-1,-1,-1 # gnome-terminal
keymap   KEY_META_LEFT, 27,   91,   49,    59,      51,    68, -1,-1,-1,-1 # xterm

###############################################################################
# alias
###############################################################################
malias "&", 0, "&%s"

###############################################################################
# add-on program
###############################################################################
if `uname -s`.index("CYGWIN")
    if `which FFC 2> /dev/null` != ""
        def ffc_copy(path)
            if !File.exist?(path)
                strings = ["Yes", "No"]
                if select_string("#{path} does not exist. would you like to create this directory?", strings, 1) == 0
                    `mkdir -p #{path} > /dev/null 2> /dev/null`
                end
            end
            
            if File.directory?(path)
                if path.index("'")
                    shell('%Q FFC /copy %m1 /to:"$(cygpath -w -l "' + path + '")"', 'ffc')
                else
                    shell('%Q FFC /copy %m1 /to:"$(cygpath -w -l \'' + path + '\')"', 'ffc')
                end
            end
        end
    
        def key_copy2
            if is_one_dir()
                cmdline('%Q%r ffc_copy %D1', -1)
            else
                if $option_afu_copy
                    if marking()
                        if sdir_path().index("'")
                            shell('%QFFC /copy %m1 /to:"$(cygpath -w -l "' + sdir_path() + '")"', 'copy')
                        else
                            shell('%QFFC /copy %m1 /to:"$(cygpath -w -l \'' + sdir_path() + '\')"', 'copy')
                        end
                    else
                        cmdline('%Q%r ffc_copy %D2', -1)
                    end
                else
                    cmdline('%Q%r ffc_copy %D2', -1)
                end
            end
        end
        
        keycommand NOMETA, KEY_c, "*",  "key_copy2()"
        keycommand NOMETA, KEY_C, "*",  "key_copy_p()"
        
        def ffc_copy2(path)
            if !File.exist?(path)
                strings = ["Yes", "No"]
                if select_string("#{path} does not exist. would you like to create this directory?", strings, 1) == 0
                    `mkdir -p #{path} > /dev/null 2> /dev/null`
                end
            end
            
            if File.directory?(path)
                if path.index("'")
                    shell('%Q FFC /copy %m1 /to:"$(cygpath -w -l "' + path + '")" &', 'ffc')
                else
                    shell('%Q FFC /copy %m1 /to:"$(cygpath -w -l \'' + path + '\')" &', 'ffc')
                end
            end
        end
        
        def key_meta_c
            if is_one_dir()
                cmdline('%Q%r ffc_copy2 %D1', -1)
            else
                if $option_afu_copy
                    if marking()
                        if sdir_path().index("'")
                            shell('%QFFC /copy %m1 /to:"$(cygpath -w -l "' + sdir_path() + '")" &', 'copy')
                        else
                            shell('%QFFC /copy %m1 /to:"$(cygpath -w -l \'' + sdir_path() + '\')" &', 'copy')
                        end
                    else
                        cmdline('%Q%r ffc_copy2 %D2', -1)
                    end
                else
                    cmdline('%Q%r ffc_copy2 %D2', -1)
                end
            end
        end
        
        keycommand META, KEY_c, "*",  "key_meta_c()"
        
        def ffc_move(path)
            if !File.exist?(path)
                strings = ["Yes", "No"]
                if select_string("#{path} does not exist. would you like to create this directory?", strings, 1) == 0
                    `mkdir -p #{path} > /dev/null 2> /dev/null`
                end
            end
            
            if File.directory?(path)
                if path.index("'")
                    shell('%Q FFC /move %m1 /to:"$(cygpath -w -l "' + path + '")"', 'ffc')
                else
                    shell('%Q FFC /move %m1 /to:"$(cygpath -w -l \'' + path + '\')"', 'ffc')
                end
            end
        end
        
        def key_move2
            if is_one_dir()
                cmdline('%Q%r ffc_move %D1', -1)
            else
                if $option_afu_copy
                    if marking()
                        if sdir_path().index("'")
                            shell('%QFFC /move %m1 /to:"$(cygpath -w -l "' + sdir_path() + '")"', 'copy')
                        else
                            shell('%QFFC /move %m1 /to:"$(cygpath -w -l \'' + sdir_path() + '\')"', 'copy')
                        end
                    else
                        cmdline('%Q%r ffc_move %D2', -1)
                    end
                else
                    cmdline('%Q%r ffc_move %D2', -1)
                end
            end
        end
        
        keycommand NOMETA, KEY_m, "*",  "key_move2()"
        keycommand NOMETA, KEY_M, "*",  "key_move()"
        
        def ffc_move2(path)
            if !File.exist?(path)
                strings = ["Yes", "No"]
                if select_string("#{path} does not exist. would you like to create this directory?", strings, 1) == 0
                    `mkdir -p #{path} > /dev/null 2> /dev/null`
                end
            end
            
            if File.directory?(path)
                if path.index("'")
                    shell('%Q FFC /move %m1 /to:"$(cygpath -w -l "' + path + '")" &', 'ffc')
                else
                    shell('%Q FFC /move %m1 /to:"$(cygpath -w -l \'' + path + '\')" &', 'ffc')
                end
            end
        end
        
        def key_meta_m
            if is_one_dir()
                cmdline('%Q%r ffc_move2 %D1', -1)
            else
                if $option_afu_copy
                    if marking()
                        if sdir_path().index("'")
                            shell('%QFFC /move %m1 /to:"$(cygpath -w -l "' + sdir_path() + '")" &', 'copy')
                        else
                            shell('%QFFC /move %m1 /to:"$(cygpath -w -l \'' + sdir_path() + '\')" &', 'copy')
                        end
                    else
                        cmdline('%Q%r ffc_move2 %D2', -1)
                    end
                else
                    cmdline('%Q%r ffc_move2 %D2', -1)
                end
            end
        end
        
        keycommand META, KEY_m, "*",  "key_meta_m()"
        
        def key_past
            mclip = get_mclip()
            
            if mclip != nil
                if mclip[0] == 0    # Cut
                    cmd = '%QFFC /move'
                    mclip[2].each {|fname|
                        if fname.index("'")
                            cmd = cmd + ' "' + fname + '"'
                        else
                            cmd = cmd + ' \'' + fname + '\''
                        end
                    }
                    
                    if mclip[1].index("'")
                        cmd = cmd + ' /to:"$(cygpath -w -l "' + adir_path() + '")"'
                    else
                        cmd = cmd + ' /to:"$(cygpath -w -l \'' + adir_path() + '\')"'
                    end
                    
                    cwd = Dir.pwd
                    Dir.chdir(mclip[1])
                    shell(cmd, 'move')
                    Dir.chdir(cwd)
                    
                    remove_mclip
                else                # Copy
                    cmd = '%QFFC /copy'
                    mclip[2].each {|fname|
                        if fname.index("'")
                            cmd = cmd + ' "' + fname + '"'
                        else
                            cmd = cmd + ' \'' + fname + '\''
                        end
                    }
                    
                    if mclip[1].index("'")
                        cmd = cmd + ' /to:"$(cygpath -w -l "' + adir_path() + '")"'
                    else
                        cmd = cmd + ' /to:"$(cygpath -w -l \'' + adir_path() + '\')"'
                    end
                    
                    cwd = Dir.pwd
                    Dir.chdir(mclip[1])
                    shell(cmd, 'copy')
                    Dir.chdir(cwd)
                    
                    remove_mclip()
                end
            end
        end
        
        
        keycommand NOMETA, KEY_CTRL_V,       "*",        "key_past()"
    end

    if `which cdrop 2> /dev/null` != ""
        keycommand META, KEY_ATMARK, "*",  "shell('%Q cdrop %m1','cdrop')"
    end

    if `which ContextMenu 2> /dev/null` != ""
        keycommand NOMETA, KEY_ATMARK, "*",  "key_enter_win_program2('ContextMenu')"
        keycommand NOMETA, KEY_ATMARK, ".mark",  "key_enter_mark_win_program2('ContextMenu')"
    end
end

###############################################################################
# ǉvO
###############################################################################

# fBNgqXg by Lei

# qXg
$my_dir_history_max = 999

$my_dir_history = Array.new()

# fBNgړ\bhI[o[Ch
def dir_move( dir )
    super(dir)

    # dir_move tpXłԂĂΗǂ̂ŃANeBuEBhEc
    $my_dir_history.insert( 0, adir_path )

    # ő嗚zĂ疖폜
    if $my_dir_history.size > $my_dir_history_max
        $my_dir_history.pop
    end
end

# j[\
def menu_dir_history()
    menu_array = Array.new
    counter = 0
    width_max = Integer( mgetmaxx * 2/3 ) # ʂ2/3炢͕\܂傤
    
    # 
    $my_dir_history.each do |i|
        menu_array.push "(#{counter+1}) #{my_get_deform_path(i,width_max)}"
        menu_array.push KEY_a
        menu_array.push "dir_move('#{i}')"
        counter += 1 
    end

    # defmenu 錾 
    if menu_array.size == 0
        defmenu( 'dir_history_menu', "(1) ~ (not history)", KEY_1, "dir_move('~')");
    else
        #message( menu_array.join "," )
        defmenu( 'dir_history_menu', *menu_array )
    end
    # menu Ăяo
    menu('dir_history_menu')
end

# wpath񂪎w̒ȏ゠ΐ擪.../ɂĎw蕶ȉɂȂ悤ɂĕԂ
# AŉwfBNĝ̖max_lengthȏłꍇmax_lengthȏ̕񂪕Ԃ
# ifBNg̒/Ă듮삷邯Ǔ܂Hj
def my_get_deform_path( path, max_length )
    # Ȃ΂̂܂ܕԂ
    if path.length < max_length
        return path
    end

    # /ŋ؂ĂЂԂČ납珈Ă܂
    dirs = path.split(/\//).reverse()
    path_str = '/' + dirs.shift # fBNg΍ɍŒ1͕\悤
    dirs.each do |dir|
    # I[o[`FbNB+4͓'.../'
        if path_str.length + dir.length + 4 > max_length
            break
        end
        path_str = '/' + dir + path_str
    end

    path_str = '...' + path_str

    return path_str
end


keycommand META,   KEY_j,      "*",     "menu_dir_history()"
