###############################################################################
# option settings
###############################################################################
$option_afu_copy = true
$option_left_right_dir_up = false
$option_enter_cursor_down = false
$default_onedir = "view_onedir2()"

option_individual_cursor true
option_check_delete_file true
option_check_copy_file false
option_check_exit true
option_remain_cursor false
option_auto_rehash false
option_remain_marks false
option_read_dir_history true
option_trashbox_path ENV["HOME"] + "/mtrashbox"
option_extension_icase true
option_gnu_screen false
option_xterm false

history_size 10000

if `uname -s`.index("CYGWIN") || ENV['LANG'] == "ja_JP.SJIS" || ENV['LANG'] == "ja_JP.sjis"
    option_kanjicode "sjis"
elsif ENV['LANG'] != nil && (ENV['LANG'].index("utf") || ENV['LANG'].index("UTF"))
    option_kanjicode "utf8"
else
    option_kanjicode "euc"
end

set_shell(ENV['SHELL'], `which #{ENV['SHELL']}`.chomp, "-c")

if `uname -s`.index("CYGWIN")
    set_xterm("ck", "-title", "-e", "", 0)
elsif `which gnome-terminal 2> /dev/null` != ""
    set_xterm("gnome-terminal", "-t", "-e", "", 1)
elsif `which konsole 2> /dev/null` != ""
    set_xterm("konsole", "-T", "-e", "", 0)
elsif `which mlterm 2> /dev/null` != ""
    set_xterm("mlterm", "-T", "-e", "", 0)
elsif `which rxvt 2> /dev/null` != ""
    set_xterm("rxvt", "-T", "-e", "", 0)
elsif `which Eterm 2> /dev/null` != ""
    set_xterm("Eterm", "-T", "-e", "", 0)
elsif `which aterm 2> /dev/null` != ""
    set_xterm("aterm", "-T", "-e", "", 0)
elsif `which kterm 2> /dev/null` != ""
    set_xterm("kterm", "-T", "-e", "", 0)
else
    set_xterm("xterm", "-T", "-e", "", 0)
end

option_bold_exe true
option_bold_dir true
option_color_mark MA_YELLOW
option_color_dir MA_CYAN
option_color_link MA_MAGENTA

# MA_WHITE, MA_BLUE, MA_CYAN, MA_GREEN, MA_YELLOW, MA_MAGENTA, MA_RED

if `uname -s`.index("CYGWIN")
    option_color_exe MA_WHITE
    option_visible_fname_execute false
    option_refresh false
else
    option_color_exe MA_RED
    option_visible_fname_execute true
    option_refresh true
end

###############################################################################
# My keybind
###############################################################################

#keycommand NOMETA, KEY_d,      "*",     "key_trashbox()"
#keycommand NOMETA, KEY_DELETE, "*",     "key_trashbox()"
#keycommand NOMETA, KEY_D,      "*",     "key_delete()"

#keycommand NOMETA, KEY_e,      "*",     "shell('%q emacs %f &', '%f')"

###############################################################################
# extension settings
###############################################################################
keycommand NOMETA, KEY_ENTER, ".mark",      "cmdline(' %m1', 1)"
keycommand NOMETA, KEY_ENTER, ".dir",       "dir_move(cursor_name())"

def key_enter_gz()
    if cursor_name().rindex(".tar.gz")
        cmdline('%q tar tvfz %f | $PAGER', 0)
    else
        cmdline('%q zcat %f | $PAGER', 0)
    end
end

keycommand NOMETA, KEY_ENTER, ".gz",      "key_enter_gz(); enter_cursor_down()"
keycommand NOMETA, KEY_ENTER, ".tgz",     "cmdline('%q tar tvfz %f | $PAGER', 0); enter_cursor_down()"

def key_enter_bz2()
    if cursor_name().rindex(".tar.bz2")
        cmdline('%q tar tvfj %f | $PAGER', 0)
    else
        cmdline('%q bzcat %f | $PAGER', 0)
    end
end

keycommand NOMETA, KEY_ENTER, ".bz2",       "key_enter_bz2(); enter_cursor_down()"

keycommand NOMETA, KEY_ENTER, "makefile",   "cmdline('%q make -f %f  2>&1| $PAGER', -13); enter_cursor_down()"
keycommand NOMETA, KEY_ENTER, "Makefile",   "cmdline('%q make -f %f  2>&1| $PAGER', -13); enter_cursor_down()"

### cygwin ###################################################################
if `uname -s`.index("CYGWIN")
    keycommand NOMETA, KEY_ENTER, ".pl",  "cmdline('perl %f ', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".py",  "cmdline('python %f ', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".rb",  "cmdline('ruby %f ', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, "configure",  "cmdline('./configure ', 0)"
    
    #keycommand NOMETA, KEY_ENTER, ".jpg",  "key_enter_win_program2('gv')"
    
    keycommand NOMETA, KEY_ENTER, ".mark-mp3",  "key_enter_mark_win_program('wmplayer /Add')"
    keycommand NOMETA, KEY_ENTER, ".mark-wav",  "key_enter_mark_win_program('wmplayer /Add')"
    keycommand NOMETA, KEY_ENTER, ".mark-mid",  "key_enter_mark_win_program('wmplayer /Add')"
    keycommand NOMETA, KEY_ENTER, ".mark-mpg",  "key_enter_mark_win_program('wmplayer /Add')"
    keycommand NOMETA, KEY_ENTER, ".mark-mpeg", "key_enter_mark_win_program('wmplayer /Add')"
    
    keycommand NOMETA, KEY_ENTER, ".mark-doc",  "key_enter_mark_win_program('WINWORD')"

    keycommand NOMETA, KEY_ENTER, ".exe",       "cmdline('%Q ./%f  &', -2); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, "*",          "shell('%Q cygstart %f > /dev/null 2> /dev/null', '%f'); enter_cursor_down()"
    
### unix #######################################################################
else
    keycommand NOMETA, KEY_ENTER, ".zip",       "cmdline('%q zipinfo %f | $PAGER', 0); enter_cursor_down()"

    keycommand NOMETA, KEY_ENTER, ".lzh",       "cmdline('%q lha l %f | $PAGER', 0); enter_cursor_down()"

    keycommand NOMETA, KEY_ENTER, ".a",         "cmdline('%q nm %f 2>&1 | $PAGER', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".so",        "cmdline('%q nm -D %f 2>&1 | $PAGER', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".class",     "cmdline('%q java %X', '%X'); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".o",         "cmdline('%q nm %f 2>&1 | $PAGER', 0); enter_cursor_down()"

    keycommand NOMETA, KEY_ENTER, ".html",      "cmdline('%q w3m %f', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".htm",       "cmdline('%q w3m %f', 0); enter_cursor_down()"

    keycommand NOMETA, KEY_ENTER, ".jpg",       "cmdline('%q display %f &', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".jpeg",      "cmdline('%q display %f &', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".gif",       "cmdline('%q display %f &', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".bmp",       "cmdline('%q display %f &', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".pnm",       "cmdline('%q display %f &', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".png",       "cmdline('%q display %f &', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".tif",       "cmdline('%q display %f &', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".eps",       "cmdline('%q display %f &', 0); enter_cursor_down()"

    keycommand NOMETA, KEY_ENTER, ".mp3",       "cmdline('mpg123 %f', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".mark-mp3",  "cmdline('mpg123 %m1', 0)"
    keycommand NOMETA, KEY_ENTER, ".wav",       "cmdline('%q esdplay %f', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".mark-wav",  "cmdline('%q esdplay %m1', 0)"
    keycommand NOMETA, KEY_ENTER, ".mid",       "cmdline('timidity %f', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".mark-mid",  "cmdline('timidity %m1', 0)"

    keycommand NOMETA, KEY_ENTER, ".mpg",       "cmdline('mplayer %f', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".mpeg",      "cmdline('mplayer %f', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".avi",       "cmdline('mplayer %f', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".rm",        "cmdline('realplay %f', 0); enter_cursor_down()"

    defmenu("iso-menu",
       "(d)ump", KEY_d, "cmdline('%q isodump %f', 0); enter_cursor_down()",
       "d(v)d", KEY_v, "cmdline('growisofs -Z /dev/dvd=%f', 0); enter_cursor_down()",
       "(c)d", KEY_c, "cmdline('cdrecord -v dev=0,0,0 speed=8 %f', 0); enter_cursor_down()");

    keycommand NOMETA, KEY_ENTER, ".iso",       "menu('iso-menu')"
    keycommand NOMETA, KEY_ENTER, ".smc",       "cmdline('zsnes %f', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".deb",       "cmdline('sudo dpkg -i %f', 0); enter_cursor_down()"

    keycommand NOMETA, KEY_ENTER, ".pdf",       "cmdline('%q acroread %f &', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".dvi",       "cmdline('xdvi %f &', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, ".ps",        "cmdline('%q lpr %f -P', 0); enter_cursor_down()"
    
    keycommand NOMETA, KEY_ENTER, ".execute",   "cmdline('./%f ', 0); enter_cursor_down()"
    keycommand NOMETA, KEY_ENTER, "*",          "shell('%q $PAGER %f', '%f'); enter_cursor_down()"
end

###############################################################################
# alias
###############################################################################
#malias "L", 0, "| $PAGER"
#malias "CD", 1, "%r%Q dir_move('#0')"
#malias "PSG", 1, "ps auxw | grep #0 | grep -v grep"

###############################################################################
# hook
###############################################################################
def atexit_hook()
    0
end

def view_hook()
    nil
end

def mloop_hook()
    nil
end

def completion_hook(editing, editing_dir, editing_file, editing_before, earray, cmd, editing_position, sqort, dqort, last_sqort, last_dqort)
    $host_names = ["hogehoge.ac.jp", "hogehoge.net"]
    
    if cmd == "myoriginal"
        if editing.size >= 1 && editing[0]=="-"[0]
            array = [
                ["-a", "my original option1"],
                ["-b", "my original option2"]
            ]

            completion2(array, editing, sqort, dqort, last_sqort, last_dqort, true, 5)
            return 3
        end
    end
    
    return completion_hook_default(editing, editing_dir, editing_file, editing_before, earray, cmd, editing_position, sqort, dqort, last_sqort, last_dqort)
end

###############################################################################
# jump menu
###############################################################################
defmenu("jump",
   "(1) ~/tmp",             KEY_1, "dir_move('~/tmp')",
   "(2) ~/public_html",     KEY_2, "dir_move('~/public_html')",
   "(3) /usr/include",      KEY_3, "dir_move('/usr/include')"
   );

###############################################################################
# my commands
###############################################################################
def key_mkisofs()
    if is_one_dir()
        if marking()
            if adir_path().index("'")
                cmdline('mkisofs -r -iso-level=4 -o "#{adir_path()}.iso" %m1', -9)
            else
                cmdline("mkisofs -r -iso-level=4 -o '#{adir_path()}.iso' %m1", -9)
            end
        else
            if adir_path().index("'") || cursor_name().index("'")
                cmdline('mkisofs -r -iso-level=4 -o "#{adir_path() + cursor_name()}.iso" %m1', -9)
            else
                cmdline("mkisofs -r -iso-level=4 -o '#{adir_path() + cursor_name()}.iso' %m1", -9)
            end
        end
    else
        if marking()
            if sdir_path().index("'")
                cmdline('mkisofs -r -iso-level=4 -o "#{sdir_path()}.iso" %m1', -9)
            else
                cmdline("mkisofs -r -iso-level=4 -o '#{sdir_path()}.iso' %m1", -9)
            end
        else
            if sdir_path().index("'") || cursor_name().index("'")
                cmdline('mkisofs -r -iso-level=4 -o "#{sdir_path() + cursor_name()}.iso" %m1', -9)
            else
                cmdline("mkisofs -r -iso-level=4 -o '#{sdir_path() + cursor_name()}.iso' %m1", -9)
            end
        end
    end
end

def key_mkIsofs()
    if marking()
        cmdline("mkisofs -r -iso-level=4 -o '.iso' %m1", -9)
    else
        cmdline("mkisofs -r -iso-level=4 -o '#{cursor_noext()}.iso' %m1", -9)
    end
end

def set_number_at_head()
    if adir_mark().size() > 99
        return
    end
    
    i = 1
    adir_mark().each{ |fname|
        if i < 10
            File.rename(fname, "0" + i.to_s + fname)
        else
            File.rename(fname, i.to_s + fname)
        end
        
        i += 1
    }
end

def del_number_at_head()
    adir_mark().each{ |fname|
        if fname[0] >= "0"[0] && fname[0] <= "9"[0] && fname[1] >= "0"[0] && fname[1] <= "9"[0]
            File.rename(fname, fname[2..-1])
        end
    }
end

defmenu("my_commands",
   "(1) mkisofs",             KEY_1, "key_mkisofs()",
   "(2) mkIsofs",             KEY_2, "key_mkIsofs()",
   "(3) gedit",               KEY_3, "shell('%q gedit %m1 & &> /dev/null', 'gedit')",
   "(4) xmms -Q",             KEY_4, "cmdline('xmms -Q %m1', 0)",
   "(5) /var/log/messages",   KEY_5, "shell('%q sudo $PAGER /var/log/messages', '/var/log/messages')",
   "(6) cdparanoia",          KEY_6, "cmdline('sudo cdparanoia -B 1-; for i in *; do gogo $i; done; sudo rm *wav', 0)",
   "(7) set_number_at_head",  KEY_7, "cmdline('%r%Q set_number_at_head()', 0)",
   "(8) del_number_at_head",  KEY_8, "cmdline('%r%Q del_number_at_head()', 0)"
   );

keycommand NOMETA, KEY_y,      "*",     "menu('my_commands')"

###############################################################################
# New file menu
###############################################################################
def make_new_shell_script(fname)
    if !File.exist?(adir_path() + fname)
        begin 
            f = File.new(adir_path() + fname,File::CREAT|File::TRUNC|File::WRONLY)
            f.chmod(0755)
            f.print("#!/bin/sh\n\n")
            f.close
        rescue
        end
    end
end

def make_new_html(fname)
    if !File.exist?(adir_path() + fname)
        begin 
            f = File.new(adir_path() + fname,File::CREAT|File::TRUNC|File::WRONLY)
            f.print <<EOS
<html>
<head>
<title></title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
</head>
<body>
</body>
</html>
EOS
            f.close
        rescue
        end
    end
end

def make_new_perl_script(fname)
    if !File.exist?(adir_path() + fname)
        begin
            f = File.new(adir_path() + fname,File::CREAT|File::TRUNC|File::WRONLY)
            f.chmod(0755)
            f.print("#!/usr/bin/env perl\n\n")
            f.close
        rescue
        end
    end
end

def make_new_python_script(fname)
    if !File.exist?(adir_path() + fname)
        begin
            f = File.new(adir_path() + fname,File::CREAT|File::TRUNC|File::WRONLY)
            f.chmod(0755)
            f.print("#!/usr/bin/env python\n\n")
            f.close
        rescue
        end
    end
end

def make_new_ruby_script(fname)
    if !File.exist?(adir_path() + fname)
        begin
            f = File.new(adir_path() + fname,File::CREAT|File::TRUNC|File::WRONLY)
            f.chmod(0755)
            f.print("#!/usr/bin/env ruby\n\n")
            f.close
        rescue
        end
    end
end

defmenu("new-file",
    "(s)h script", KEY_s, "cmdline('%r%Q make_new_shell_script \\'.sh\\'', -4)",
    "(h)tml", KEY_h, "cmdline('%r%Q make_new_html \\'.html\\'', -6)",
    "(p)erl script", KEY_p, "cmdline('%r%Q make_new_perl_script \\'.pl\\'', -4)",
    "p(y)thon script", KEY_y, "cmdline('%r%Q make_new_python_script \\'.py\\'', -4)",
    "(r)uby script", KEY_r, "cmdline('%r%Q make_new_ruby_script \\'.rb\\'', -4)");

keycommand NOMETA, KEY_N,      "*",     "menu('new-file')"
