#ifndef MFILER2_COMMON
#define MFILER2_COMMON

extern "C" {
#include "ruby.h"


extern VALUE ruby_errinfo;
    
#define TAG_RETURN	0x1
#define TAG_BREAK	0x2
#define TAG_NEXT	0x3
#define TAG_RETRY	0x4
#define TAG_REDO	0x5
#define TAG_RAISE	0x6
#define TAG_THROW	0x7
#define TAG_FATAL	0x8

#include "config.h"
#include "mlib/mlib.h"
#include "mlib/mdebug.h"
#include "mlib/mlist.h"
#include "mlib/mvector.h"
#include "mlib/mstring.h"
#include "mlib/mhash.h"
#include "mlib/mcurses.h"

#include <termios.h>
}

using namespace std;

/// menu.cpp ///
#include "menu.h"

extern cMenu* gActiveMenu;
extern hash_obj* gMenu;

/// dirwnd.cpp ///
#include "dirwnd.h"

/// main.cpp ///
extern char** environ;

extern cDirWnd* gLDir;
extern cDirWnd* gRDir;
extern bool gMainLoop;
extern hash_obj* gKeyCommand[2][KEY_MAX];
extern bool gGnuScreen;
extern bool gPty;
extern bool gAutoRehash;
extern bool gReadDirHistory;
extern bool gExtensionICase;
extern bool gVisibleFileNameExecute;

void cut(char* src, char* dest, int len);

extern bool gErrMsgCancel;
int err_msg(char* msg, ...);
void msg(char* msg, ...);
void msg_nonstop(char* msg, ...);
int select_str(char* msg, char* str[], int len, int cancel);
void view(bool cmdline);
int input_box(char* msg, char* result, char* def_input, int def_cursor);

// path2 must have enough space
bool correct_path(cDirWnd* path_base_dir, char* path, char* path2);
void strtolower(char* result);
void output_eval_error(int error);

extern bool gISearch;
extern bool gISearchPartMatch;
extern bool gColor;
extern bool gIndividualCursor;
extern bool gCheckDeleteFile;
extern bool gCheckCopyFile;
extern bool gCheckExit;
extern bool gProcessLine;
extern char gTrashBoxName[PATH_MAX];
extern bool gRemainCursor;
extern bool gUnixDomainSocket;

extern bool gBoldExe;
extern bool gBoldDir;
extern int gColorMark;
extern int gColorDir;
extern int gColorExe;
extern int gColorLink;

/// command.cpp ///
void command_init();
void command_final();

/// cmdline.cpp ///
//const int kOutputSize = 131072;
const int kOutputSize = 65536;
struct sMasterTty
{
    int mFD;
    char mName[1024];
    pid_t mPID;
    
    char mOutput[kOutputSize];
    int mOutputTail;
};

extern vector_obj* gTty;
extern bool gCmdLineActive;   // readonly
extern vector_obj* gCCandidate;;    // readonly
extern vector_obj* gHCandidate;    // readonly
extern int gHistorySize;

extern bool gXterm;
extern bool gXtermNext;
extern bool gXterm2;

extern bool gDotDirMask;

extern VALUE gXtermPrgName;
extern VALUE gXtermOptTitle;
extern VALUE gXtermOptEval;
extern VALUE gXtermOptExtra;
extern VALUE gXtermType;

extern char gShellName[256];
extern char gShellPath[256];
extern char gShellOptEval[256];

extern bool gCompletionMenu;

void cmdline_init();
void cmdline_init_after_rc_file();
void cmdline_final();
void cmdline_start(char* cmd, int posion);
void cmdline_input(int meta, int key);
void cmdline_completion_menu_input(int meta, int key);
void cmdline_view();
void cmdline_completion_view();
void cmdline_history_view();
void cmdline_history_input(int meta, int key);
void cmdline_run(char* str, char* title);
void cmdline_restore_pty(int n);
void cmdline_read_history_file();
int cmdline_select_pty(char* title);
void cmdline_alias_add(char* alias, int arg_num, char* cmd);
void cmdline_rehash();
void cmdline_completion(VALUE all_candidate, char* editing, bool sqort, bool dqort, bool last_sqort, bool last_dqort, bool add_space);
void cmdline_completion2(VALUE all_candidate, char* editing, bool sqort, bool dqort, bool last_sqort, bool last_dqort, bool add_space, int candidate_len);

/// file.cpp ///
enum eCopyOverride { kNone, kYesAll, kNoAll, kCancel, kSelectNewer };
extern eCopyOverride gCopyOverride;

enum eWriteProtected { kWPNone, kWPYesAll, kWPNoAll, kWPCancel };
extern eWriteProtected gWriteProtected;

bool file_copy(char* spath, char* dpath, bool move, bool preserve);
bool file_remove(char* path, bool no_ctrl_c);

/// help.cpp ///
extern bool gViewHelp;

void help_start();
void help_view();
void help_input(int meta, int key);

/// regex.c ///
void regex_init();
void regex_final();
int regcmp(char* reg, char* str);

#endif
