#ifndef MINATO__MHASH_H
#define MINATO__MHASH_H

#define HASH_KEYSIZE_PER_ONE_IT 5
   
typedef struct _hash_it {
   char* mKey;
   
   void* mItem;
   struct _hash_it* mCollisionIt;

   struct _hash_it* mNextIt;
} hash_it;

typedef struct {
   hash_it** mTable;
   int mTableSize;

   hash_it* mEntryIt;
} hash_obj;

hash_obj* hash_new(int size);
void hash_delete(hash_obj* self);

void hash_put(hash_obj* self, char* key, void* item);
void hash_erase(hash_obj* self, char* key);
void hash_clear(hash_obj* self);
void hash_replace(hash_obj* self, char* key, void* item);

void hash_show(hash_obj* self, char* fname);

void* hash_item(hash_obj* self, char* key);
void* hash_item_addr(hash_obj* self, char* key);
char* hash_key(hash_obj* self, void* item);
int hash_count(hash_obj* self);
   
#endif
