#include "common.h"

cMenu* gActiveMenu;
hash_obj* gMenu;

void cMenu::Init()
{
    gMenu = hash_new(10);
}

void cMenu::Final()
{
TBEGIN();

    for(hash_it* i=gMenu->mEntryIt; i; i=i->mNextIt) {
        delete (cMenu*)i->mItem;
    }
    hash_delete(gMenu);

TEND();    
}

cMenu::cMenu(char* title)
{
TBEGIN();

    strcpy(mTitle, title);

    mCursor = 0;
    mScrollTop = 0;

    mMenuItems = vector_new(10);

TEND();    
}

cMenu::~cMenu()
{
    for(int i=0; i<vector_size(mMenuItems); i++) {
        delete (sMenuItem*)vector_item(mMenuItems, i);
    }
    vector_delete(mMenuItems);
}

void cMenu::Append(char* name, int key, char* cmd)
{
TBEGIN();

    char buf[256];
    sprintf(buf, " %-40s", name);
    vector_add(mMenuItems, new sMenuItem(buf, key, cmd));

TEND();    
}

void cMenu::Input(int meta, int key)
{
TBEGIN();

    if(key == 1 || key == KEY_HOME) {        // CTRL-A
        mCursor = 0;
    }
    else if(key == 5 || key == KEY_END) {    // CTRL-E
        mCursor = vector_size(mMenuItems)-1;
    }
    else if(key == 14 || key == 6|| key == KEY_DOWN) {    // CTRL-N CTRL-F
        mCursor++;
    }
    else if(key == 16 || key == 2 || key == KEY_UP) {    // CTRL-P CTRL-B
        mCursor--;
    }
    else if(key == 4 || key == KEY_NPAGE) { // CTRL-D PAGE DOWN
        mCursor+=8;
    }
    else if(key == 21 || key == KEY_PPAGE) { // CTRL-U   PAGE UP
        mCursor-=8;
    }
    else if(key == 3 || key == 7 || key == 27) {    // CTRL-C CTRL-G Escape
        gActiveMenu = NULL;
        mclear();
    }
    else if(key == 10 || key == 13) {    // CTRL-M CTRL-J
        gActiveMenu = NULL;
        
        sMenuItem* item = (sMenuItem*)vector_item(mMenuItems, mCursor);
        
        view(true);
        mrefresh();
        
        int error;
        rb_eval_string_protect(item->mCmd, &error);
        
        output_eval_error(error);

        mclear();
    }
    else if(key == 12) {// CTRL-L
        gLDir->Reread();
        gRDir->Reread();
        
        mclear();
        mclear_immediately();
        mrefresh();
    }
    else {
        gActiveMenu = NULL;
        
        for(int i=0; i<vector_size(mMenuItems); i++) {
            sMenuItem* item = (sMenuItem*)vector_item(mMenuItems, i);
            
            if(item->mKey == key) {
                view(true);
                mrefresh();
                
                int error;
                rb_eval_string_protect(item->mCmd, &error);
                
                output_eval_error(error);
            }
        }
        
        mclear();
    }

    if(mCursor < 0) {
        mCursor = vector_size(mMenuItems)-1;
    }

    if(mCursor >= vector_size(mMenuItems)) {
        mCursor = 0;
    }
    
    const int maxy = mgetmaxy() -2;
    
    if(mCursor >= (mScrollTop+maxy)) {
        mScrollTop += mCursor - (mScrollTop+maxy) + 1;
    }
    if(mCursor < mScrollTop) {
        mScrollTop = mCursor;
    }

TEND();    
}

void cMenu::View()
{
TBEGIN();

    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    int item_maxx = 0;
    for(int i=0; i<vector_size(mMenuItems); i++) {
        sMenuItem* item = (sMenuItem*)vector_item(mMenuItems, i);
        
        int len;
        if(gKanjiCode == kUtf) {
            len = str_termlen(item->mName);
        }
        else {
            len = strlen(item->mName);
        }

        if(item_maxx < len) {
            item_maxx = len;
        }
    }
    item_maxx+=2;
    
    if(item_maxx < 43) {
        item_maxx = 43;
    }
    else if(item_maxx > maxx-2) {
        item_maxx = maxx-2;
    }
    
    const int size = vector_size(mMenuItems) + 2;
    mbox(0, 2, item_maxx, size < maxy ? size : maxy);
    //mbox(0, 2, 43, size < maxy ? size : maxy);

    mattron(kCABold);
    mmvprintw(0, 4, mTitle);
    mattroff();

    for(int i=mScrollTop; (i<vector_size(mMenuItems) && i-mScrollTop<maxy-2); i++) {
        sMenuItem* item = (sMenuItem*)vector_item(mMenuItems, i);
        
        char buf[1024];
        if(strlen(item->mName) > maxx-4) {
            if(gKanjiCode == kUtf)
                str_cut2(item->mName, maxx-4, buf, 1024);
            else
                cut(item->mName, buf, maxx-4);
        }
        else {
            strcpy(buf, item->mName);
        }
        
        if(i == mCursor) {
            mattron(kCAReverse);
            mmvprintw(i-mScrollTop+1, 3, buf);
            mattroff();
        }
        else  {
            mmvprintw(i-mScrollTop+1, 3, buf);
        }
    }

    mmove_immediately(maxy-1, maxx-1);
    
TEND();    
}

void cMenu::Show()
{
TBEGIN();

    mCursor = 0;
    mScrollTop = 0;
    
View();



    
TEND();
}
