#include "common.h"

bool gViewHelp = false;

static int gScrollTop = 0;

const int kMaxMessage = 79;

void help_start()
{
    gViewHelp = true;
    gScrollTop = 0;
}

void help_view()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();
    
    mclear();

    mmove(0,0);

    char* buf[] = {
        "UP, CTRL-P                        move cursor up",
        "DOWN, CTRL-N                      move cursor down",
        "LEFT, CTRL-B                      move cursor left",
        "RIGHT, CTRL-F                     move cursor right",
        "CTRL-A                            move cursor top",
        "CTRL-E                            move cursor bottom",
        "PAGEUP, CTRL-U                    move cursor up",
        "PAGEDOWN, CTRL-D                  move cursor down",
        "BACKSPACE, CTRL-H                 move to parent direcotry",
        "\\                                 move to root directory",
        "~                                 move to home directory" ,
        ".                                 toggle visible dot file" ,
        "CTRL + I (tab)                    toggle 1directory and 2directory",
        "ENTER                             run cursor file(insert directory)",
        "q                                 quit the Minnu's Filer",
        "CTRL+L                            redraw the screen",
        "SPACE                             mark file under cursor" ,
        "HOME                              mark all files without directory",
        "END                               mark all files",
        "*                                 glob mark(file only)" ,
        "Meta+*                            glob mark(directory only)" ,
        "+                                 regex mark(file only)" ,
        "Meta+ +                           regex mark(directory only)" ,
        "c                                 copy mark file",
        "Meta+c                            background copy",
        "m                                 move mark file",
        "Meta+m                            background move",
        "d                                 delete mark file",
        "D                                 move mark file to $HOME/mtrashbox",
        "Meta+d                            background delete",
        "e                                 edit file(run $EDITOR)",
        "E                                 edit file(run $EDITOR) with xterminal",
        "l                                 make symbolic link",
        "L                                 make symbolic link2",
        "v                                 view file(run $PAGER)",
        "V                                 view file(run $PAGER) with xterminal",
        "r                                 rename",
        "a                                 open attribute menu",
        "n                                 make new file",
        "N                                 make new file menu",
        "k                                 make new direcotry",
        "p                                 compression",
        "P                                 compression2",
        "u                                 unpack",
        "U                                 unpack2",
        "b                                 backup",
        "i                                 info",
        "g                                 grep",
        "G                                 grep -R",
        "Meta+g                            mgrep",
        "f,/                               incremental search",
        "F,Meta-/                          incremental search(part match)",
        "Meta+f                            find",
        "s                                 open sort and view menu",
        "o                                 copy direcotry path",
        "O                                 copy direcotry path2",
        "w                                 exchange two directories",
        "j                                 change dircetory with menu",
        "J                                 change dircetory with cmdline",
        "Meta+j                            directory history menu",
        "$                                 sudo menu",
        "_                                 extra menu",
        "CTRL-C                            copy a file under cursor or mark files",
        "CTRL-X                            cut a file under cursor or mark files",
        "CTRL-V                            past files",
        "h                                 switch command line mode",
        "H                                 switch command line mode with x terminal",
        "x                                 excute",
        "X                                 excute with other xterminal",
        ":                                 run shell($SHELL)",
        "Meta+:                            run file manager",
        "Meta+x                            switch ruby command line mode",
        "z                                 next command will be runned with xterminal",
        "Z                                 toggle xterminal mode",
        "CTRL + T                          new tab",
        "CTRL + W                          remove current tab",
        "Meta+0-9                          change current tab",
        "1-9                               if mode is one directory, open tab in other directory",
        "Meta + Left                       move to previous directory"
    };

    for(int i=gScrollTop; i<gScrollTop+maxy; i++) {
        if(i < kMaxMessage) {
            mmvprintw(i-gScrollTop, 0, buf[i]);
        }   
    }

    mmove_immediately(maxy-1, maxx-1);
}

void help_input(int meta, int key)
{
    const int maxy = mgetmaxy();

    // 'q' CTRL-C CTRL-G Escape
    if(key == 'q' || key == 3 || key == 7||key == 27) { 
        gViewHelp = false;
    }
    // space f CTRL-D PAGE DOWN
    else if(key == ' '|| key == 'f' || key == 4||key == KEY_NPAGE) {
        if(kMaxMessage >= maxy) {
            gScrollTop += 10;
            if(gScrollTop+maxy > kMaxMessage) {
                gScrollTop -= gScrollTop+maxy-kMaxMessage;
            }
        }
    }
    // b CTRL-U PAGE UP
    else if(key == 'b' || key ==21 || key == KEY_PPAGE) {
        gScrollTop -= 10;

        if(gScrollTop < 0) {
            gScrollTop = 0;
        }
    }
    // CTRL-N DOWN CTRL-M CTRL-J
    else if(key == 14 || key == 10 || key == 13 || key == KEY_DOWN) {
        if(kMaxMessage >= maxy) {
            gScrollTop ++;
            if(gScrollTop+maxy > kMaxMessage) {
                gScrollTop -= gScrollTop+maxy-kMaxMessage;
            }
        }
    }
    else if(key == 16 || key == KEY_UP) {    /// CTRL-P UP
        gScrollTop--;

        if(gScrollTop < 0) {
            gScrollTop = 0;
        }
    }
}
