#include "common.h"

bool gViewHelp = false;

static int gScrollTop = 0;

const int kMaxMessage = 74;

void help_start()
{
    gViewHelp = true;
    gScrollTop = 0;
}

void help_view()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();
    
    mclear();

    mmove(0,0);

    char* buf[kMaxMessage] = {
        "UP, CTRL-P                        move cursor up",
        "DOWN, CTRL-N                      move cursor down",
        "LEFT, CTRL-B                      move cursor left",
        "RIGHT, CTRL-F                     move cursor right",
        "CTRL-A                            move cursor top",
        "CTRL-E                            move cursor bottom",
        "PAGEUP, CTRL-U                    move cursor 5 up",
        "PAGEDOWN, CTRL-D                  move cursor 5 down",
        "BACKSPACE, CTRL-H                 move to parent direcotry",
        "Meta + Left                       move to previous directory",
        "\\                                 move to root directory",
        "~                                 move to home directory" ,
        "ENTER                             run cursor file(insert directory)",
        "q                                 quit the Minnu's Filer",
        "CTRL+L                            redraw the screen",
        "SPACE                             mark file under cursor" ,
        "c                                 copy mark file",
        "C                                 copy mark file2",
        "Meta+c                            cp program",
        "Meta+C                            cp program2",
        "m                                 move mark file",
        "Meta+m                            mv program",
        "d                                 delete mark file",
        "D                                 move mark file to $HOME/mtrashbox",
        "Meta+d                            rm program",
        "e                                 edit file(run $EDITOR)",
        "E                                 edit new file",
        "l                                 make symbolic link",
        "L                                 make symbolic link2",
        "v                                 view file(run $PAGER)",
        "r                                 rename",
        "a                                 open attribute menu",
        "n                                 make new file",
        "N                                 make new file menu",
        "k                                 make new direcotry",
        "p                                 compression",
        "P                                 compression2",
        "u                                 unpack",
        "U                                 unpack2",
        "b                                 backup",
        "i                                 info",
        "g                                 grep1",
        "G                                 grep2",
        "Meta+g                            grep3",
        "f,/                               incremental search",
        "F                                 find",
        "s                                 open sort and view menu",
        "o                                 copy direcotry path",
        "O                                 copy direcotry path2",
        "w                                 exchange two directories",
        "j                                 change directory with cmdline",
        "J                                 change dircetory with cmdline2",
        "Meta+j                            change dircetory with menu",
        "@                                 sudo menu",
        "_                                 extra menu",
        "CTRL-C                            copy a file under cursor or mark files",
        "CTRL-X                            cut a file under cursor or mark files",
        "CTRL-V                            past files",
        "h                                 switch command line mode",
        "H                                 switch command line mode with x terminal",
        "x                                 excute",
        ":                                 run shell($SHELL)",
        "z                                 next command will be runned with xterminal",
        "Z                                 toggle xterminal mode",
        "*                                 glob mark" ,
        "HOME                              mark all files without directory",
        "END                               mark all files",
        "CTRL + T, CTRL + N                clone new tab",
        "CTRL + W                          remove current tab",
        "CTRL + I (tab)                    change current tab",
        "Meta+0-9                          change current tab",
        "0-9                               return pty"
    };

    for(int i=gScrollTop; i<gScrollTop+maxy; i++) {
        if(i < kMaxMessage) {
            mmvprintw(i-gScrollTop, 0, buf[i]);
        }   
    }

    mmove_immediately(maxy-1, maxx-1);
    mrefresh();
}

void help_input(int meta, int key)
{
    const int maxy = mgetmaxy();

    // 'q' CTRL-C CTRL-G Escape
    if(key == 'q' || key == 3 || key == 7||key == 27) { 
        gViewHelp = false;
    }
    // space f CTRL-D PAGE DOWN
    else if(key == ' '|| key == 'f' || key == 4||key == KEY_NPAGE) {
        if(kMaxMessage >= maxy) {
            gScrollTop += 10;
            if(gScrollTop+maxy > kMaxMessage) {
                gScrollTop -= gScrollTop+maxy-kMaxMessage;
            }
        }
    }
    // b CTRL-U PAGE UP
    else if(key == 'b' || key ==21 || key == KEY_PPAGE) {
        gScrollTop -= 10;

        if(gScrollTop < 0) {
            gScrollTop = 0;
        }
    }
    // CTRL-N DOWN CTRL-M CTRL-J
    else if(key == 14 || key == 10 || key == 13 || key == KEY_DOWN) {
        if(kMaxMessage >= maxy) {
            gScrollTop ++;
            if(gScrollTop+maxy > kMaxMessage) {
                gScrollTop -= gScrollTop+maxy-kMaxMessage;
            }
        }
    }
    else if(key == 16 || key == KEY_UP) {    /// CTRL-P UP
        gScrollTop--;

        if(gScrollTop < 0) {
            gScrollTop = 0;
        }
    }
}
