#ifndef MINATO__MLIST_H
#define MINATO__MLIST_H

#define BOOL int
#define TRUE 1
#define FALSE 0

typedef struct _list_it {
   void* mItem;
   
   struct _list_it* mPrevIt;
   struct _list_it* mNextIt;
} list_it;

typedef struct {
   list_it* mEntryIt;
   list_it* mLastIt;
   int mCount;
} list_obj;


list_obj* list_new();
void list_delete(list_obj* self);

int list_size(list_obj* self);
BOOL list_empty(list_obj* self);
int list_index_of(list_obj* self, void* item);
void list_push_front(list_obj* self, void* item);
void list_push_back(list_obj* self, void* item);
void* list_pop_back(list_obj* self);
void* list_pop_front(list_obj* self);
void list_clear(list_obj* self);

list_it* list_begin(list_obj* self);
list_it* list_last(list_obj* self);
list_it* list_at(list_obj* self, int index);
list_it* list_find(list_obj* self, void* item);
void* list_item(list_it* self);
list_it* list_next(list_it* self);
list_it* list_prev(list_it* self);
void list_replace(list_it* self, void* item);
void list_erase(list_it* self, list_obj* owner);
void list_insert_front(list_it* self, void* item, list_obj* owner);
void list_insert_back(list_it* self, void* item, list_obj* owner);
       
#endif
