/*
 * $Id: mbcnvt.c 1.2 2005/08/31 16:07:30 Joe Exp Joe $
 */

#include <iconv.h>
#include <string.h>
#include "mbcnvt.h"


inline char*
run_iconv(char dst[], const char src[], const char* tocode, const char* fromcode)
{
	iconv_t hIc;
	char    chSrc[MAX_MBSTRBUF + 1];
	char    chDst[MAX_MBSTRBUF + 1];
	char    *pSrc = chSrc;
	char    *pDst = chDst;
	size_t  szStrbuf = (size_t)MAX_MBSTRBUF;
 
	chSrc[MAX_MBSTRBUF] = '\0';
	chDst[MAX_MBSTRBUF] = '\0';
	strcpy(chSrc, src);

	/* code conversion */
	hIc = iconv_open(tocode, fromcode);
	iconv(hIc, (const char **)&pSrc, &szStrbuf, &pDst, &szStrbuf);
	iconv_close(hIc);

	strcpy(dst, chDst);

	return dst;
}
