#include "common.h"

cMenu* gActiveMenu;
hash_obj* gMenu;

void cMenu::Init()
{
    gMenu = hash_new(10);
}

void cMenu::Final()
{
TBEGIN();

    for(hash_it* i=gMenu->mEntryIt; i; i=i->mNextIt) {
        delete (cMenu*)i->mItem;
    }
    hash_delete(gMenu);

TEND();    
}

cMenu::cMenu(char* title)
{
TBEGIN();

    strcpy(mTitle, title);

    mCursor = 0;

    mMenuItems = vector_new(10);

TEND();    
}

cMenu::~cMenu()
{
    for(int i=0; i<vector_size(mMenuItems); i++) {
        delete (sMenuItem*)vector_item(mMenuItems, i);
    }
    vector_delete(mMenuItems);
}

void cMenu::Append(char* name, int key, char* cmd)
{
TBEGIN();

    char buf[256];
    sprintf(buf, " %-40s", name);
    vector_add(mMenuItems, new sMenuItem(buf, key, cmd));

TEND();    
}

void cMenu::Input(int meta, int key)
{
TBEGIN();

    if(key == 1 || key == KEY_HOME) {        // CTRL-A
        mCursor = 0;
    }
    else if(key == 5 || key == KEY_END) {    // CTRL-E
        mCursor = vector_size(mMenuItems)-1;
    }
    else if(key == 14 || key == KEY_DOWN) {    // CTRL-N
        mCursor++;

        if(mCursor >= vector_size(mMenuItems)) {
            mCursor = 0;
        }
    }
    else if(key == 16 || key == KEY_UP) {    // CTRL-P
        mCursor--;

        if(mCursor < 0) {
            mCursor = vector_size(mMenuItems)-1;
        }
    }
    else if(key == 3 || key == 7 || key == 27) {    // CTRL-C CTRL-G Escape
        gActiveMenu = NULL;
        delwin(mScr);
        mScr = NULL;
    }
    else if(key == 10 || key == 13) {    // CTRL-M CTRL-J
        sMenuItem* item = (sMenuItem*)vector_item(mMenuItems, mCursor);
        rb_eval_string(item->mCmd);

        gActiveMenu = NULL;
        delwin(mScr);
        mScr = NULL;
    }
    else if(key == 12) {// CTRL-L
        clear();
        gLDir->Reread();
        gRDir->Reread();
    }
    else {
        for(int i=0; i<vector_size(mMenuItems); i++) {
            sMenuItem* item = (sMenuItem*)vector_item(mMenuItems, i);
            
            if(item->mKey == key) {
                rb_eval_string(item->mCmd);
            }
        }
        
        gActiveMenu = NULL;
        delwin(mScr);
        mScr = NULL;
    }

TEND();    
}

void cMenu::View()
{
TBEGIN();

    wmyclear(mScr);

    wmybox(mScr, 0,0, getmaxx(mScr), getmaxy(mScr));
    //box(mScr, '|', '-');

    wattron(mScr, A_BOLD);
    mvwprintw(mScr, 0, 2, mTitle);
    wattroff(mScr, A_BOLD);

    for(int i=0; i<vector_size(mMenuItems); i++) {
        sMenuItem* item = (sMenuItem*)vector_item(mMenuItems, i);
        
        if(i == mCursor) {
            wattron(mScr, A_REVERSE);
            mvwprintw(mScr, i+1, 2, item->mName);
            wattroff(mScr, A_REVERSE);
        }
        else  {
            mvwprintw(mScr, i+1, 2, item->mName);
        }
    }

    wrefresh(mScr);

TEND();    
}

void cMenu::Show()
{
TBEGIN();

    mScr = newwin(vector_size(mMenuItems) + 2, 45, 0, 2);
    mCursor = 0;

TEND();
}
