/*
 * messasy
 *
 * Copyright (C) 2006,2007,2008 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 * $RCSfile: messasy.h,v $
 * $Revision: 1.5 $
 * $Date: 2008/12/18 04:56:32 $
 */

#define IDENT   "messasy"
#define SOCKET_FILE     "/var/run/messasy.sock"
#define DEFAULT_TIMEOUT 10
#define OCONN_LENGTH 30
#define OCONN "inet:%d@%s"
# define false  0
# define true   1

#define HEADER_FROM	"X-Messasy-From"
#define HEADER_TO	"X-Messasy-To"

/* milter */
sfsistat mlfi_envfrom(SMFICTX *, char **);
sfsistat mlfi_envrcpt(SMFICTX *, char **);
sfsistat mlfi_header(SMFICTX *, char *, char *);
sfsistat mlfi_eoh(SMFICTX *);
sfsistat mlfi_body(SMFICTX *, u_char *, size_t);
sfsistat mlfi_eom(SMFICTX *);
sfsistat mlfi_close(SMFICTX *);
sfsistat mlfi_abort(SMFICTX *);

/* extern*/
extern sfsistat  mlfi_cleanup(SMFICTX *, bool);

/* milter struct */
struct smfiDesc smfilter =
{
    IDENT,
    SMFI_VERSION,   /* version code -- do not change */
    SMFIF_ADDHDRS,  /* flags */
    NULL,           /* connection info filter */
    NULL,           /* SMTP HELO command filter */
    mlfi_envfrom,   /* envelope sender filter */
    mlfi_envrcpt,   /* envelope recipient filter */
    mlfi_header,    /* header filter */
    mlfi_eoh,       /* end of header */
    mlfi_body,      /* body block filter */
    mlfi_eom,       /* end of message */
    mlfi_abort,     /* message aborted */
    mlfi_close      /* connection cleanup */
};

static void * call_command(void *);

/* mail save struct */
struct mlfiPriv
{
    struct maildrop *mlfi_maildrop;
    struct config   *mlfi_conf;
    struct rcptaddr *mlfi_savercpt;
    char            *mlfi_savefrom;
    int              mlfi_mailsave;
};

pthread_t              child;
