/*
 * messasy
 *
 * Copyright (C) 2006,2007,2008 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 * $RCSfile: maildrop.h,v $
 * $Revision: 1.15 $
 * $Date: 2009/01/27 06:22:35 $
 */

struct maildrop {
    int	   md_fd;
    char  *md_maildir;
    int    md_maildir_len;
    char  *md_mailfolder;
    int    md_mailfolder_len;
    char  *md_hostname;
    int    md_hostname_len;
    char  *md_from;
    int    md_from_len;
    char  *md_replaceaddr;
    int    md_replaceaddr_len;
    time_t md_curtime;
    char  *md_tempfile;
    int    md_cr;
    char  md_dotdelimiter;
    char  md_slashdelimiter;
    struct filter *md_mydomain;
};

struct rcptaddr {
    char *rcpt_addr;
    int   rcpt_addr_len;
};

#define SAVEFILE_NAME "/new/%010ld.%010ld.%s"
#define SAVEFILE_LEN 29	/* (BABEDIR)/(FOLDER)/new/0000000000.0000000000.(HOSTNAME) */
#define TMPFILE_NAME "%s/tmp/%010ld.%s.XXXXXX"
#define TMPFILE_LEN 24	/* (BABEDIR)/(FOLDER)/tmp/0000000000.(HOSTNAME).XXXXX */
#define OTHER "OTHER"
#define UNKNOWN "UNKNOWN"
#define DOT '.'
#define SLASH '/'

struct maildrop *maildrop_open(struct config *, char *);
int maildrop_write_header(struct maildrop *, char *, char *);
int maildrop_write_body(struct maildrop *, u_char *, int);
int maildrop_close(struct maildrop *);
int maildrop_abort(struct maildrop *);
void replace_delimiter(char *, char, char);
int count_replaceaddr(char *);
int push_rcptlist(struct rcptaddr **, char *);
void free_rcptlist(struct rcptaddr *);
int check_ascii(char *, char *);
