/*
 * messasy
 *
 * Copyright (C) 2006,2007,2008 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 * $RCSfile: filter.c,v $
 * $Revision: 1.6 $
 * $Date: 2009/01/23 07:01:44 $
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "msy_config.h"
#include "filter.h"

/*
 * filter_getaddress()
 *
 * Get mailaddress from MAIL FROM or RCPT TO string
 *
 * Args:
 *  char *string	"mail from" or "rcpt to" argment string
 *  char *addr		set mail address
 *  int len		addr argment reserve space size
 *
 * Return value:
 *  0			Success
 *  1			Failed
 */
int
filter_getaddress(char *string, char *addr, int len)
{
    char *cur = string;
    char *addr_cur = addr;
    int  mode = FL_START;
    int  escape = FL_ESCAPE_OUT;

    while (*cur != '\0' && mode != FL_END) {

        if ((int)(addr_cur - addr) > (len - 1)) {
            *addr_cur = '\0';
            return 1;
        }

        if (escape == FL_ESCAPE_IN) {
            escape = FL_ESCAPE_OUT;
            *addr_cur++ = *cur++;
            continue;
        }

        switch (*cur) {
        case '<':
            mode = FL_BRACKET;
            cur++;
            addr_cur = addr;
            break;

        case '>':
            if (mode != FL_BRACKET) {
                return 1;
            }
            *addr_cur = '\0';
            mode = FL_END;
            break;

        case '\\':
            if (escape == FL_ESCAPE_OUT) {
                escape = FL_ESCAPE_IN;
            }
            cur++;
            break;

        default:
            if (mode == FL_START) {
                if (isspace(*cur)) {
                    cur++;
                    continue;
                } else {
                    addr_cur = addr;
                    mode = FL_NORMAL;
                }
            } else if (mode == FL_NORMAL) {
                if (isspace(*cur)) {
                    *addr_cur = '\0';
                    mode = FL_SKIP;
                }
            } else if (mode == FL_SKIP) {
                cur++;
                continue;
            }
            *addr_cur++ = *cur++;
	}
    }

    if (mode == FL_NORMAL) {
        *addr_cur = '\0';
    }

    return 0;
}

/*
 * filter_address_search()
 *
 * Look for a filter according in the mail address
 *
 * Args:
 *  char *address		Mail address
 *  struct filter *fil_list	filter list
 *
 * Return value:
 *  More than 0		Success (filter number)
 *  -1			No match.
 *  -2			Error.
 */
int
filter_address_search(char *address, struct filter *fil_list)
{
    struct filter *cur_filter;
    int count;
    int addr_len = strlen(address);
    int len;
    char *ptr;

    for (count = 0, cur_filter = fil_list;
         cur_filter != NULL && cur_filter->fl_string != NULL;
         count++, cur_filter++) {

        if (strchr(cur_filter->fl_string, '@') != NULL) {

            if (cur_filter->fl_string[0] == '@') {

                if ((ptr = strchr(address, '@')) == NULL) {
                    return -2;
                }

                if (!strcasecmp(cur_filter->fl_string, ptr)) {
                    return count;
                }

            } else {

                if (!strcasecmp(cur_filter->fl_string, address)) {
                    return count;
                }

            }
        } else {

            len = strlen(cur_filter->fl_string);
            if (addr_len < len) {
                continue;
            }

            if (!strcasecmp(cur_filter->fl_string, address + addr_len - len)) {
                return count;
            }

        }
    }

    return -1;
}

/*
 * filter_domain_search()
 *
 * Look for a filter according in the domain of mail address
 *
 * Args:
 *  char *address		Mail address
 *  struct filter *fil_list	filter list
 *
 * Return value:
 *  More than 0		Success (filter number)
 *  -1			No match.
 *  -2			Error.
 */
int
filter_domain_search(char *address, struct filter *fil_list)
{
    struct filter *cur_filter;
    char *ptr;
    int count;

    if ((ptr = strchr(address, '@')) == NULL) {
	return -2;
    }

    for (count = 0, cur_filter = fil_list;
	 cur_filter != NULL && cur_filter->fl_string != NULL;
	 count++, cur_filter++) {
	if (strcasecmp(cur_filter->fl_string, ptr + 1) == 0) {
	    return count;
	}
    }

    return -1;
}

#ifdef __TEST__

#define FILTER_LEN 512

struct filter fil[] = {{ "xxxxx@designet.co.jp" },
                       { "@designet.co.jp" },
                       { "designet.co.jp" },
                       { NULL }};


int
main(int argc, char **argv)
{
    char buf[FILTER_LEN];
    int rc;

    if (!strcmp(argv[1], "-a")) {
        rc = filter_getaddress(argv[2], buf, FILTER_LEN);

        if (rc == 0) {
            printf("%s %s\n", argv[2], buf);
        }
    } else {
        rc = filter_address_search(argv[1], fil);

        printf("rc = %d\n", rc);
    }

}
#endif /* __TEST__ */
