/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.FileNames;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcludePackageProperties
implements FileNames {
    private static final Logger log = Logger.getLogger(ExcludePackageProperties.class);
    private static final ExcludePackageProperties singleton = new ExcludePackageProperties();
    private final Map<String, Set<String>> map = new HashMap<String, Set<String>>();

    public static ExcludePackageProperties getInstance() {
        return singleton;
    }

    private ExcludePackageProperties() {
        File file = Files.getFile("translation-exclude-package.properties");
        if (!file.exists()) {
            String msg = String.valueOf(file.getName()) + " \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002";
            log.fatal(msg, new Object[0]);
            FileNotFoundException e = new FileNotFoundException(file.getPath());
            throw new IllegalStateException(msg, e);
        }
        PropertySet prop = new PropertySet(file);
        for (Property p : prop) {
            this.map.put(p.key, new HashSet<String>(Arrays.asList(p.value.split("\\s*,\\s*"))));
        }
    }

    public Set<String> getPathEntries(String enValue) {
        Set<String> pathEntries = this.map.get(enValue);
        if (pathEntries != null && pathEntries.contains("")) {
            log.info(new IllegalStateException(), "[" + enValue + "] \u306e\u7ffb\u8a33\u547c\u3073\u51fa\u3057\u30b9\u30bf\u30c3\u30af\u30c8\u30ec\u30fc\u30b9\u3002", new Object[0]);
            return null;
        }
        return pathEntries;
    }
}

