/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.aspect.Analyses;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.CacheFileNames;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransformer
implements ClassFileTransformer,
CacheFileNames {
    private static final Logger log = Logger.getLogger(AbstractTransformer.class);
    private static final ClassPool classPool = new ClassPool(true);
    private static final Set<String> appendedLocationPathSet = new HashSet<String>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] transform(ClassLoader loader, String internalName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytecode) throws IllegalClassFormatException {
        String msg;
        block15: {
            long start = System.nanoTime();
            try {
                URL location;
                if (internalName.startsWith("java/")) return null;
                if (internalName.startsWith("javax/")) return null;
                if (internalName.startsWith("sun/")) return null;
                if (internalName.startsWith("com/sun/")) return null;
                if (internalName.startsWith("org/apache/commons")) {
                    return null;
                }
                if (internalName.startsWith("jp/sourceforge/mergedoc/pleiades/aspect/resource/")) {
                    if (internalName.endsWith("/AbstractClassCache")) return null;
                    if (internalName.endsWith("/TransformedClassCache")) return null;
                    if (internalName.endsWith("/ExcludesClassNameCache")) {
                        return null;
                    }
                }
                if (protectionDomain == null || (location = protectionDomain.getCodeSource().getLocation()) == null) break block15;
                String locationPath = location.getPath();
                if (locationPath.contains("org.apache.jasper_")) {
                    return null;
                }
                if (appendedLocationPathSet.contains(locationPath)) break block15;
                if (locationPath.contains("org.eclipse.") && (locationPath.contains("org.eclipse.core.resources_") || locationPath.contains("org.eclipse.core.runtime_") || locationPath.contains("org.eclipse.debug.core_") || locationPath.contains("org.eclipse.dltk.core_") || locationPath.contains("org.eclipse.equinox.common_") || locationPath.contains("org.eclipse.jdt.core_") || locationPath.contains("org.eclipse.jdt.ui_") || locationPath.contains("org.eclipse.jface_") || locationPath.contains("org.eclipse.osgi_") || locationPath.contains("org.eclipse.swt.") || locationPath.contains("org.eclipse.ui.workbench_"))) {
                    this.addClassPath(locationPath);
                }
                if (locationPath.contains("mergedoc.jstyle.swt")) {
                    this.addClassPath(locationPath);
                }
            }
            catch (Throwable e) {
                msg = "\u30d0\u30a4\u30c8\u30b3\u30fc\u30c9\u5909\u63db\u4e8b\u524d\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + internalName;
                log.error(e, msg, new Object[0]);
                throw new IllegalClassFormatException(String.valueOf(msg) + " \u539f\u56e0:" + e);
            }
            finally {
                Analyses.end(AbstractTransformer.class, "transform", start);
            }
        }
        try {
            String className = internalName.replace('/', '.');
            return this.transform(loader, className, protectionDomain, bytecode);
        }
        catch (Throwable e) {
            msg = "\u30d0\u30a4\u30c8\u30b3\u30fc\u30c9\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + internalName;
            log.debug(e, msg, new Object[0]);
            return null;
        }
    }

    private void addClassPath(String locationPath) throws NotFoundException {
        appendedLocationPathSet.add(locationPath);
        String classPath = Files.decodePath(locationPath);
        classPool.appendClassPath(classPath);
    }

    protected abstract byte[] transform(ClassLoader var1, String var2, ProtectionDomain var3, byte[] var4) throws CannotCompileException, NotFoundException, IOException;

    protected CtClass createCtClass(byte[] bytecode, ProtectionDomain protectionDomain) throws IOException, NotFoundException {
        long start = System.nanoTime();
        CtClass ctClass = classPool.makeClass((InputStream)new ByteArrayInputStream(bytecode));
        ctClass.detach();
        Analyses.end(AbstractTransformer.class, "createCtClass", start);
        return ctClass;
    }

    protected void logDescriptor(CtClass ctClass) {
        CtBehavior[] ctBehaviorArray = ctClass.getDeclaredBehaviors();
        int n = ctBehaviorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtBehavior behavior = ctBehaviorArray[n2];
            log.info("DESCRIPTOR: " + ctClass.getName() + "#" + behavior.getName() + " " + behavior.getMethodInfo().getDescriptor(), new Object[0]);
            ++n2;
        }
    }
}

