/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t mempool();
const commandtable_t command_mempool =
	{"mempool", mempool, "address", "print mempool table"};
extern void prhead_mempool();
extern addr_t print_mempool();

PRIVATE addr_t
mempool()
{
	int c;
	int full = 0;
	addr_t addr = 0;
	static const char *name[] = {
		"bio_pool", "bio_split_pool",
#ifdef CONFIG_MMU
		"page_pool", "isa_page_pool",
#endif
#ifdef CONFIG_NFS
		"nfs_rdata_mempool", "nfs_wdata_mempool", "nfs_commit_mempool",
#endif
	};

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	prhead_mempool();
	if (argcnt == optind) {
		int i;
		for (i = 0; i < LENGTHOF(name); i++) {
			addr = searchaddr_bysym(name[i]);
			if (addr) {
				memread(addr, sizeof(addr), &addr, name[i]);
				if (addr) {
					addr = print_mempool(addr, full, name[i]);
				}
			}
		}
	}

	while (args[optind]) {
		addr = print_mempool(getvalue(args[optind]), full, NULL);
		optind++;
	}
	return addr;
}
