/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/types.h>
#include <linux/wait.h>
#include <linux/in.h>
#include <linux/nfs3.h>
#include <linux/nfs4.h>
#include <linux/nfs_fs.h>
#include <linux/nfs_fs_sb.h>
#include <linux/nfs_flushd.h>
#include <linux/nfs_page.h>

#include "flags_nfs_fs.h"
#include "flags_nfs_fs_sb.h"

void
mprint_nfs_fh(buf)
	const void *buf;
{
	const struct nfs_fh *fhp = buf;
	int i;

	mprintf("%2x:", fhp->size);
	for (i = 0; i < NFS_MAXFHSIZE && i < fhp->size; i++) {
		if (i == 32)
			mprintf("\n  : ");
		else if (i % 4 == 0)
			mprintf(" ");
		mprintf("%02x", fhp->data[i]);
	}
	mprintf("\n");
}

void
_prhead_nfs_page(str)
	const char *str;
{
	mprintf(SPTR" "SPTR" "SPTR" "SPTR" "SPTR"    INDEX OFFSET BYTES COUNT\n",
		str, "FILE", "INODE", "CRED", "PAGE");
}

void
prhead_nfs_page()
{
	_prhead_nfs_page("ADDR");
}

addr_t
print_nfs_page(addr, full)
	addr_t addr;
	int full;
{
	struct nfs_page page;

	memread(addr, sizeof(page), &page, "nfs_page");
	mprintf(FPTR " ", addr);
	mprintf(FPTR " " FPTR " " FPTR " " FPTR " ",
		page.wb_file, page.wb_inode, page.wb_cred, page.wb_page);
	mprintf("%8lx %6x %5x %5x",
		page.wb_index, page.wb_offset, page.wb_bytes, page.wb_count);
	mprintf("\n");
	return (addr_t)page.wb_list.next;
}

void
prhead_nfs_inode()
{
	mprintf(SPTR"     FILEID DT CM PG FLAGS\n", "ADDR");
}

addr_t
print_nfs_inode(addr, full, iflag)
	addr_t addr;
	int full;
	int iflag;
{
	struct nfs_inode ni;

	if (iflag) {
		addr -= OFFSET(struct nfs_inode, vfs_inode);
	}
	memread(addr, sizeof(ni), &ni, "nfs_inode_info");
	mprintf(FPTR " ", addr);
	mprintf("%10llx ", ni.fileid);
	mprintf("%2x %2x %2x",
		ni.ndirty, ni.ncommit, ni.npages);
	mprintbit(nflags, ni.flags);
	mprintf("\n");

	if (full) {
		mprint_nfs_fh(&ni.fh);
		mprintf("read_cache_jiffies   %lx\n", ni.read_cache_jiffies);
		mprintf("read_cache_ctime     %lx\n", ni.read_cache_ctime.tv_sec);
		mprintf("read_cache_mtime     %lx\n", ni.read_cache_mtime.tv_sec);
		mprintf("read_cache_isize     %llx\n", ni.read_cache_isize);
		mprintf("attrtimeo            %lx\n", ni.attrtimeo);
		mprintf("attrtimeo_timestamp  %lx\n", ni.attrtimeo_timestamp);
		mprintf("cache_mtime_jiffies  %lx\n", ni.cache_mtime_jiffies);
		mprintf("cache_access.jiffies %lx\n", ni.cache_access.jiffies);
		mprintf("cache_access.cred    "FPTR"\n", ni.cache_access.cred);
		mprintf("cache_access.mask    %x\n", ni.cache_access.mask);
		mprintf("cache_access.err     %x\n", ni.cache_access.err);
		mprintf("cookieverf           %x  %x\n",
					ni.cookieverf[0], ni.cookieverf[1]);
		mprintf("mm_cred              " FPTR "\n", ni.mm_cred);
	}

	return (addr_t)ni.dirty.next - OFFSET(struct nfs_inode, dirty);
}

void
prhead_nfs_server()
{
	mprintf(SPTR " " SPTR " " SPTR " RSIZE WSIZE DTSIZ BSIZE FLG NAME\n",
		"ADDR", "CLIENT", "RPC_OPS");
}

addr_t
print_nfs_server(dummy, addr, full)
	addr_t dummy;
	addr_t addr;
	int full;
{
	struct nfs_server server;
	char buf[64];

	memread(addr, sizeof(server), &server, "nfs_server");
	mprintf(FPTR " ", addr);
	mprintf(FPTR " " FPTR " ", server.client, server.rpc_ops);
	mprintf("%5x %5x %5x %5x ",
		server.rsize, server.wsize,
		server.dtsize, server.bsize);

	mprintf("%3x ", server.flags);
	memread((addr_t)server.hostname, sizeof(buf), buf, "nfs_server.hostname");
	mprintstr(buf, sizeof(buf));
	mprintf("\n");

	if (full) {
		mprint_nfs_fh(&server.fh);
		mprintf("    REG %d-%d   DIR %d-%d\n",
			server.acregmin, server.acregmax,
			server.acdirmin, server.acdirmax);
	}

	return 0;
}
