/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <asm/uaccess.h>

#include "flags_uaccess.h"

void
prhead_exception_table()
{
	mprintf(SPTR" "SPTR"                            "SPTR"\n",
		"ADDR", "INSN", "FIXUP");
}

addr_t
print_exception_table(addr, full)
	addr_t addr;
	int full;
{
	struct exception_table_entry ex;
	const char *p;

	memread(addr, sizeof(ex), &ex, "exception_table");
	mprintf(FPTR " ", addr);

#ifdef _exception_table_entry_has_insn
	p = getsymstr(ex.insn);
	mprintf(FPTR " %-26s ", ex.insn,  p? p: "-");
#endif
#ifdef _exception_table_entry_has_fixup
	p = getsymstr(ex.fixup);
	mprintf(FPTR " %s\n", ex.fixup, p? p: "-");
#endif

	return addr + sizeof(ex);
}
