/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include <sys/stat.h>
#include <unistd.h>
#include "crash.h"

PRIVATE addr_t exception_table();
const commandtable_t command_exception_table =
	{"exception_table", exception_table, "[start [end]]", "print exception_table_entry"};
extern addr_t print_exception_table();
extern void prhead_exception_table();

addr_t __start___ex_table_addr;
addr_t __stop___ex_table_addr;

PRIVATE addr_t
exception_table()
{
	addr_t addr = 0;
	addr_t eaddr;
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind == argcnt) {
		GETADDR(__start___ex_table);
		GETADDR(__stop___ex_table);
		addr = __start___ex_table_addr;
		eaddr = __stop___ex_table_addr;
	} else if (optind + 1 == argcnt) {
		addr = print_exception_table(getvalue(args[optind]));
		eaddr = addr + 1;
	} else if (optind + 2 == argcnt) {
		addr = getvalue(args[optind]);
		eaddr = getvalue(args[optind + 1]);
	}

	prhead_exception_table();
	while (addr < eaddr) {
		addr = print_exception_table(addr);
	}
	return addr;
}
