/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/mm.h>

#include "flags_page-flags.h"
#include "flags_mm.h"
#include "flags_gfp.h"

void
prhead_page()
{
#if defined(_page_has_mapcount) || defined(_page_has__mapcount)
	mprintf(SPTR" CNT "SPTR"   INDEX MAPC  PRIVATE FLAGS\n",
		"ADDR", "MAPPING");
#else
	mprintf(SPTR" CNT "SPTR"   INDEX "SPTR"  PRIVATE FLAGS\n",
		"ADDR", "MAPPING", "PTE");
#endif
}

int sizeof_page = sizeof(struct page);

addr_t
print_page(addr, lru)
	addr_t addr;
	int lru;
{
	struct page pg;

	if (lru) {
		addr -= OFFSET(struct page, lru);
	}
	mprintf(FPTR " ", addr);
	memread(addr, sizeof(pg), &pg, "page");

#ifdef _page_has__count
	mprintf("%3x ", ATOMIC_READ(pg._count));
#else
	mprintf("%3x ", ATOMIC_READ(pg.count));
#endif /*_page_has__count*/
	mprintf(FPTR " %7lx", pg.mapping, pg.index);

#ifdef _page_has__mapcount
	mprintf(" %4x", ATOMIC_READ(pg._mapcount));
#else
#ifdef _page_has_mapcount
	mprintf(" %4x", pg.mapcount);
#else
	mprintf(" " FPTR, pg.pte.direct);
#endif
#endif

	mprintf(" %8lx", pg.private);
#if defined(WANT_PAGE_VIRTUAL)
	mprintf(" " FPTR, pg.virtual);
#endif
	mprintbit(pgflags, pg.flags);
	mprintf("\n");
	if (lru) {
		return (addr_t)pg.lru.next;
	}
#ifdef _page_hash_list
	return (addr_t)pg.list.next - OFFSET(struct page, list);
#else
	return 0;	/*XXX*/
#endif
}

void
prhead_vm_area_struct()
{
	mprintf(SPTR " " SPTR " " SPTR " " SPTR "  FLAGS\n",
		"ADDR", "START", "END", "FILE");
}

addr_t
print_vm_area_struct(addr, full)
	addr_t addr;
{
	struct vm_area_struct vma;
	static const struct bitname vmflags[] = {
		{ VM_READ,	"R" },
		{ VM_WRITE,	"W" },
		{ VM_EXEC,	"X" },
		{ VM_SHARED,	"S" },

		{ VM_MAYREAD,	"mayR" },
		{ VM_MAYWRITE,	"mayW" },
		{ VM_MAYEXEC,	"mayX" },
		{ VM_MAYSHARE,	"mayS" },

		{ VM_GROWSDOWN,	"growsdown" },
		{ VM_GROWSUP,	"growsup" },
		{ VM_SHM,	"shm" },
		{ VM_DENYWRITE,	"denywrite" },

		{ VM_EXECUTABLE,"executable" },
		{ VM_LOCKED,	"locked" },
		{ VM_IO,	"io" },

		{ VM_SEQ_READ,	"seq_read" },
		{ VM_RAND_READ,	"rand_read" },

		{ VM_DONTCOPY,	"dontcopy" },
		{ VM_DONTEXPAND,"dontexpand" },
		{ VM_RESERVED,	"reserved" },
		{ VM_ACCOUNT,	"account" },
		{ VM_HUGETLB,	"hugetlb" },

		{ 0,		NULL }
	};

	memread(addr, sizeof(vma), &vma, "vm_area_struct");

	if (!full) {
		mprintf(FPTR " " FPTR " " FPTR " " FPTR " ",
			addr, vma.vm_start, vma.vm_end, vma.vm_file);
		mprintbit(vmflags, vma.vm_flags);
		mprintf("\n");
		return (addr_t)vma.vm_next;
	}
	mprintf("addr:           " FPTR "\n", addr);

	mprintf("vm_mm:          " FPTR "\n", vma.vm_mm);
	mprintf("vm_start:       " FPTR "\n", vma.vm_start);
	mprintf("vm_end:         " FPTR "\n", vma.vm_end);
	mprintf("vm_next:        " FPTR "\n", vma.vm_next);
	mprintf("vm_flags:      ");
	mprintbit(vmflags, vma.vm_flags);
	mprintf("\n");
#if 0 /*XXX <=2.6.5 */
	mprintf("shared:         " FPTR "\n", vma.shared.next);
#endif
	mprintf("vm_ops:         " FPTR "\n", vma.vm_ops);
	mprintf("vm_pgoff:       " FPTR "\n", vma.vm_pgoff);
	mprintf("vm_file:        " FPTR "\n", vma.vm_file);
	mprintf("vm_private_data:" FPTR "\n", vma.vm_private_data);
	return (addr_t)vma.vm_next;
}

void
print_gfp(gfp)
	int gfp;
{
	const char *p = NULL;

	mprintbit(gfpbit, gfp);
	switch (gfp) {
	case GFP_ATOMIC:	p = "ATOMIC";	break;
	case GFP_NOIO:		p = "NOIO";	break;
	case GFP_NOFS:		p = "NOFS";	break;
	case GFP_KERNEL:	p = "KERNEL";	break;
#if GFP_USER != GFP_KERNEL
	case GFP_USER:		p = "USER";	break;
#endif
	case GFP_HIGHUSER:	p = "HIGHUSER";	break;
	case GFP_DMA:		p = "DMA";	break;
	}
	if (p) {
		mprintf("  (GFP_%s)\n", p);
	} else {
		mprintf("\n");
	}
}
