/*
 * Copyright (C) 2005 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/types.h>
#include <linux/ext3_fs_sb.h>

#include "flags_ext3_fs_sb.h"

void
prhead_ext3_sb_info()
{
}

addr_t
print_ext3_sb_info(addr, full)
	addr_t addr;
	int full;
{
	struct ext3_sb_info si;

	memread(addr, sizeof(si), &si, "ext3_sb_info");
	mprintf(FPTR "  (%x)\n", addr, sizeof(si));

	mprintf("frag_size:            %lx\n", si.s_frag_size);
	mprintf("frags_per_block:      %lx\n", si.s_frags_per_block);
	mprintf("inodes_per_block:     %lx\n", si.s_inodes_per_block);
	mprintf("frags_per_group:      %lx\n", si.s_frags_per_group);
	mprintf("blocks_per_group:     %lx\n", si.s_blocks_per_group);
	mprintf("inodes_per_group:     %lx\n", si.s_inodes_per_group);
	mprintf("itb_per_group:        %lx\n", si.s_itb_per_group);
	mprintf("gdb_count:            %lx\n", si.s_gdb_count);
	mprintf("desc_per_block:       %lx\n", si.s_desc_per_block);
	mprintf("groups_count:         %lx\n", si.s_groups_count);
	mprintf("sbh:                  " FPTR "  (buffer_head)\n", si.s_sbh);
	mprintf("es:                   " FPTR "  (ext3_super_block)\n", si.s_es);
	mprintf("group_desc:           " FPTR "\n", si.s_group_desc);
	mprintf("loaded_inode_bitmaps: %x\n", si.s_loaded_inode_bitmaps);
	mprintf("loaded_block_bitmaps: %x\n", si.s_loaded_block_bitmaps);
	mprintf("mount_opt:            %lx\n", si.s_mount_opt);
	mprintf("resuid/resgid:        %d / %d\n", si.s_resuid, si.s_resgid);
	mprintf("mount_state:          %x\n", si.s_mount_state);
	mprintf("addr_per_block_bits:  %x\n", si.s_addr_per_block_bits);
	mprintf("desc_per_block_bits:  %x\n", si.s_desc_per_block_bits);
	mprintf("inode_size:           %x\n", si.s_inode_size);
	mprintf("first_ino:            %x\n", si.s_first_ino);
#ifdef _ext3_sb_info_has_s_next_generation
	mprintf("next_generation:      %x\n", si.s_next_generation);
#endif
	mprintf("journal_inode         " FPTR "  (inode)\n", si.s_journal_inode);
	mprintf("journal:              " FPTR "  (journal)\n", si.s_journal);
	mprintf("commit_interval:      %lx\n", si.s_commit_interval);
	mprintf("journal_bdev:         " FPTR "  (block_device)\n", si.journal_bdev);

	return (addr_t)0;
}
