/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <xfs.h>
#include <xfs_inum.h>
#include <xfs_log.h>
#include <xfs_trans.h>
#include <xfs_sb.h>
#include <xfs_ag.h>
#if 0
#include <xfs_dir.h>
#include <xfs_dir2.h>
#include <xfs_dmapi.h>
#include <xfs_mount.h>
#include <xfs_bmap_btree.h>
#include <xfs_attr_sf.h>
#include <xfs_dir_sf.h>
#include <xfs_dir2_sf.h>
#include <xfs_dinode.h>
#include <xfs_inode.h>

#include "flags_mount.h"
#endif

void
prhead_xfs_perag_busy()
{
	mprintf("  ## " SPTR "    START   LENGTH " SPTR "\n", "ADDR", "TP");
}

void
print_xfs_perag_busy(addr, n)
	addr_t addr;
	int n;
{
	struct xfs_perag_busy bsy;
	memread(addr, sizeof(bsy), &bsy, "xfs_perag_busy_t");
	if (bsy.busy_tp)
		mprintf("  %2x " FPTR " %8x %8x " FPTR "\n", n, addr,
			bsy.busy_start, bsy.busy_length, bsy.busy_tp);
}

addr_t
print_xfs_perag(addr, flags)
	addr_t addr;
	int flags;
{
	struct xfs_perag pag;
	int i;

	memread(addr, sizeof(pag), &pag, "xfs_perag_t");
	mprintf("addr          " FPTR "  (%x)\n", addr, sizeof(pag));
	mprintf("agf_init      %x\n", pag.pagf_init);
	mprintf("agi_init      %x\n", pag.pagi_init);
	mprintf("agf_metadata  %x\n", pag.pagf_metadata);
	mprintf("agf_levels   ");
	for (i = 0; i < XFS_BTNUM_AGF; i++) {
		mprintf(" %2x", pag.pagf_levels[i]);
	}
	mprintf("\n");
	mprintf("agf_freeblks  %x\n", pag.pagf_freeblks);
	mprintf("agf_longest   %x\n", pag.pagf_longest);
	mprintf("agi_freecount %x\n", pag.pagi_freecount);
	mprintf("agb_list      " FPTR "\n", pag.pagb_list);

#ifdef XFS_PAGB_NUM_SLOTS
	if (pag.pagf_init && pag.pagb_list) {
		prhead_xfs_perag_busy();
		for (i = 0; i < XFS_PAGB_NUM_SLOTS; i++) {
			print_xfs_perag_busy(pag.pagb_list + i, i);
		}
	}
#endif

	return 0;
}
