/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/mm.h>
#include <linux/mmzone.h>

#include "flags_mmzone.h"

void
prhead_zone()
{
	mprintf(SPTR" FREEPG "SPTR" "SPTR"  S_PADDR  S_MAPNR   SIZE NAME\n",
		"ADDR", "PGDAT", "MEM_MAP");
}

addr_t
print_zone(addr, full)
	addr_t addr;
	int full;
{
	zone_t zone;
	char buf[256];
	int i;

	memread(addr, sizeof(zone), &zone, "zone");
	if (!full) {
		mprintf(FPTR " %6lx " FPTR " " FPTR " ",
			addr, zone.free_pages,
			zone.zone_pgdat, zone.zone_mem_map);
		mprintf("%8lx %8lx ",
			zone.zone_start_paddr, zone.zone_start_mapnr);
#ifdef _zone_struct_has_size
		mprintf("%6lx ", zone.size);
#else
#ifdef _zone_struct_has_memsize
		mprintf("%6lx ", zone.memsize);
#endif
#endif /*_zone_struct_has_size*/
		memread((addr_t)zone.name, sizeof(buf), &buf, "name");
		mprintstr(buf, sizeof(buf));
		mprintf("\n");
		return 0;
	}

	mprintf("addr    " FPTR "\n", addr);
	if (addr == 0) {
		mprintf("\n");
		return 0;
	}

	mprintf("free_pages         %lx\n", zone.free_pages);

#if SUBLEVEL<10
	mprintf("inactive_clean_pages %lx\n", zone.inactive_clean_pages);
	mprintf("inactive_dirty_pages %lx\n", zone.inactive_dirty_pages);
#endif

#ifdef _zone_struct_has_watermarks /*SUBLEVEL>=23*/
	for (i = 0; i < MAX_NR_ZONES; i++) {
		mprintf("watermarks[%2d]     %x/%x/%x\n",
			zone.watermarks[i].min,
			zone.watermarks[i].low,
			zone.watermarks[i].high);
	}
#else
	mprintf("pages_min/low/high %lx/%lx/%lx\n",
		zone.pages_min, zone.pages_low, zone.pages_high);
#endif

#if SUBLEVEL>=10
	mprintf("need_balance       %x\n", zone.need_balance);
#endif

#if SUBLEVEL<10
	mprintf("inactive_clean_list " FPTR " " FPTR "\n",
		zone.inactive_clean_list.next, zone.inactive_clean_list.prev);
#endif

	mprintf("FREE " SPTR " " SPTR "  " SPTR "\n", "NEXT", "PREV", "MAP");
	for (i = 0; i < MAX_ORDER; i++) {
		free_area_t *fp = &zone.free_area[i];
		mprintf("%3x  ", i);
		if ((addr_t)fp->free_list.next == addr + OFFSET(zone_t, free_area[i].free_list)) {
			mprintf(SPTR " ", "-");
		} else {
			mprintf(FPTR " ", fp->free_list.next);
		}
		if ((addr_t)fp->free_list.prev == addr + OFFSET(zone_t, free_area[i].free_list)) {
			mprintf(SPTR " ", "-");
		} else {
			mprintf(FPTR " ", fp->free_list.prev);
		}
		mprintf(" " FPTR "\n", fp->map);
	}
#ifdef _zone_struct_has_wait_table
	mprintf("wait_table         " FPTR "\n", zone.wait_table);
#endif
#ifdef _zone_struct_has_wait_table_size
	mprintf("wait_table_size    " FPTR "\n", zone.wait_table_size);
#endif
	mprintf("zone_pgdat         " FPTR "\n", zone.zone_pgdat);
	mprintf("zone_mem_map       " FPTR "\n", zone.zone_mem_map);
	mprintf("zone_start_paddr   %lx\n", zone.zone_start_paddr);
	mprintf("zone_start_mapnr   %lx\n", zone.zone_start_mapnr);

	mprintf("name               \"");
	memread((addr_t)zone.name, sizeof(buf), &buf, "name");
	mprintstr(buf, sizeof(buf));
	mprintf("\"\n");
#ifdef _zone_struct_has_size
	mprintf("size               %lx\n", zone.size);
#endif
#ifdef _zone_struct_has_totalsize
	mprintf("totalsize          %lx\n", zone.totalsize);
#endif
#ifdef _zone_struct_has_memsize
	mprintf("memsize            %lx\n", zone.memsize);
#endif
	return 0;
}

addr_t
get_zone_from_pglist_data(addr, n)
	addr_t addr;
	int n;
{
	struct pglist_data pg;

	memread(addr, sizeof(pg), &pg, "pglist_data");
	if (n < LENGTHOF(pg.node_zones)
#if SUBLEVEL>=10
	     && n < pg.nr_zones
#endif
	     ) {
		return addr + OFFSET(struct pglist_data, node_zones[n]);
	}
	return 0;
}

addr_t
print_pglist_data(addr)
	addr_t addr;
{
	struct pglist_data pg;
	char buf[256];
	int i, j;

	mprintf("addr        " FPTR "\n", addr);
	if (addr == 0) {
		mprintf("\n");
		return 0;
	}
	memread(addr, sizeof(pg), &pg, "pglist_data");

	mprintf("node_zones ");
	for (i = 0; i < LENGTHOF(pg.node_zones)
#if SUBLEVEL>=10
	     && i < pg.nr_zones
#endif
	     ; i++) {
		mprintf(" " FPTR "(", addr + OFFSET(struct pglist_data, node_zones[i]));
		if (pg.node_zones[i].name) {
			memread((addr_t)pg.node_zones[i].name, sizeof(buf), &buf, "name");
			mprintstr(buf, sizeof(buf));
		}
		mprintf(")");
	}
	mprintf("\n");
	for (i = 0; i < LENGTHOF(pg.node_zonelists); i++) {
		zonelist_t *zl = &pg.node_zonelists[i];
		mprintf("%3x ", i);
		for (j = 0; j < LENGTHOF(zl->zones); j++) {
			if (zl->zones[j] == 0) {
				break;
			}
			mprintf(" " FPTR, zl->zones[j]);
		}
		mprintf("\n");
	}
#if SUBLEVEL>=10
	mprintf("nr_zones          %x\n", pg.nr_zones);
#endif
	mprintf("node_mem_map      " FPTR "\n", pg.node_mem_map);
	mprintf("valid_addr_bitmap " FPTR "\n", pg.valid_addr_bitmap);
	mprintf("bdata             " FPTR "\n", pg.bdata);
	mprintf("node_start_paddr  %lx\n", pg.node_start_paddr);
	mprintf("node_start_mapnr  %lx\n", pg.node_start_mapnr);
	mprintf("node_size         %lx\n", pg.node_size);
	mprintf("node_id           %x\n", pg.node_id);
	mprintf("node_next         " FPTR "\n", pg.node_next);
	return (addr_t)pg.node_next;
}
