/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/binfmts.h>

void
prhead_binfmt()
{
	mprintf(SPTR " " SPTR " " SPTR " " SPTR " " SPTR " MIN_CORE  NAME\n",
		"ADDR", "MODULE", "LOAD_BIN", "LOAD_SHL", "COREDUMP");
}

addr_t
print_binfmt(addr, full)
	addr_t addr;
	int full;
{
	struct linux_binfmt binfmt;
	const char *p;

	mprintf(FPTR " ", addr);
	if (addr == 0) {
		mprintf("\n");
		return 0;
	}
	memread(addr, sizeof(binfmt), &binfmt, "binfmt");

	mprintf(FPTR " " FPTR " " FPTR " " FPTR " %8lx",
		binfmt.module, binfmt.load_binary, binfmt.load_shlib,
		binfmt.core_dump, binfmt.min_coredump);
	p = getsymstr(addr);
	if (p) {
		mprintf("  %s\n", p);
	} else {
		mprintf("\n");
	}
	return (addr_t)binfmt.next;
}
