package spring.sample.aop.pointcut;

import java.lang.reflect.Method;

import spring.sample.aop.MameTestBean;

import org.springframework.aop.ClassFilter;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.Pointcuts;
import org.springframework.aop.support.StaticMethodMatcherPointcut;

/**
 * Spring AOP Pointcut̃Tvł<br>
 * <PRE>
 *   MameTestBeansetter\bhΏۂƂAPointcut̃Tvł
 * </PRE>
 * @author MBeans
 * @version 1.0
 */
public class MamePointcutSample {

	public static Pointcut mameMethodsPointcut = new StaticMethodMatcherPointcut() {
		public ClassFilter getClassFilter() {
			return new ClassFilter() {
				public boolean matches(Class clazz) {
					return clazz.equals(MameTestBean.class);
				}
			};
		}

		public boolean matches(Method m, Class targetClass) {
			return m.getName().startsWith("set");
		}
	};

	public static void main(String[] args) {
		try {
			Method testSetterMethod = MameTestBean.class.getMethod("setName", new Class[] { String.class });
			Method testGetterMethod = MameTestBean.class.getMethod("getName", null);
			
			boolean settervalue = Pointcuts.matches(mameMethodsPointcut, testSetterMethod, MameTestBean.class, new Object[] { new String("6")});
			boolean gettervalue = Pointcuts.matches(mameMethodsPointcut, testGetterMethod, MameTestBean.class, null);
			
			System.out.println(testSetterMethod.getName() + " match " + settervalue);
			System.out.println(testGetterMethod.getName() + " match " + gettervalue);
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
