package spring.sample.aop.proxy;

import spring.sample.aop.*;

import org.springframework.aop.framework.ProxyFactory;

/**
 * Spring AOP Before AdviceAround AdvicẽTvłB<br>
 * <PRE>
 *   Before AdviceJoinpoint̑OɎsAdviceł
 * @Around AdviceJoinpoint̑OŎsAdvicełB
 * 
 * @(TvœoꂷAOP̊TOƁATvł̃NX)
 * @Around Advice :  LogAroundInterceptorNX
 * @Before Advice :  LogBeforeAdviceNX
 * @Pointcut      :  LogPointcutAdvisorNXɊ܂܂Ă܂
 *   Advisor	   :  LogPointcutAdvisorNX
 * </PRE>
 * @author MBeans
 * @version 1.0
 */
public class BeforeAdviceSample {

	public static void main(String[] args) {
		try {

			MameTestBean target = new MameTestBean();
			ProxyFactory factory = new ProxyFactory(target);
						
			LogAroundInterceptor interceptor = new LogAroundInterceptor();
			LogBeforeAdvice advice = new LogBeforeAdvice();
			LogPointcutAdvisor advisor = new LogPointcutAdvisor();
			advisor.setAdvice(advice);
			factory.addAdvisor(advisor);
			factory.addInterceptor(interceptor);

			IMameTestBean proxied = (IMameTestBean) factory.getProxy();

			proxied.setName("0");
			proxied.getName();
			proxied.setName("1");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
