/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.pool;

import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.enhydra.jdbc.pool.GenerationObject;
import org.enhydra.jdbc.pool.StandardPoolDataSource;
import org.enhydra.jdbc.standard.StandardXAConnection;
import org.enhydra.jdbc.standard.StandardXADataSource;

public class StandardXAPoolDataSource
extends StandardPoolDataSource {
    public XADataSource xads;
    public TransactionManager transactionManager;
    public Log glog = LogFactory.getLog((String)"org.enhydra.jdbc.xapool");

    public StandardXAPoolDataSource() {
    }

    public StandardXAPoolDataSource(int initSize) {
        super(initSize);
    }

    public StandardXAPoolDataSource(StandardXADataSource ds) {
        super(ds);
    }

    public StandardXAPoolDataSource(StandardXADataSource ds, int initSize) {
        super(ds, initSize);
    }

    public void setTransactionManager(TransactionManager tm) {
        this.log.debug("StandardXAPoolDataSource:setTransactionManager");
        this.transactionManager = tm;
    }

    public void connectionClosed(ConnectionEvent event) {
        Object obj = event.getSource();
        this.log.debug("StandardXAPoolDataSource:connectionClosed");
        XAConnection xac = (XAConnection)obj;
        Transaction tx = null;
        try {
            if (this.transactionManager == null) {
                TransactionManager tm = ((StandardXADataSource)this.xads).getTransactionManager();
                if (tm == null) {
                    throw new NullPointerException("TM is null");
                }
                tx = tm.getTransaction();
            } else {
                tx = this.transactionManager.getTransaction();
            }
            this.log.debug("StandardXAPoolDataSource:connectionClosed get a transaction");
        }
        catch (NullPointerException n) {
            this.log.error("StandardXAPoolDataSource:connectionClosed should not be used outside an EJBServer");
        }
        catch (SystemException e) {
            this.log.error("StandardXAPoolDataSource:connectionClosed getTransaction failed:" + (Object)((Object)e));
        }
        if (tx != null && ((StandardXAConnection)xac).connectionHandle.isReallyUsed) {
            try {
                tx.delistResource(xac.getXAResource(), 0x4000000);
                this.log.debug("StandardXAPoolDataSource:connectionClosed the resourse is delisted");
            }
            catch (Exception e) {
                this.log.error("StandardXAPoolDataSource:connectionClosed Exception in connectionClosed:" + e);
            }
        }
        this.log.debug("StandardXAPoolDataSource:connectionClosed checkIn an object to the pool");
        this.pool.checkIn(obj);
    }

    public GenerationObject create(String _user, String _password) throws SQLException {
        XAConnection xaCon = this.xads.getXAConnection(_user, _password);
        xaCon.addConnectionEventListener(this);
        this.log.debug("StandardXAPoolDataSource:create create a object for the pool");
        GenerationObject genObject = new GenerationObject(xaCon, this.pool.getGeneration(), _user, _password);
        return genObject;
    }

    public Reference getReference() throws NamingException {
        this.log.debug("StandardXAPoolDataSource:getReference return a reference of the object");
        Reference ref = super.getReference();
        ref.add(new StringRefAddr("transactionManagerName", "TransactionManager"));
        return ref;
    }

    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws Exception {
        super.getObjectInstance(refObj, name, nameCtx, env);
        Reference ref = (Reference)refObj;
        InitialContext ictx = new InitialContext(env);
        this.setTransactionManager((TransactionManager)ictx.lookup("javax.transaction.TransactionManager"));
        this.setDataSource((XADataSource)ictx.lookup(this.dataSourceName));
        this.log.debug("StandardPoolDataSource:getObjectInstance: instance created");
        return this;
    }

    public XADataSource getDataSource() {
        return this.xads;
    }

    public void setDataSource(XADataSource dataSource) {
        this.xads = dataSource;
        if (this.transactionManager != null) {
            ((StandardXADataSource)dataSource).setTransactionManager(this.transactionManager);
        }
    }
}

