/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptRunner {
    private static final Log log = LogFactory.getLog((Class)(class$com$ibatis$db$util$ScriptRunner == null ? (class$com$ibatis$db$util$ScriptRunner = ScriptRunner.class$("com.ibatis.db.util.ScriptRunner")) : class$com$ibatis$db$util$ScriptRunner));
    public String driver;
    public String url;
    public String username;
    public String password;
    public boolean stopOnError;
    public boolean autoCommit;
    public PrintWriter logWriter = new PrintWriter(System.out);
    public PrintWriter errorLogWriter = new PrintWriter(System.err);
    static /* synthetic */ Class class$com$ibatis$db$util$ScriptRunner;

    public ScriptRunner() {
        this.stopOnError = false;
        this.autoCommit = false;
    }

    public ScriptRunner(Map map) {
        this.setDriver((String)map.get("driver"));
        this.setUrl((String)map.get("url"));
        this.setUsername((String)map.get("username"));
        this.setPassword((String)map.get("password"));
        this.setStopOnError("true".equals(map.get("stopOnError")));
        this.setAutoCommit("true".equals(map.get("autoCommit")));
    }

    public ScriptRunner(String string, String string2, String string3, String string4) {
        this.driver = string;
        this.url = string2;
        this.username = string3;
        this.password = string4;
        this.autoCommit = false;
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(boolean bl) {
        this.stopOnError = bl;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean bl) {
        this.autoCommit = bl;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public PrintWriter getErrorLogWriter() {
        return this.errorLogWriter;
    }

    public void setErrorLogWriter(PrintWriter printWriter) {
        this.errorLogWriter = printWriter;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void runScript(Reader reader) throws Exception {
        DriverManager.registerDriver((Driver)Class.forName(this.driver).newInstance());
        Connection connection = DriverManager.getConnection(this.url, this.username, this.password);
        if (connection.getAutoCommit() != this.autoCommit) {
            connection.setAutoCommit(this.autoCommit);
        }
        this.runScript(connection, reader);
        connection.close();
    }

    public void runScript(Connection connection, Reader reader) throws IOException, SQLException {
        StringBuffer stringBuffer = null;
        try {
            block21: {
                try {
                    LineNumberReader lineNumberReader = new LineNumberReader(reader);
                    String string = null;
                    while ((string = lineNumberReader.readLine()) != null) {
                        String string2;
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        }
                        if ((string2 = string.trim()).startsWith("--")) {
                            this.println(string2);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)string2);
                            continue;
                        }
                        if (string2.length() < 1 || string2.startsWith("//")) continue;
                        if (string2.endsWith(";")) {
                            stringBuffer.append(string.substring(0, string.lastIndexOf(";")));
                            stringBuffer.append(" ");
                            Statement statement = connection.createStatement();
                            this.println(stringBuffer);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)stringBuffer);
                            }
                            boolean bl = false;
                            if (this.stopOnError) {
                                bl = statement.execute(stringBuffer.toString());
                            } else {
                                try {
                                    statement.execute(stringBuffer.toString());
                                }
                                catch (SQLException sQLException) {
                                    sQLException.fillInStackTrace();
                                    this.printlnError("Error executing: " + stringBuffer);
                                    this.printlnError(sQLException);
                                }
                            }
                            if (this.autoCommit && !connection.getAutoCommit()) {
                                connection.commit();
                            }
                            ResultSet resultSet = statement.getResultSet();
                            if (bl && resultSet != null) {
                                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                                int n = resultSetMetaData.getColumnCount();
                                int n2 = 0;
                                while (n2 < n) {
                                    String string3 = resultSetMetaData.getColumnName(n2);
                                    this.print(string3 + "\t");
                                    ++n2;
                                }
                                this.println("");
                                while (resultSet.next()) {
                                    int n3 = 0;
                                    while (n3 < n) {
                                        String string4 = resultSet.getString(n3);
                                        this.print(string4 + "\t");
                                        ++n3;
                                    }
                                    this.println("");
                                }
                            }
                            stringBuffer = null;
                            try {
                                statement.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            Thread.yield();
                            continue;
                        }
                        stringBuffer.append(string);
                        stringBuffer.append(" ");
                    }
                    if (this.autoCommit) break block21;
                    connection.commit();
                }
                catch (SQLException sQLException) {
                    sQLException.fillInStackTrace();
                    this.printlnError("Error executing: " + stringBuffer);
                    this.printlnError(sQLException);
                    log.error((Object)("Error executing: " + stringBuffer), (Throwable)sQLException);
                    throw sQLException;
                }
                catch (IOException iOException) {
                    iOException.fillInStackTrace();
                    this.printlnError("Error executing: " + stringBuffer);
                    this.printlnError(iOException);
                    log.error((Object)("Error executing: " + stringBuffer), (Throwable)iOException);
                    throw iOException;
                }
            }
            Object var16_20 = null;
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            connection.rollback();
            this.flush();
            throw throwable;
        }
        connection.rollback();
        this.flush();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.out.println("Usage: java com.ibatis.db.util.ScriptRunner <scriptrunner.properties>");
        } else {
            File file = new File(stringArray[0]);
            if (!file.exists()) {
                System.out.println(stringArray[0] + " not found.");
                System.out.println("Usage: java com.ibatis.db.util.ScriptRunner <scriptrunner.properties>");
            } else {
                String string;
                Object object;
                FileInputStream fileInputStream = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                fileInputStream.close();
                ScriptRunner scriptRunner = new ScriptRunner(properties);
                TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    if (!((String)object).startsWith("file-")) continue;
                    scriptRunner.println("");
                    scriptRunner.printlnError("");
                    string = properties.getProperty((String)object);
                    treeMap.put(Integer.valueOf(((String)object).substring(5, ((String)object).length())), string);
                }
                object = treeMap.keySet().iterator();
                while (object.hasNext()) {
                    string = (String)treeMap.get(object.next());
                    scriptRunner.println("Running Script: " + string);
                    scriptRunner.printlnError("Running Script: " + string);
                    scriptRunner.runScript(new FileReader(string));
                    scriptRunner.printlnError("");
                }
            }
        }
    }

    private void print(Object object) {
        if (this.logWriter != null) {
            System.out.print(object);
        }
    }

    private void println(Object object) {
        if (this.logWriter != null) {
            this.logWriter.println(object);
        }
    }

    private void printlnError(Object object) {
        if (this.errorLogWriter != null) {
            this.errorLogWriter.println(object);
        }
    }

    private void flush() {
        if (this.logWriter != null) {
            this.logWriter.flush();
        }
        if (this.errorLogWriter != null) {
            this.errorLogWriter.flush();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

