/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.xml;

import com.ibatis.common.beans.StaticBeanProbe;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class XmlBeanEncoder {
    private String tab = "  ";
    private boolean typeIncluded = true;

    public String getTab() {
        return this.tab;
    }

    public void setTab(String string) {
        this.tab = string;
    }

    public boolean isTypeIncluded() {
        return this.typeIncluded;
    }

    public void setTypeIncluded(boolean bl) {
        this.typeIncluded = bl;
    }

    public String encodeBeanToXml(String string, Object object, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = StaticBeanProbe.getReadablePropertyNames(object);
        if (this.typeIncluded) {
            stringBuffer.append("\n" + this.tabs(n) + "<" + string + " type=\"" + object.getClass().getName() + "\">");
        } else {
            stringBuffer.append("\n" + this.tabs(n) + "<" + string + ">");
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            Object object2 = StaticBeanProbe.getObject(object, string2);
            if (object2 == null) {
                if (this.typeIncluded) {
                    stringBuffer.append("\n" + this.tabs(n + 1) + "<" + string2 + " type=\"" + StaticBeanProbe.getPropertyTypeForGetter(object, string2).getName() + "\"></" + string2 + ">");
                } else {
                    stringBuffer.append("\n" + this.tabs(n + 1) + "<" + string2 + "></" + string2 + ">");
                }
            } else if (XmlBeanEncoder.isBasicType(object2)) {
                stringBuffer.append(this.tagValue(object, string2, object2, n + 1));
            } else if (object2 instanceof Collection) {
                this.handleCollection(stringBuffer, n, string2, object2);
            } else {
                this.encodeBeanToXml(string2, object2, n + 1);
            }
            ++n2;
        }
        stringBuffer.append("\n" + this.tabs(n) + "</" + string + ">");
        return stringBuffer.toString();
    }

    private void handleCollection(StringBuffer stringBuffer, int n, String string, Object object) {
        if (this.typeIncluded) {
            stringBuffer.append("\n" + this.tabs(n + 1) + "<" + string + " type=\"" + object.getClass().getName() + "\">");
        } else {
            stringBuffer.append("\n" + this.tabs(n + 1) + "<" + string + ">");
        }
        Iterator iterator = ((Collection)object).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (XmlBeanEncoder.isBasicType(e)) {
                stringBuffer.append(this.tagValue(e, string, object, n + 2));
                continue;
            }
            if (e instanceof Collection) {
                this.handleCollection(stringBuffer, n + 1, this.resolveClassName(e.getClass().getName()), e);
                continue;
            }
            stringBuffer.append(this.encodeBeanToXml(this.resolveClassName(e.getClass().getName()), e, n + 2));
        }
        stringBuffer.append("\n" + this.tabs(n + 1) + "</" + string + ">");
    }

    private String tagValue(Object object, String string, Object object2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append(this.tabs(n));
        stringBuffer.append("<");
        stringBuffer.append(string);
        if (this.typeIncluded) {
            stringBuffer.append(" ");
            stringBuffer.append("type=\"");
            stringBuffer.append(StaticBeanProbe.getPropertyTypeForGetter(object, string).getName());
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        if (object2 != null) {
            boolean bl;
            String string2 = object2.toString();
            boolean bl2 = bl = string2.indexOf("<") > -1 || string2.indexOf(">") > -1;
            if (bl) {
                stringBuffer.append("\n<![CDATA[\n");
            }
            stringBuffer.append(string2);
            if (bl) {
                stringBuffer.append("\n]]>\n");
            }
        }
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    private String tabs(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.tab);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static boolean isBasicType(Object object) {
        if (object instanceof String) {
            return true;
        }
        if (object instanceof Byte) {
            return true;
        }
        if (object instanceof Short) {
            return true;
        }
        if (object instanceof Character) {
            return true;
        }
        if (object instanceof Integer) {
            return true;
        }
        if (object instanceof Long) {
            return true;
        }
        if (object instanceof Float) {
            return true;
        }
        if (object instanceof Double) {
            return true;
        }
        if (object instanceof Boolean) {
            return true;
        }
        if (object instanceof Date) {
            return true;
        }
        if (object instanceof String) {
            return true;
        }
        if (object instanceof Class) {
            return true;
        }
        if (object instanceof BigInteger) {
            return true;
        }
        return object instanceof BigDecimal;
    }

    private String resolveClassName(String string) {
        if (string.indexOf(".") < 0) {
            return string.toLowerCase();
        }
        return string.substring(string.lastIndexOf(".") + 1).toLowerCase();
    }
}

