/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ResourceEntityResolver;
import org.xml.sax.EntityResolver;

public abstract class AbstractXmlApplicationContext
extends AbstractApplicationContext {
    private ConfigurableListableBeanFactory beanFactory;

    public AbstractXmlApplicationContext() {
    }

    public AbstractXmlApplicationContext(ApplicationContext parent) {
        super(parent);
    }

    protected void refreshBeanFactory() throws BeansException {
        try {
            DefaultListableBeanFactory beanFactory = this.createBeanFactory();
            XmlBeanDefinitionReader beanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
            beanDefinitionReader.setEntityResolver((EntityResolver)((Object)new ResourceEntityResolver(this)));
            this.initBeanDefinitionReader(beanDefinitionReader);
            this.loadBeanDefinitions(beanDefinitionReader);
            this.beanFactory = beanFactory;
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Bean factory for application context '" + this.getDisplayName() + "': " + beanFactory));
            }
        }
        catch (IOException ex) {
            throw new ApplicationContextException("I/O error parsing XML document for application context [" + this.getDisplayName() + "]", ex);
        }
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        return new DefaultListableBeanFactory((BeanFactory)this.getParent());
    }

    public ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected void initBeanDefinitionReader(XmlBeanDefinitionReader beanDefinitionReader) {
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws BeansException, IOException {
        String[] configLocations = this.getConfigLocations();
        if (configLocations != null) {
            for (int i = 0; i < configLocations.length; ++i) {
                reader.loadBeanDefinitions(this.getResource(configLocations[i]));
            }
        }
    }

    protected abstract String[] getConfigLocations();
}

